/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.spdb.dc.services.note.payable.receive;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.spdb.dc.BankBusinessConfig;
import kd.ebg.note.banks.spdb.dc.services.note.payable.receive.QueryReceiveNotePayableImpl;
import kd.ebg.note.banks.spdb.dc.services.util.Packer;
import kd.ebg.note.banks.spdb.dc.services.util.Parser;
import kd.ebg.note.banks.spdb.dc.services.util.Signature;
import kd.ebg.note.banks.spdb.dc.services.util.Utils;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class ReceiveNotePayableImpl
extends AbstractNotePayableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiveNotePayableImpl.class);

    public int getBatchSize() {
        return 20;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryReceiveNotePayableImpl.class;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        this.logger.info("\u63d0\u793a\u6536\u7968\u6253\u5305\u5f00\u59cb");
        List notePayableInfos = request.getNotePayableInfoList();
        int length = notePayableInfos.size();
        NotePayableInfo info = (NotePayableInfo)notePayableInfos.get(0);
        Element body = new Element("body");
        BigDecimal totalAmount = BigDecimal.ZERO;
        String transID = BankBusinessConfig.getPayMasterID(request.getAcnt().getAccNo());
        if (transID == null) {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)RequestContextUtils.getBankParameterValue((String)"masterIds"));
        } else {
            JDomUtils.addChild((Element)body, (String)"transMasterID", (String)transID);
        }
        JDomUtils.addChild((Element)body, (String)"totalNumber", (String)Utils.fixed(length + "", " ", 4, false));
        JDomUtils.addChild((Element)body, (String)"eBillType", (String)info.getDraftType());
        boolean isSameBank = false;
        if (info.getAcceptorBankName() != null && SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)info.getAcceptorBankName()).equals("1")) {
            isSameBank = true;
        }
        JDomUtils.addChild((Element)body, (String)"eDrawerType", (String)"RC01");
        JDomUtils.addChild((Element)body, (String)"eDrawerName");
        JDomUtils.addChild((Element)body, (String)"eDrawerOrgId");
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)info.getDrawerAccNo());
        JDomUtils.addChild((Element)body, (String)"eDrawerBankNo");
        JDomUtils.addChild((Element)body, (String)"eBillingType");
        JDomUtils.addChild((Element)body, (String)"summaryEBillFlag");
        JDomUtils.addChild((Element)body, (String)"discountingEBillFlag");
        JDomUtils.addChild((Element)body, (String)"bargainNo");
        JDomUtils.addChild((Element)body, (String)"remark");
        Element cycle = Packer.creatCycleMessage();
        JDomUtils.addChild((Element)body, (Element)cycle);
        for (NotePayableInfo p : notePayableInfos) {
            Element list = JDomUtils.addChild((Element)cycle, (String)"list");
            JDomUtils.addChild((Element)list, (String)"sequenceNo", (String)String.format("%04d", notePayableInfos.indexOf(p)));
            JDomUtils.addChild((Element)list, (String)"billNo", (String)p.getBillNo());
            JDomUtils.addChild((Element)list, (String)"voteDate", (String)p.getBookingDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)list, (String)"expiryDate", (String)p.getDueDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)list, (String)"acceptorName", (String)p.getAcceptorAccName());
            JDomUtils.addChild((Element)list, (String)"acceptorAcctNo", (String)p.getAcceptorAccNo());
            JDomUtils.addChild((Element)list, (String)"acceptorBankNo", (String)p.getAcceptorBankCnaps());
            JDomUtils.addChild((Element)list, (String)"applyAcceptanceAmount", (String)p.getAmount().toString());
            JDomUtils.addChild((Element)list, (String)"canTransferFlag", (String)p.getTransferFlag());
            JDomUtils.addChild((Element)list, (String)"ePayeeAcctName", (String)p.getPayeeAccName());
            JDomUtils.addChild((Element)list, (String)"ePayeeAcctNo", (String)p.getPayeeAccNo());
            JDomUtils.addChild((Element)list, (String)"ePayeeBankNo", (String)p.getPayeeBankCnaps());
            totalAmount = p.getAmount().add(totalAmount);
        }
        JDomUtils.addChild((Element)body, (String)"totalAmount", (String)(totalAmount + ""));
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("EE04", signedMsg);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        this.logger.info("\u63d0\u793a\u6536\u7968\u89e3\u6790\u5f00\u59cb");
        List infos = request.getNotePayableInfoList();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = Parser.parseResponse(root);
        if (rsp.getResponseCode().startsWith("EYY")) {
            Element body = root.getChild("body");
            String message = body.getChildTextTrim("returnMsg");
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)message);
            return infos;
        }
        String rspData = Signature.getInstance().validateSignedData(responseStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)encoding);
        if ("AAAAAAA".equals(rsp.getResponseCode())) {
            String businessId = body.getChildText("businessId");
            if (StringUtils.isEmpty((String)businessId)) {
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968\u636e\u94f6\u884c\u672a\u8fd4\u56debusinessId,\u94f6\u4f01\u7968\u636e\u6d41\u7a0b\u65e0\u6cd5\u7ee7\u7eed", (String)"ReceiveNotePayableImpl_2", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
            } else {
                for (NotePayableInfo info : infos) {
                    info.setObssid(businessId);
                }
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)rsp.getResponseCode(), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"ReceiveNotePayableImpl_3", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]));
            }
        } else {
            String message = body.getChildTextTrim("returnMsg");
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)message);
        }
        return infos;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968", (String)"ReceiveNotePayableImpl_4", (String)"ebg-note-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }
}

