/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note;

import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class NoteCommonParser {
    public static void parsePayable(List<NotePayableInfo> infos, String rspStr) {
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if ("000000".equals(response.getResponseCode())) {
            String BkListNo1;
            Element TX_INFO;
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)response.getResponseCode(), (String)String.format(ResManager.loadKDString((String)"%s\u63d0\u4ea4\u94f6\u884c\u6210\u529f\u3002", (String)"NoteCommonParser_1", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]), response.getResponseMessage()));
            if (infos.size() > 30) {
                TX_INFO = root.getChild("TX_INFO");
                BkListNo1 = TX_INFO.getChildText("BkListNo1");
                EBGNotePayableUtils.setBatchNo(infos, (String)BkListNo1);
            }
            if (infos.size() > 1 && (TX_INFO = root.getChild("TX_INFO")) != null) {
                BkListNo1 = TX_INFO.getChildText("BkListNo1");
                EBGNotePayableUtils.setBatchNo(infos, (String)BkListNo1);
            }
        } else if ("YCEECDA65156".equals(response.getResponseCode())) {
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            EBGNotePayableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
    }

    public static void parsePay(List<NoteReceivableInfo> infos, String rspStr) {
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if ("000000".equals(response.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)response.getResponseCode(), (String)response.getResponseMessage());
            if (infos.size() > 1) {
                Element TX_INFO = root.getChild("TX_INFO");
                String BkListNo1 = TX_INFO.getChildText("BkListNo1");
                EBGNoteReceivableUtils.setNoteBatchNo(infos, (String)BkListNo1);
            }
        } else if ("YCEECDB63007".equals(response.getResponseCode()) || "YCEECDA65007".equals(response.getResponseCode()) || "YBLECDA10000".equals(response.getResponseCode()) || "0130Z110WH01".equals(response.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        for (NoteReceivableInfo info : infos) {
            info.setBankRefDate(LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
        }
    }

    public static void parsePayMayFail(List<NoteReceivableInfo> infos, String rspStr) {
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if ("000000".equals(response.getResponseCode())) {
            Element TX_INFO = root.getChild("TX_INFO");
            Element detaillist = TX_INFO.getChild("DETAILLIST");
            List lists = detaillist.getChildren("DETAILINFO");
            String bkflg1 = ((Element)lists.get(0)).getChildText("BkFlag1");
            if ("01".equals(bkflg1)) {
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.SUBMITED, (String)response.getResponseCode(), (String)response.getResponseMessage());
            } else {
                EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)response.getResponseCode(), (String)response.getResponseMessage());
            }
        } else if ("YCEECDB63007".equals(response.getResponseCode())) {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.FAIL, (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            EBGNoteReceivableUtils.setPaymentState(infos, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
    }
}

