/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.receivable.cancel;

import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.banks.ccb.dc.services.note.QueryNoteStatusPacker;
import kd.ebg.note.banks.ccb.dc.services.note.receivable.cancel.QueryCancleTypeUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractQueryNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.bank.EBBankNoteReceivableResponse;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class QueryCancleNoteReceivableImpl
extends AbstractQueryNoteReceivableImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QueryCancleNoteReceivableImpl.class);
    public static final int PAGE_SIZE = 200;

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)noteReceivableInfos.get(0);
        Element header = CCB_DC_Packer.createTransactionHeader("6WH042", info.getBankBatchSeqId());
        Element tx = JDomUtils.addChild((Element)header, (String)"TX_INFO");
        JDomUtils.addChild((Element)tx, (String)"BkType1", (String)"AC01");
        String signDate4Test = RequestContextUtils.getBankParameterValue((String)"TEST_DATE");
        if (StringUtils.isEmpty((String)signDate4Test)) {
            JDomUtils.addChild((Element)tx, (String)"Bk8Date1", (String)info.getRedemptionEDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)tx, (String)"Bk8Date2", (String)info.getRedemptionEDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        } else {
            JDomUtils.addChild((Element)tx, (String)"Bk8Date1", (String)signDate4Test);
            JDomUtils.addChild((Element)tx, (String)"Bk8Date2", (String)signDate4Test);
        }
        JDomUtils.addChild((Element)tx, (String)"PAGE", (String)pageTag);
        JDomUtils.addChild((Element)tx, (String)"PAGE_SIZE", (String)"200");
        return NoteCommonPacker.root2StringSafeMod(header);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        return null;
    }

    public int getBatchSize() {
        return 0;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        Integer page;
        Integer n = page = Integer.valueOf(Integer.parseInt(pageTag));
        Integer n2 = page = Integer.valueOf(page + 1);
        return page + "";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        boolean flag = false;
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        String rspCode = response.getResponseCode();
        String pageTotalNumStr = "";
        if ("000000".equals(rspCode)) {
            Element txBody = JDomUtils.getChildElement((Element)root, (String)"TX_INFO");
            pageTotalNumStr = JDomUtils.getChildText((Element)txBody, (String)"BkTotNum");
            this.logger.info("\u603b\u6570\u4e3a" + pageTotalNumStr);
            if (StringUtils.isEmpty((String)pageTotalNumStr) || "0".equals(pageTotalNumStr)) {
                flag = true;
            } else {
                Integer pageTotalNum = Integer.parseInt(pageTotalNumStr);
                Integer page = Integer.parseInt(pageTag);
                boolean bl = flag = page * 200 >= pageTotalNum;
                if (pageTotalNum < 200) {
                    flag = true;
                }
            }
        } else {
            flag = true;
        }
        this.logger.info("\u8fdb\u5165\u9884\u7ea6\u4ed8\u6b3e\u7ed3\u679c\u67e5\u8be2\u5206\u9875" + flag);
        return flag;
    }

    public EBBankNoteReceivableResponse doBiz(BankNoteReceivableRequest request) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        LocalDate nowLocalDate = ((NoteReceivableInfo)noteReceivableInfos.get(0)).getDueDate();
        Date duedate = Date.from(nowLocalDate.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
        Date succ = Date.from(nowLocalDate.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
        if ("20".equals(((NoteReceivableInfo)noteReceivableInfos.get(0)).getOperationCode()) && DateTimeUtils.dayAfter((Date)duedate, (Date)succ)) {
            return this.doBizWithPage(request);
        }
        return this.doBizNoPage(request);
    }

    public EBBankNoteReceivableResponse doBizWithPage(BankNoteReceivableRequest request) {
        boolean successClose = false;
        ArrayList<NoteReceivableInfo> list = new ArrayList<NoteReceivableInfo>();
        try {
            String pageTag = this.getFirstPageTag();
            String responseStr = "";
            boolean isfound = false;
            do {
                String requestStr = this.pack(request, pageTag);
                this.logger.info("\u53d1\u9001\u6570\u636e" + requestStr);
                ConnectionFactory factory = this.getConnectionFactory();
                IConnection connection = this.getConnection(factory);
                this.openConnection(connection);
                try (OutputStream outputStream = this.getOutputStream(connection);){
                    this.send(outputStream, requestStr);
                    try (InputStream inputStream = this.getInputStream(connection);){
                        responseStr = this.recv(inputStream);
                        this.logger.info("\u63a5\u6536\u5230\u6570\u636e" + responseStr);
                        isfound = this.parseQuery(list, responseStr);
                        pageTag = this.getNextPageTag(responseStr, pageTag);
                    }
                }
                catch (Throwable t) {
                    EBContext.getContext().setThrowableAfterSend(t);
                    return null;
                }
            } while (this.isLastPage(responseStr, pageTag));
            if (!isfound) {
                this.setSuccess(list);
            }
            return new EBBankNoteReceivableResponse(list);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7968\u636e\u4fe1\u606f\u4e1a\u52a1\u51fa\u73b0\u5f02\u5e38\u3002", (String)"QueryCancleNoteReceivableImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public boolean parseQuery(List<NoteReceivableInfo> noteReceivableInfos, String str) {
        NoteReceivableInfo noteReceivableinfo = noteReceivableInfos.get(0);
        Element root = CCB_DC_Parser.parseString2Root(str);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if (!response.getResponseCode().equals("000000")) {
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)noteReceivableinfo, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
            return false;
        }
        Element txBody = root.getChild("TX_INFO");
        Element detaillist = txBody.getChild("DETAILLIST");
        List lists = detaillist.getChildren("DETAILINFO");
        for (Element list : lists) {
            String BkListNo1 = JDomUtils.getChildTextTrim((Element)list, (String)"BkListNo1");
            if (!BkListNo1.equals(noteReceivableinfo.getBillNo())) continue;
            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)noteReceivableinfo, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
            return true;
        }
        return false;
    }

    public void setSuccess(List<NoteReceivableInfo> receivableInfos) {
        NoteReceivableInfo noteReceivableinfo = receivableInfos.get(0);
        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)noteReceivableinfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)ResManager.loadKDString((String)"\u9884\u7ea6\u63d0\u793a\u4ed8\u6b3e\u64a4\u9500\u6210\u529f", (String)"QueryCancleNoteReceivableImpl_1", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
    }

    /*
     * Exception decompiling
     */
    public EBBankNoteReceivableResponse doBizNoPage(BankNoteReceivableRequest request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String packNormal(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)noteReceivableInfos.get(0);
        String cancleType = QueryCancleTypeUtil.INSTANCE.convert2Bank(info.getOperationCode());
        if (StringUtils.isEmpty((String)cancleType)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u5c06\u94f6\u4f01\u7c7b\u578b%s\u8f6c\u6362\u4e3a\u94f6\u884c\u4ea4\u6613\u7c7b\u578b\u3002", (String)"QueryCancleNoteReceivableImpl_5", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]), info.getOperationCode()));
        }
        return QueryNoteStatusPacker.packQueryPay(noteReceivableInfos, cancleType);
    }

    public List<NoteReceivableInfo> parseQueryRece(BankNoteReceivableRequest request, String rsp) {
        List receivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo noteReceivableinfo = (NoteReceivableInfo)receivableInfos.get(0);
        Element root = CCB_DC_Parser.parseString2Root(rsp);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        if (!response.getResponseCode().equals("000000")) {
            EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else {
            Element txBody = root.getChild("TX_INFO");
            Element detaillist = txBody.getChild("DETAILLIST");
            List lists = detaillist.getChildren("DETAILINFO");
            for (NoteReceivableInfo info : receivableInfos) {
                for (Element list : lists) {
                    String BkListNo1 = JDomUtils.getChildTextTrim((Element)list, (String)"BkListNo1");
                    String BkFlag1 = JDomUtils.getChildTextTrim((Element)list, (String)"BkFlag1");
                    String BkFlag2 = JDomUtils.getChildTextTrim((Element)list, (String)"BkFlag2");
                    String BkSumry = JDomUtils.getChildTextTrim((Element)list, (String)"BkSumry");
                    if (BkFlag2.equals("00")) {
                        info.setNoteStatus(BkFlag1);
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)BkListNo1, (String)ResManager.loadKDString((String)"\u64a4\u9500\u64cd\u4f5c\u6210\u529f", (String)"QueryCancleNoteReceivableImpl_4", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
                        continue;
                    }
                    if (BkFlag2.equals("22") || BkFlag2.equals("03") || BkFlag2.equals("05") || BkFlag2.equals("09") || BkFlag2.equals("11") || BkFlag2.equals("14") || BkFlag2.equals("23")) {
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)BkListNo1, (String)BkSumry);
                        info.setNoteStatus(BkFlag1);
                        continue;
                    }
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)BkListNo1, (String)BkSumry);
                    info.setNoteStatus(BkFlag1);
                }
            }
        }
        return receivableInfos;
    }
}

