/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.ccb.dc.services.note.receivable.signin;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Packer;
import kd.ebg.note.banks.ccb.dc.services.CCB_DC_Parser;
import kd.ebg.note.banks.ccb.dc.services.note.NoteCommonPacker;
import kd.ebg.note.banks.ccb.dc.services.note.QueryNoteStatusPacker;
import kd.ebg.note.banks.ccb.dc.services.note.receivable.signin.SignTypeUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractQueryNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class QuerySigninNoteReceivableImpl
extends AbstractQueryNoteReceivableImpl {
    public static final int PAGE_SIZE = 200;
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(QuerySigninNoteReceivableImpl.class);

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List receivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(0);
        if (info.getBankBatchCount() >= 1) {
            Element header = CCB_DC_Packer.createTransactionHeader("6WH048", info.getBankBatchSeqId());
            Element txBody = NoteCommonPacker.createTransactionBody(header, "", "");
            JDomUtils.addChild((Element)txBody, (String)"BkListNo1", (String)info.getObssid());
            JDomUtils.addChild((Element)txBody, (String)"PAGE", (String)pageTag);
            JDomUtils.addChild((Element)txBody, (String)"PAGE_SIZE", (String)"200");
            return NoteCommonPacker.root2StringSafeMod(header);
        }
        return QueryNoteStatusPacker.packQueryResponsePay(receivableInfos, SignTypeUtil.INSTANCE.convert2Bank(info.getOperationCode()), pageTag);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List receivableInfos = request.getNoteReceivableInfos();
        if (((NoteReceivableInfo)receivableInfos.get(0)).getBankBatchCount() >= 1) {
            NoteReceivableInfo noteReceivableinfo = (NoteReceivableInfo)receivableInfos.get(0);
            Element root = CCB_DC_Parser.parseString2Root(responseStr);
            BankResponse response = CCB_DC_Parser.parseResponse(root);
            if (!response.getResponseCode().equals("000000") && !response.getResponseCode().equals("YBLECDA66261")) {
                EBGNoteReceivableUtils.setPaymentState((List)receivableInfos, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
            } else {
                Element txBody = root.getChild("TX_INFO");
                Element detaillist = txBody.getChild("DETAILLIST");
                List lists = detaillist.getChildren("DETAILINFO");
                for (NoteReceivableInfo info : receivableInfos) {
                    for (Element list : lists) {
                        String BkListNo1 = JDomUtils.getChildTextTrim((Element)list, (String)"BkListNo1");
                        if (!BkListNo1.equals(info.getBillNo())) continue;
                        String BkFlag2 = JDomUtils.getChildTextTrim((Element)list, (String)"BkFlag2");
                        String BkFlag1 = JDomUtils.getChildTextTrim((Element)list, (String)"BkFlag1");
                        String BkSumry = JDomUtils.getChildTextTrim((Element)list, (String)"BkSumry");
                        String BkBrchNo6 = JDomUtils.getChildTextTrim((Element)list, (String)"BkBrchNo6");
                        if ("SU01".equals(info.getOtherInfo())) {
                            if (!"00".equals(BkFlag2)) continue;
                            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)BkFlag2, (String)ResManager.loadKDString((String)"\u9a73\u56de\u6210\u529f", (String)"QuerySigninNoteReceivableImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
                            info.setNoteStatus(BkFlag1);
                            continue;
                        }
                        if (BkFlag2.equals("00") || BkFlag2.equals("06") || BkFlag1.equals("180006")) {
                            info.setNoteStatus(BkFlag1);
                            info.setDrawerBankCnaps(BkBrchNo6);
                            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)BkFlag2, (String)ResManager.loadKDString((String)"\u7b7e\u6536\u6210\u529f", (String)"QuerySigninNoteReceivableImpl_1", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
                            continue;
                        }
                        if (BkFlag2.equals("02")) {
                            info.setNoteStatus(BkFlag1);
                            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)BkListNo1, (String)String.format(ResManager.loadKDString((String)"%s\u94f6\u884c\u5df2\u63a5\u6536\u3002", (String)"QuerySigninNoteReceivableImpl_7", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]), BkSumry));
                            continue;
                        }
                        if (BkFlag2.equals("22") || BkFlag2.equals("03") || BkFlag2.equals("05") || BkFlag2.equals("09") || BkFlag2.equals("11") || BkFlag2.equals("14") || BkFlag2.equals("23")) {
                            info.setNoteStatus(BkFlag1);
                            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)BkListNo1, (String)BkSumry);
                            continue;
                        }
                        if (BkFlag2.equals("07")) {
                            info.setNoteStatus(BkFlag1);
                            EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)BkListNo1, (String)ResManager.loadKDString((String)"\u7b7e\u6536\u65b9\u9a73\u56de", (String)"QuerySigninNoteReceivableImpl_3", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
                            continue;
                        }
                        EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)BkListNo1, (String)BkSumry);
                    }
                }
            }
        } else {
            Element txbody;
            Element detaillist;
            List lists;
            NoteReceivableInfo info = (NoteReceivableInfo)receivableInfos.get(0);
            Element header = CCB_DC_Parser.parseString2Root(responseStr);
            BankResponse response = CCB_DC_Parser.parseResponse(header);
            if (!response.getResponseCode().equals("000000")) {
                EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)response.getResponseCode(), (String)response.getResponseMessage());
            }
            if ((lists = (detaillist = (txbody = header.getChild("TX_INFO")).getChild("DETAILLIST")).getChildren("DETAILINFO")).size() == 0) {
                this.logger.info("\u8fd4\u56de\u7684\u8282\u70b9\u957f\u5ea6\u4e3a0");
                return receivableInfos;
            }
            HashMap<String, String> map = new HashMap<String, String>(lists.size());
            HashMap<String, String> map2 = new HashMap<String, String>(lists.size());
            HashMap<String, String> map3 = new HashMap<String, String>(lists.size());
            HashMap<String, String> map4 = new HashMap<String, String>(lists.size());
            for (Element element : lists) {
                String BkListNo1 = element.getChildTextTrim("BkListNo1");
                String BkFlag2 = element.getChildTextTrim("BkFlag2");
                String BkBrchNo6 = element.getChildTextTrim("BkBrchNo6");
                String BkFlag1 = element.getChildTextTrim("BkFlag1");
                String BkSumry = element.getChildTextTrim("BkSumry");
                map.put(BkListNo1, BkFlag2);
                map2.put(BkListNo1, BkBrchNo6);
                map3.put(BkListNo1, BkFlag1);
                map4.put(BkListNo1, BkSumry);
            }
            String status = (String)map.get(info.getBillNo());
            if (status == null) {
                EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)status, (String)"noteNo not fund");
                this.logger.info("\u5206\u9875\u67e5\u8be2\u672c\u6b21\u627e\u4e0d\u5230\u8fd4\u56de\u6570\u636e\uff0c\u7968\u53f7\uff1a" + info.getBillNo());
                return receivableInfos;
            }
            if ("SU01".equals(info.getOtherInfo())) {
                if ("00".equals(status)) {
                    EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)status, (String)ResManager.loadKDString((String)"\u9a73\u56de\u6210\u529f", (String)"QuerySigninNoteReceivableImpl_0", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
                    info.setNoteStatus((String)map3.get(info.getBillNo()));
                }
            } else if ("00".equals(status)) {
                EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUCCESS, (String)status, (String)ResManager.loadKDString((String)"\u7b7e\u6536\u6210\u529f", (String)"QuerySigninNoteReceivableImpl_1", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
                String operType = info.getOperationCode();
                info.setNoteStatus((String)map3.get(info.getBillNo()));
                info.setDrawerBankCnaps((String)map2.get(info.getBillNo()));
            } else if ("22".equals(status) || "05".equals(status)) {
                info.setNoteStatus((String)map3.get(info.getBillNo()));
                EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)status, (String)((String)map4.get(info.getBillNo())));
            } else if ("07".equals(status)) {
                info.setNoteStatus((String)map3.get(info.getBillNo()));
                EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.FAIL, (String)status, (String)((String)map4.get(info.getBillNo())));
            } else if ("02".equals(status)) {
                info.setNoteStatus((String)map3.get(info.getBillNo()));
                EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.SUBMITED, (String)status, (String)((String)map4.get(info.getBillNo())));
            } else {
                info.setNoteStatus((String)map3.get(info.getBillNo()));
                EBGNoteReceivableUtils.setPaymentState((NoteReceivableInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)status, (String)ResManager.loadKDString((String)"\u72b6\u6001\u672a\u77e5", (String)"QuerySigninNoteReceivableImpl_5", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]));
            }
        }
        return receivableInfos;
    }

    public int getBatchSize() {
        return 200;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7b7e\u6536\u7ed3\u679c\u540c\u6b65", (String)"QuerySigninNoteReceivableImpl_6", (String)"ebg-note-banks-ccb-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        Integer page;
        Integer n = page = Integer.valueOf(Integer.parseInt(pageTag));
        Integer n2 = page = Integer.valueOf(page + 1);
        return page + "";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        boolean flag = false;
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        String rspCode = response.getResponseCode();
        String pageTotalNumStr = "";
        if ("000000".equals(rspCode)) {
            Element txBody = JDomUtils.getChildElement((Element)root, (String)"TX_INFO");
            pageTotalNumStr = JDomUtils.getChildText((Element)txBody, (String)"BkTotNum");
            if (StringUtils.isEmpty((String)pageTotalNumStr) || "0".equals(pageTotalNumStr)) {
                flag = true;
            } else {
                Integer pageTotalNum = Integer.parseInt(pageTotalNumStr);
                Integer page = Integer.parseInt(pageTag) - 1;
                boolean bl = flag = page * 200 >= pageTotalNum;
                if (pageTotalNum < 200) {
                    flag = true;
                }
            }
        } else {
            flag = true;
        }
        return flag;
    }
}

