/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.cmp.service.note.detail.endorseInfo;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_Parser;
import kd.ebg.note.common.entity.biz.notedetail.NoteSidesInfo;
import org.jdom2.Element;

public class NoteInfoParser {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(NoteInfoParser.class);

    public List<NoteSidesInfo> parseNoteInfoResponse(String rspStr) {
        ArrayList<NoteSidesInfo> result = new ArrayList<NoteSidesInfo>();
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp(rspStr, true);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)encoding);
        Element eb = JDomUtils.getChildElement((Element)root, (String)"eb");
        Element pub = JDomUtils.getChildElement((Element)eb, (String)"pub");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        String bankStatus = "<RetCode>" + headRsp.getResponseCode() + "</RetCode>";
        if (!"0".equals(headRsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)" endorse info query  error");
        }
        Element out = JDomUtils.getChildElement((Element)eb, (String)"out");
        String billNo = JDomUtils.getChildText((Element)out, (String)"BillNo");
        List rds = out.getChildren("rd");
        for (Element rd : rds) {
            String TranType = JDomUtils.getChildText((Element)rd, (String)"TranType");
            if (!"1".equals(TranType)) continue;
            NoteSidesInfo detailInfo = new NoteSidesInfo();
            detailInfo.setNoteNo(billNo);
            String accno = JDomUtils.getChildText((Element)rd, (String)"AccNo");
            detailInfo.setInitiatorAcNo(accno);
            String AccName = JDomUtils.getChildText((Element)rd, (String)"AccName");
            detailInfo.setInitiatorName(AccName);
            String NextAccNo = JDomUtils.getChildText((Element)rd, (String)"NextAccNo");
            String NextAccName = JDomUtils.getChildText((Element)rd, (String)"NextAccName");
            detailInfo.setOpponentAcNo(NextAccNo);
            detailInfo.setOpponentName(NextAccName);
            String ReciteFlag = JDomUtils.getChildText((Element)rd, (String)"ReciteFlag");
            detailInfo.setTransferFlag(ReciteFlag);
            String RepReserved5 = JDomUtils.getChildText((Element)rd, (String)"RepReserved5");
            detailInfo.setRemark(RepReserved5);
            detailInfo.setBusinessCode("10");
            try {
                Date SignDate = DateTimeUtils.parseDate((String)JDomUtils.getChildText((Element)rd, (String)"SignDate"), (String)"yyyy-MM-dd");
                detailInfo.setSignDate(DateTimeUtils.format((Date)SignDate, (String)"yyyyMMdd"));
            }
            catch (ParseException e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u5230\u671f\u65e5\u51fa\u9519", (String)"NoteInfoParser_0", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]), (Throwable)e);
            }
            result.add(detailInfo);
        }
        this.logger.info("\u83b7\u53d6\u5230\u7684\u80cc\u9762\u6570\u91cf\uff1a" + result.size());
        return result;
    }

    private static String[] split(String serial_record) {
        return StringUtils.split((String)serial_record, (String)"|");
    }
}

