/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.icbc.cmp.service.note.receivable.endorse;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.icbc.cmp.service.note.receivable.endorse.QueryEndorseNoteReceivableImpl;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_NoteParser;
import kd.ebg.note.banks.icbc.cmp.service.note.util.ICBC_CMP_Packer;
import kd.ebg.note.banks.icbc.cmp.service.note.util.NewNoteUtil;
import kd.ebg.note.business.SameBankUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.bank.EBBankNoteReceivableResponse;
import kd.ebg.note.common.framework.utils.ParserUtils;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class EndorseNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(EndorseNoteReceivableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryEndorseNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "BIENDO";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7968\u636e\u80cc\u4e66", (String)"EndorseNoteReceivableImpl_0", (String)"ebg-note-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        NoteReceivableInfo receivableInfo = (NoteReceivableInfo)noteReceivableInfos.get(0);
        String TransCode = "BIENDO";
        Element root = ICBC_CMP_Packer.createICBCCMPRootForPay(TransCode, receivableInfo.getBankBatchSeqId());
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"BillNo", (String)receivableInfo.getBillNo());
        JDomUtils.addChild((Element)in, (String)"BillOpenName", (String)receivableInfo.getRegisterNmae());
        JDomUtils.addChild((Element)in, (String)"BillOpenAcc", (String)receivableInfo.getRegisterAcno());
        JDomUtils.addChild((Element)in, (String)"BillOpenBank", (String)receivableInfo.getRegisterBankName());
        JDomUtils.addChild((Element)in, (String)"BillAmt", (String)ParserUtils.convertYuan2CentStr((BigDecimal)receivableInfo.getAmount()));
        JDomUtils.addChild((Element)in, (String)"AccNo", (String)receivableInfo.getDrawerAccNo());
        boolean isSameBank = false;
        if (receivableInfo.getPayeeBankName() != null && SameBankUtil.isSameBank((String)EBContext.getContext().getBankVersionID(), (String)receivableInfo.getPayeeBankName()).equals("1")) {
            isSameBank = true;
        }
        if (!isSameBank) {
            JDomUtils.addChild((Element)in, (String)"SysFlag", (String)"0");
            JDomUtils.addChild((Element)in, (String)"RecBankName", (String)receivableInfo.getPayeeBankName());
            JDomUtils.addChild((Element)in, (String)"RecCityName", (String)receivableInfo.getPayeeCity());
            JDomUtils.addChild((Element)in, (String)"RecBankNo", (String)receivableInfo.getPayeeBankCnaps());
        } else {
            JDomUtils.addChild((Element)in, (String)"SysFlag", (String)"1");
            JDomUtils.addChild((Element)in, (String)"RecBankName", (String)"");
            JDomUtils.addChild((Element)in, (String)"RecCityName", (String)"");
            JDomUtils.addChild((Element)in, (String)"RecBankNo", (String)"");
        }
        JDomUtils.addChild((Element)in, (String)"RecAccName", (String)receivableInfo.getPayeeAccName());
        JDomUtils.addChild((Element)in, (String)"RecAccNo", (String)receivableInfo.getPayeeAccNo());
        JDomUtils.addChild((Element)in, (String)"EndFlag", (String)receivableInfo.getTransferFlag());
        JDomUtils.addChild((Element)in, (String)"SMSFlag", (String)"");
        JDomUtils.addChild((Element)in, (String)"RecList", (String)"");
        JDomUtils.addChild((Element)in, (String)"PhoneList", (String)"");
        String signDate4Test = RequestContextUtils.getParameter().getBankParameter("signDate4Test");
        if (StringUtils.isEmpty((String)signDate4Test)) {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS"));
        } else {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)(signDate4Test + DateTimeUtils.format((Date)new Date(), (String)"HHmmssSSS")));
        }
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String reqstMsg = JDomUtils.root2String((Element)root, (String)encoding);
        String msgSigned = ICBC_CMP_Packer.sign(reqstMsg);
        return ICBC_CMP_Packer.createMessageWithHead(msgSigned, TransCode);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List noteReceivableInfos = request.getNoteReceivableInfos();
        ICBC_CMP_NoteParser.parsePay(noteReceivableInfos, responseStr);
        return noteReceivableInfos;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/servlet/ICBCCMPAPIReqServlet");
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public EBBankNoteReceivableResponse doBiz(BankNoteReceivableRequest request) {
        NoteReceivableInfo info = (NoteReceivableInfo)request.getNoteReceivableInfos().get(0);
        if (info.getIsNewECDS().equals("0")) {
            NewNoteUtil.changeExcontext();
            kd.ebg.note.banks.icbc.opa.service.note.receivable.endorse.EndorseNoteReceivableImpl impl = new kd.ebg.note.banks.icbc.opa.service.note.receivable.endorse.EndorseNoteReceivableImpl();
            return impl.doBiz(request);
        }
        return super.doBiz(request);
    }
}

