/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.cmb.opa.service.note.payable.cancle;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.note.banks.cmb.opa.service.BankBusinessConfig;
import kd.ebg.note.banks.cmb.opa.service.note.payable.cancle.QueryCancleNotePayableImpl;
import kd.ebg.note.banks.cmb.opa.service.note.payable.register.RegisterNotePayableImpl;
import kd.ebg.note.banks.cmb.opa.service.note.util.AvaiableCancleQuery;
import kd.ebg.note.banks.cmb.opa.service.note.util.JsonUtil;
import kd.ebg.note.banks.cmb.opa.service.note.util.MsgPacker;
import kd.ebg.note.banks.cmb.opa.service.note.util.ParserPayable;
import kd.ebg.note.banks.cmb.opa.service.note.util.PostUtil;
import kd.ebg.note.banks.cmb.opa.service.note.util.SaasUtil;
import kd.ebg.note.business.notePayable.atomic.AbstractNotePayableImpl;
import kd.ebg.note.business.notePayable.atomic.IQueryNotePayable;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.bank.EBBankNotePayableResponse;
import kd.ebg.note.common.model.NotePayableInfo;

public class CancleNotePayableImpl
extends AbstractNotePayableImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(RegisterNotePayableImpl.class);

    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNotePayable> defaultQueryClass() {
        return QueryCancleNotePayableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "combuscancel";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u64a4\u9500", (String)"CancleNotePayableImpl_0", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public EBBankNotePayableResponse doBiz(BankNotePayableRequest request) {
        String rqstStr = this.pack(request, null);
        String rspStr = PostUtil.sendMsgForPay(rqstStr);
        try {
            List<NotePayableInfo> infos = this.parse(request, rspStr);
            return new EBBankNotePayableResponse(infos);
        }
        catch (Exception e) {
            logger.error("error ", (Throwable)e);
            EBContext.getContext().setThrowableAfterSend((Throwable)e);
            return new EBBankNotePayableResponse(request.getNotePayableInfoList());
        }
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return true;
    }

    public String pack(BankNotePayableRequest request, String pageTag) {
        BankAcnt acnt = request.getAcnt();
        NotePayableInfo[] infos = request.getNotePayableInfosAsArray();
        AvaiableCancleQuery avaiable = new AvaiableCancleQuery();
        String code = infos[0].getOperationCode();
        String type = "";
        if ("02".equals(code)) {
            code = "BC02";
            type = "01";
        } else if ("03".equals(code)) {
            code = "BC03";
            type = "02";
        } else {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u7968\u636e\u7c7b\u578b", (String)"CancleNotePayableImpl_3", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
        }
        Map flag = avaiable.getmsg(infos[0].getDrawerAccNo(), code, infos[0].getBillNo(), infos[0].getStartNo(), infos[0].getEndNo());
        if (flag == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6b64\u7968\u636e\u4e0d\u80fd\u64a4\u9500\u3002", (String)"CancleNotePayableImpl_1", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
        }
        logger.info("\u901a\u7528\u64a4\u9500");
        JSONObject body = new JSONObject();
        JSONArray array1 = new JSONArray();
        JSONObject qryHdr = new JSONObject();
        String cltNbr = RequestContextUtils.getBankParameterValue((String)"cltNbr");
        if (!StringUtils.isEmpty((String)cltNbr)) {
            qryHdr.put("cltNbr", (Object)cltNbr);
        } else {
            qryHdr.put("cltNbr", (Object)acnt.getAccNo().substring(0, 10));
        }
        array1.add((Object)qryHdr);
        body.put("trxHdr", (Object)array1);
        JSONArray array2 = new JSONArray();
        JSONObject cltTrsDetailEdcInpDto = new JSONObject();
        cltTrsDetailEdcInpDto.put("cnlRef", (Object)SaasUtil.getRnlRef(infos[0].getBankBatchSeqId()));
        cltTrsDetailEdcInpDto.put("flwTyp", (Object)"ND0010");
        cltTrsDetailEdcInpDto.put("busTyp", (Object)"PB");
        cltTrsDetailEdcInpDto.put("busSty", (Object)"03");
        cltTrsDetailEdcInpDto.put("busTrs", (Object)"DFT");
        cltTrsDetailEdcInpDto.put("busStr", (Object)infos[0].getDraftType());
        cltTrsDetailEdcInpDto.put("oprDat", (Object)DateUtil.formatDate((Date)new Date()));
        cltTrsDetailEdcInpDto.put("sndEac", (Object)infos[0].getDrawerAccNo());
        cltTrsDetailEdcInpDto.put("ccyNbr", (Object)"10");
        cltTrsDetailEdcInpDto.put("addMap", (Object)"NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN");
        cltTrsDetailEdcInpDto.put("bchCnt", (Object)"1");
        cltTrsDetailEdcInpDto.put("bchTyp", (Object)"OPR");
        String flwCod = BankBusinessConfig.getBusMod(infos[0].getDrawerAccNo());
        if (StringUtils.isEmpty((String)flwCod)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u5f0f\u7f16\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u5728\u8d26\u53f7\u914d\u7f6e\u7684\u9644\u52a0\u5c5e\u6027\u4e2d\u7ef4\u62a4\u3002", (String)"RegisterNotePayableImpl_5", (String)"ebg-note-banks-cmb-opa", (Object[])new Object[0]));
        }
        cltTrsDetailEdcInpDto.put("flwCod", (Object)flwCod);
        array2.add((Object)cltTrsDetailEdcInpDto);
        body.put("batchBusOprX1", (Object)array2);
        JSONObject sceneDataMap2 = new JSONObject();
        JSONArray array6 = new JSONArray();
        JSONObject busOprIpt = new JSONObject();
        JSONObject busOprIptDetail = new JSONObject();
        busOprIptDetail.put("cnlRef", (Object)SaasUtil.getRnlRef(infos[0].getBankBatchSeqId()));
        busOprIptDetail.put("flwTyp", (Object)"ND0010");
        busOprIptDetail.put("busTyp", (Object)"PB");
        busOprIptDetail.put("busSty", (Object)"03");
        busOprIptDetail.put("busTrs", (Object)type);
        busOprIptDetail.put("busStr", (Object)infos[0].getDraftType());
        busOprIptDetail.put("oprDat", (Object)DateUtil.formatDate((Date)new Date()));
        busOprIptDetail.put("ccyNbr", (Object)"10");
        busOprIptDetail.put("addMap", (Object)"NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN");
        busOprIptDetail.put("bchCnt", (Object)"1");
        busOprIptDetail.put("bchTyp", (Object)"OPR");
        busOprIpt.put("busOprIpt", (Object)busOprIptDetail);
        busOprIpt.put("sceneDataMap", (Object)sceneDataMap2);
        array6.add((Object)busOprIpt);
        body.put("batchDetail", (Object)array6);
        JSONArray array7 = new JSONArray();
        JSONObject sceneDataMap = new JSONObject();
        array7.add((Object)sceneDataMap);
        sceneDataMap2.put("BusinessCancelApplyX1", (Object)array7);
        sceneDataMap.put("appBrd", (Object)infos[0].getDrawerBankCnaps());
        sceneDataMap.put("appEac", (Object)infos[0].getDrawerAccNo());
        sceneDataMap.put("appSrc", (Object)"CS02");
        sceneDataMap.put("busCnl", (Object)"EDC");
        JSONArray array8 = new JSONArray();
        JSONObject BusinessCancelApplyX2 = new JSONObject();
        array8.add((Object)BusinessCancelApplyX2);
        sceneDataMap2.put("BusinessCancelApplyX2", (Object)array8);
        BusinessCancelApplyX2.put("orgBus", flag.get("busSeq"));
        BusinessCancelApplyX2.put("innNbr", flag.get("innNbr"));
        BusinessCancelApplyX2.put("bilNbr", (Object)infos[0].getBillNo());
        BusinessCancelApplyX2.put("busCod", flag.get("busCod"));
        JSONObject head = JsonUtil.getHead("combuscancel", Sequence.genSequence());
        JSONObject result = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(result, logger, "combuscancel");
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest request, String responseStr) {
        ParserPayable.parsePay(request.getNotePayableInfoList(), responseStr);
        return request.getNotePayableInfoList();
    }
}

