/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.boc.net.service.codeless.detail;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.boc.net.service.BocNetUtils;
import kd.ebg.note.banks.boc.net.service.Packer;
import kd.ebg.note.banks.boc.net.service.codeless.detail.DetailInfoImpl;
import kd.ebg.note.banks.boc.net.service.login.LoginAccess;
import kd.ebg.note.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.note.business.noteDetail.atomic.AbstractNoteDetailImpl;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import kd.ebg.note.business.noteDetail.bank.EBBankDetailResponse;
import kd.ebg.note.common.entity.biz.notedetail.Detail;
import kd.ebg.note.common.entity.biz.notedetail.NoteDetailRequest;
import org.jdom2.Element;

public class DetailImpl
extends AbstractNoteDetailImpl {
    private final EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "b2e0686";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f85\u7b7e\u6536\u7968\u636e\u67e5\u8be2", (String)"DetailImpl_2", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public boolean match(NoteDetailRequest noteDetailRequest) {
        return false;
    }

    public boolean isNeedPage() {
        return true;
    }

    public String getFirstPageTag() {
        return "1";
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        return "" + (Integer.parseInt(pageTag) + 50);
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0686-rs");
        if (trn == null) {
            return true;
        }
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        String totalnum = trn.getChildTextTrim("totalnum");
        if (StringUtils.isEmpty((String)totalnum) || Integer.parseInt(totalnum) < 50) {
            return true;
        }
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if ("B001".equals(rspcod) || "B003".equals(rspcod)) {
            return true;
        }
        if ("B002".equals(rspcod)) {
            return false;
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5931\u8d25:%1$s %2$s", (String)"DetailImpl_0", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]), rspcod, rspmsg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankNoteDetailRequest request, String pageTag) {
        BankNoteDetailRequestBody body = request.getBody();
        BankAcnt acnt = request.getAcnt();
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = "test".equals(EBContext.getContext().getBankLoginID()) ? "testToken" : la.getToken();
            Element root = BocNetUtils.createRoot();
            Element head = JDomUtils.addChild((Element)root, (String)"head");
            JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
            JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
            JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
            JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
            JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0686");
            JDomUtils.addChild((Element)head, (String)"token", (String)token);
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0686-rq");
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0686-rq");
            JDomUtils.addChild((Element)rq, (String)"ibknum", (String)"");
            JDomUtils.addChild((Element)rq, (String)"actacn", (String)acnt.getAccNo());
            JDomUtils.addChild((Element)rq, (String)"payeeactn", (String)"");
            String tranType = request.getBody().getTranType();
            if ("02".equals(tranType)) {
                JDomUtils.addChild((Element)rq, (String)"querytype", (String)"A4");
            } else if ("03".equals(tranType)) {
                JDomUtils.addChild((Element)rq, (String)"querytype", (String)"A8");
            } else if ("10".equals(tranType)) {
                JDomUtils.addChild((Element)rq, (String)"querytype", (String)"C3");
            } else if ("20".equals(tranType)) {
                JDomUtils.addChild((Element)rq, (String)"querytype", (String)"G1");
            } else if ("19".equals(tranType)) {
                JDomUtils.addChild((Element)rq, (String)"querytype", (String)"E6");
            } else if ("18".equals(tranType)) {
                JDomUtils.addChild((Element)rq, (String)"querytype", (String)"E1");
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7c7b\u578b\u9519\u8bef\uff1atranType=%s", (String)"DetailImpl_1", (String)"ebg-note-banks-boc-net", (Object[])new Object[0]), tranType));
            }
            JDomUtils.addChild((Element)rq, (String)"acttyp", (String)"");
            JDomUtils.addChild((Element)rq, (String)"drafttype", (String)body.getDraftType());
            JDomUtils.addChild((Element)rq, (String)"scbintvl");
            JDomUtils.addChild((Element)rq, (String)"draweename", (String)"");
            JDomUtils.addChild((Element)rq, (String)"acceptorname", (String)"");
            JDomUtils.addChild((Element)rq, (String)"toname", (String)"");
            JDomUtils.addChild((Element)rq, (String)"draftno", (String)"");
            Element datescope = JDomUtils.addChild((Element)rq, (String)"datescope");
            if (body.getStartIssueDate() != null && body.getEndIssueDate() != null) {
                JDomUtils.addChild((Element)datescope, (String)"from", (String)LocalDateUtil.formatDate((LocalDate)body.getStartIssueDate()));
                JDomUtils.addChild((Element)datescope, (String)"to", (String)LocalDateUtil.formatDate((LocalDate)body.getEndIssueDate()));
            } else {
                JDomUtils.addChild((Element)datescope, (String)"from", (String)"");
                JDomUtils.addChild((Element)datescope, (String)"to", (String)"");
            }
            Element duedatescope = JDomUtils.addChild((Element)rq, (String)"duedatescope");
            if (body.getStartDueDate() != null && body.getEndDueDate() != null) {
                JDomUtils.addChild((Element)duedatescope, (String)"from", (String)LocalDateUtil.formatDate((LocalDate)body.getStartDueDate()));
                JDomUtils.addChild((Element)duedatescope, (String)"to", (String)LocalDateUtil.formatDate((LocalDate)body.getEndDueDate()));
            } else {
                JDomUtils.addChild((Element)duedatescope, (String)"from", (String)"");
                JDomUtils.addChild((Element)duedatescope, (String)"to", (String)"");
            }
            Element amountscope = JDomUtils.addChild((Element)rq, (String)"amountscope");
            JDomUtils.addChild((Element)amountscope, (String)"from", (String)"");
            JDomUtils.addChild((Element)amountscope, (String)"to", (String)"");
            JDomUtils.addChild((Element)rq, (String)"begnum", (String)pageTag);
            JDomUtils.addChild((Element)rq, (String)"recnum", (String)"50");
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            la.unavailableRelease();
        }
    }

    public List<Detail> parse(BankNoteDetailRequest request, String responseStr) {
        ArrayList<Detail> result = new ArrayList<Detail>(16);
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0686-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        if ("B999".equals(rspcod)) {
            return result;
        }
        if (!("B001".equals(rspcod) || "B003".equals(rspcod) || "B002".equals(rspcod))) {
            throw EBExceiptionUtil.serviceException((String)rspmsg);
        }
        List list = trn.getChildren("b2e0686-rs");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            String billStatus;
            Element rs = (Element)list.get(i);
            List statusAll = rs.getChildren("status");
            Element another_status = (Element)statusAll.get(0);
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            String another_rspmsg = another_status.getChildTextTrim("rspmsg");
            if ("B076".equals(another_rspcod)) {
                throw EBExceiptionUtil.serviceException((String)another_rspmsg);
            }
            if (!"B001".equals(another_rspcod) || "CS06".equals(billStatus = ((Element)statusAll.get(1)).getText()) || "CS05".equals(billStatus)) continue;
            String msgseq = rs.getChildText("msgseq");
            String draftno = rs.getChildTextTrim("draftno");
            String scbintvl = rs.getChildTextTrim("scbintvl");
            String totalcount = rs.getChildTextTrim("totalcount");
            if (StringUtils.isEmpty((String)totalcount)) {
                totalcount = "0";
            }
            RequestContextUtils.setRunningParam((String)"totalcount", (String)totalcount);
            RequestContextUtils.setRunningParam((String)"msgseq", (String)msgseq);
            DetailInfoImpl impl = new DetailInfoImpl();
            BankNoteDetailRequest infoRequest = new BankNoteDetailRequest();
            infoRequest.setHeader(request.getHeader());
            BankNoteDetailRequestBody body = new BankNoteDetailRequestBody();
            infoRequest.setBody(body);
            body.setSubRange(scbintvl);
            body.setNoteNo(draftno);
            body.setTranType(request.getBody().getTranType());
            EBBankDetailResponse response = impl.doBiz(infoRequest);
            List details = response.getDetails();
            if (StringUtils.isEmpty((String)scbintvl) || "0".equals(scbintvl)) {
                ((Detail)details.get(0)).setGrdBag("0");
            } else {
                ((Detail)details.get(0)).setGrdBag("1");
            }
            ((Detail)details.get(0)).setBankRefKey(msgseq);
            result.addAll(details);
        }
        return result;
    }

    public EBBankDetailResponse doBiz(BankNoteDetailRequest request) {
        EBBankDetailResponse ebBankDetailResponse = super.doBizWithPage(request);
        HashMap<String, String> billKey = new HashMap<String, String>();
        List details = ebBankDetailResponse.getDetails();
        ArrayList<Detail> newDetails = new ArrayList<Detail>(details.size());
        for (Detail detail : details) {
            String key;
            String subRange = detail.getSubRange();
            if (subRange == null) {
                subRange = "";
            }
            if (billKey.containsKey(key = detail.getNoteNo() + subRange)) {
                this.logger.info("\u660e\u7ec6\u91cd\u590d===\u7968\u53f7" + detail.getNoteNo() + "==\u5b50\u7968\u533a\u95f4" + subRange);
                continue;
            }
            newDetails.add(detail);
            billKey.put(key, subRange);
        }
        return new EBBankDetailResponse(newDetails);
    }
}

