/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service;

import java.io.UnsupportedEncodingException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class ABC_DC_Packer {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ABC_DC_Packer.class);

    public static Element createABCRoot4New(String transCode) {
        return ABC_DC_Packer.createABCRoot4New(transCode, Sequence.genSequence());
    }

    public static Element createABCRoot4New(String transCode, String reqSeqNo) {
        Element element = new Element("ap");
        JDomUtils.addChild((Element)element, (String)"CCTransCode", (String)transCode);
        JDomUtils.addChild((Element)element, (String)"ProductID", (String)"ICC");
        JDomUtils.addChild((Element)element, (String)"ChannelType", (String)"ERP");
        JDomUtils.addChild((Element)element, (String)"CorpNo", (String)RequestContextUtils.getBankParameterValue((String)"CorpNo"));
        JDomUtils.addChild((Element)element, (String)"OpNo", (String)RequestContextUtils.getBankParameterValue((String)"OpNo"));
        JDomUtils.addChild((Element)element, (String)"AuthNo", (String)"");
        JDomUtils.addChild((Element)element, (String)"ReqSeqNo", (String)reqSeqNo);
        String testServerDate = RequestContextUtils.getBankParameterValue((String)"testServerDate");
        if (StrUtil.isEmpty((String)testServerDate)) {
            JDomUtils.addChild((Element)element, (String)"ReqDate", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        } else {
            JDomUtils.addChild((Element)element, (String)"ReqDate", (String)testServerDate);
        }
        JDomUtils.addChild((Element)element, (String)"ReqTime", (String)LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        JDomUtils.addChild((Element)element, (String)"Sign", (String)"");
        return element;
    }

    public static Element createABCRoot(String tradeCode) {
        return ABC_DC_Packer.createABCRoot(tradeCode, Sequence.genSequence());
    }

    public static Element createABCRoot(String tradeCode, String seqno) {
        Element root = JDomUtils.createRoot((String)"ap");
        JDomUtils.addChild((Element)root, (String)"TransCode", (String)tradeCode);
        JDomUtils.addChild((Element)root, (String)"ChannelType", (String)"0");
        JDomUtils.addChild((Element)root, (String)"CorpNo", (String)RequestContextUtils.getBankParameterValue((String)"CorpNo"));
        JDomUtils.addChild((Element)root, (String)"OpNo", (String)RequestContextUtils.getBankParameterValue((String)"OpNo"));
        JDomUtils.addChild((Element)root, (String)"AuthNo", (String)"");
        JDomUtils.addChild((Element)root, (String)"ReqSeqNo", (String)seqno);
        JDomUtils.addChild((Element)root, (String)"ReqDate", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)root, (String)"ReqTime", (String)LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        JDomUtils.addChild((Element)root, (String)"Sign", (String)"");
        return root;
    }

    public static String covert2ABCMessage(Element root) {
        String encoding = RequestContextUtils.getCharset();
        return ABC_DC_Packer.appendABCHead(JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding));
    }

    private static String appendABCHead(String str) {
        String charsetName = RequestContextUtils.getCharset();
        byte[] bytes = new byte[]{};
        try {
            bytes = str.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            logger.info(e.getMessage());
        }
        String head = StrUtil.padEnd((CharSequence)("0" + bytes.length), (int)7, (char)' ');
        logger.info("\u5c01\u88c5\u540e\u7684head\uff1a" + head);
        return head + str;
    }

    public static Element packCorp(Element root) {
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"BookingDate", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)corp, (String)"BookingTime", (String)LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        JDomUtils.addChild((Element)corp, (String)"BookingFlag", (String)"0");
        return corp;
    }
}

