/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.newnote.detail;

import java.time.LocalDate;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.newnote.util.NewNoteUtil;
import kd.ebg.note.banks.abc.dc.service.newnote.util.TypeConvertUtils;
import kd.ebg.note.banks.abc.dc.utils.TypeInfo;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequest;
import kd.ebg.note.business.noteDetail.bank.BankNoteDetailRequestBody;
import org.jdom2.Element;

public class NoteDetailPacker {
    public String packDeFaultDetail(BankNoteDetailRequest request, String pageTag, BankAcnt acnt) {
        BankNoteDetailRequestBody body = request.getBody();
        if (StringUtils.isEmpty((String)body.getNoteNo())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7f3a\u5c11\u7968\u636e\u53f7\u67e5\u8be2\u67e5\u8be2\u6761\u4ef6", (String)"NoteDetailPacker_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        }
        Element root = ABC_DC_Packer.createABCRoot4New("CQRD37");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)acnt.getCurrency());
        Element hermes = CommNotePacker.packHermes(root, "CH1003", "SPIN1034", "");
        JDomUtils.addChild((Element)hermes, (String)"DistTp", (String)"DT02");
        String subBizType = request.getHeader().getSubBizType();
        if ("reply".equals(subBizType)) {
            JDomUtils.addChild((Element)hermes, (String)"CdNo", (String)"");
            JDomUtils.addChild((Element)hermes, (String)"CdRangeStart", (String)"");
            JDomUtils.addChild((Element)hermes, (String)"CdRangeEnd", (String)"");
        } else {
            JDomUtils.addChild((Element)hermes, (String)"CdNo", (String)body.getNoteNo());
            JDomUtils.addChild((Element)hermes, (String)"CdRangeStart", (String)NewNoteUtil.getBankNoteSubrange(request.getBody().getStartNo()));
            JDomUtils.addChild((Element)hermes, (String)"CdRangeEnd", (String)NewNoteUtil.getBankNoteSubrange(request.getBody().getEndNo()));
        }
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public String packReReplyDetail(BankNoteDetailRequest request, String pageTag, BankAcnt acnt) {
        BankNoteDetailRequestBody body = request.getBody();
        String transType = body.getTranType();
        String subBizType = "reply";
        String typeCode = subBizType + transType;
        TypeInfo typeInfo = TypeConvertUtils.getReplayPackerTypeInfo(typeCode);
        if (null == typeInfo) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u53ef\u56de\u590d\u7c7b\u5b50\u4e1a\u52a1\u7c7b\u578b: %1$s\u7684\u4e1a\u52a1\u79cd\u7c7b\uff1a%2$s\u65e0\u6cd5\u8fdb\u884c\u5339\u914d\u3002\u4e0d\u652f\u6301\u8be5\u4e1a\u52a1\u3002", (String)"NoteDetailPacker_7", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), subBizType, typeCode));
        }
        Element root = ABC_DC_Packer.createABCRoot4New(typeInfo.getTransCode());
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)acnt.getCurrency());
        Element hermes = CommNotePacker.packHermes(root, "CH1003", typeInfo.getMsgType(), "");
        JDomUtils.addChild((Element)hermes, (String)"DistTp", (String)"DT02");
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public String packRevocationDetailReq(BankNoteDetailRequest request, String pageTag, BankAcnt ancAcnt) {
        String subBizType = request.getHeader().getSubBizType();
        BankNoteDetailRequestBody body = request.getBody();
        Element root = ABC_DC_Packer.createABCRoot4New("CQRD34");
        CommNotePacker.packCmpElement(root, ancAcnt);
        Element hermes = CommNotePacker.packHermes(root, "CH1003", "SPIN1012");
        JDomUtils.addChild((Element)hermes, (String)"DistTp", (String)"DT02");
        JDomUtils.addChild((Element)hermes, (String)"CdType", (String)body.getDraftType());
        if (null != body.getStartDueDate()) {
            JDomUtils.addChild((Element)hermes, (String)"DueDtFr", (String)LocalDateUtil.formatDate((LocalDate)body.getStartDueDate()));
        }
        if (null != body.getEndDueDate()) {
            JDomUtils.addChild((Element)hermes, (String)"DueDtTo", (String)LocalDateUtil.formatDate((LocalDate)body.getEndDueDate()));
        }
        if (null != body.getStartIssueDate()) {
            JDomUtils.addChild((Element)hermes, (String)"IssDtFr", (String)LocalDateUtil.formatDate((LocalDate)body.getStartIssueDate()));
        }
        if (null != body.getEndIssueDate()) {
            JDomUtils.addChild((Element)hermes, (String)"IssDtTo", (String)LocalDateUtil.formatDate((LocalDate)body.getEndIssueDate()));
        }
        JDomUtils.addChild((Element)hermes, (String)"DwrName", (String)ancAcnt.getAccName());
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public String packFlowDetailReq(BankNoteDetailRequest bankNoteDetailRequest, String pageTag, BankAcnt acnt) {
        Element root = ABC_DC_Packer.createABCRoot4New("CQRM06");
        Element hermes = CommNotePacker.packNoteHeader(root, "1019");
        BankNoteDetailRequestBody body = bankNoteDetailRequest.getBody();
        CommNotePacker.packCmpElement(root, acnt);
        if (StringUtils.isEmpty((String)body.getNoteNo())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7f3a\u5c11\u7968\u636e\u53f7\u67e5\u8be2\u67e5\u8be2\u6761\u4ef6", (String)"NoteDetailPacker_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)hermes, (String)"IdNb", (String)body.getNoteNo());
        Element cme = JDomUtils.addChild((Element)root, (String)"Cme");
        if ("0".equals(pageTag)) {
            JDomUtils.addChild((Element)cme, (String)"ContLast");
        } else {
            JDomUtils.addChild((Element)cme, (String)"ContLast", (String)pageTag);
        }
        return ABC_DC_Packer.covert2ABCMessage(root);
    }
}

