/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.newnote.noteinfo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.business.noteinfo.atomic.AbstractNoteInfoImpl;
import kd.ebg.note.business.noteinfo.bank.BankNoteInfoBody;
import kd.ebg.note.business.noteinfo.bank.BankNoteInfoRequest;
import kd.ebg.note.business.noteinfo.bank.EBBankNoteInfoResponse;
import kd.ebg.note.common.entity.biz.noteinfo.NoteInfoDetail;
import kd.ebg.note.common.entity.biz.noteinfo.NoteInfoRequest;
import org.jdom2.Element;

public class NoteInfoImpl
extends AbstractNoteInfoImpl {
    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CQRD80";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d34\u73b0\u5b9e\u4ed8\u91d1\u989d\u8bd5\u7b97\u62a5\u6587", (String)"NoteInfoImpl_10", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteInfoRequest noteInfoRequest) {
        return "0".equals(noteInfoRequest.getBody().getIsNewECDS());
    }

    public String pack(BankNoteInfoRequest request) {
        BankAcnt acnt = request.getAcnt();
        List details = request.getBody().getDetails();
        NoteInfoDetail detail = (NoteInfoDetail)details.get(0);
        Element root = ABC_DC_Packer.createABCRoot4New("CQRD80");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)acnt.getAreaCode());
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)acnt.getCurrency());
        Element hermes = CommNotePacker.packHermes(root, "CH1003", "SCIN1020");
        BigDecimal rate = new BigDecimal(detail.getDiscountRate()).divide(new BigDecimal("100"));
        JDomUtils.addChild((Element)hermes, (String)"DsctAmt", (String)detail.getAmount());
        JDomUtils.addChild((Element)hermes, (String)"DsctRt", (String)rate.toString());
        JDomUtils.addChild((Element)hermes, (String)"DsctAppDt", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)hermes, (String)"DueDt", (String)detail.getDueDate());
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankNoteInfoResponse parse(BankNoteInfoRequest request, String rspStr) {
        List details = request.getBody().getDetails();
        NoteInfoDetail detail = (NoteInfoDetail)details.get(0);
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (!"0000".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7535\u7968\u8d34\u73b0\u5b9e\u4ed8\u91d1\u989d\u5931\u8d25\u3002%s", (String)"ReceivableDiscountAmountNoteImpl_6", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), rsp.getResponseMessage()));
        }
        Element hermes = JDomUtils.getChildElement((Element)root, (String)"Hermes");
        String TaskId = JDomUtils.getChildText((Element)hermes, (String)"TaskId");
        String DsctOptAmt = JDomUtils.getChildText((Element)hermes, (String)"DsctOptAmt");
        String DsctInt = JDomUtils.getChildText((Element)hermes, (String)"DsctInt");
        String RealIntDayNum = JDomUtils.getChildText((Element)hermes, (String)"RealIntDayNum");
        String RealDueDt = JDomUtils.getChildText((Element)hermes, (String)"RealDueDt");
        if (StringUtils.isEmpty((String)DsctOptAmt) || "0".equals(DsctOptAmt)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7535\u7968\u8d34\u73b0\u5b9e\u4ed8\u91d1\u989d\u5931\u8d25\u3002\u5b9e\u4ed8\u603b\u91d1\u989d\u9519\u8bef\u3002%s", (String)"ReceivableDiscountAmountNoteImpl_7", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]), DsctOptAmt));
        }
        detail.setDiscountAmount(DsctOptAmt);
        detail.setRecInt(DsctInt);
        detail.setIntDays(RealIntDayNum);
        EBBankNoteInfoResponse response1 = new EBBankNoteInfoResponse();
        BankNoteInfoBody infoDetail = request.getBody();
        response1.setBody(infoDetail);
        infoDetail.setDetails(details);
        return response1;
    }

    public int getBatchSize() {
        return 1;
    }
}

