/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.newnote.payable;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.newnote.payable.QueryStatusNoteImpl;
import kd.ebg.note.business.notePayable.atomic.AbstractQueryNotePayableImpl;
import kd.ebg.note.business.notePayable.bank.BankNotePayableRequest;
import kd.ebg.note.business.notePayable.util.EBGNotePayableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.model.NotePayableInfo;
import org.jdom2.Element;

public class QueryPayableNoteImpl
extends AbstractQueryNotePayableImpl {
    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CQRD39";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5e94\u4ed8\u7968\u636e\u901a\u7528\u63a5\u53e3", (String)"QueryPayableNoteImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NotePayableInfo notePayableInfo) {
        return false;
    }

    public String pack(BankNotePayableRequest bankNotePayableRequest, String s) {
        List notePayableInfos = bankNotePayableRequest.getNotePayableInfoList();
        BankAcnt acnt = bankNotePayableRequest.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CQRD39");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)acnt.getAreaCode());
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)((NotePayableInfo)notePayableInfos.get(0)).getCurrency());
        Element hermes = CommNotePacker.packHermes(root, "CH1003", "SPIN1036", "");
        if (StringUtils.isNotEmpty((String)((NotePayableInfo)notePayableInfos.get(0)).getReserved1()) && StringUtils.isNotEmpty((String)((NotePayableInfo)notePayableInfos.get(0)).getReserved2())) {
            JDomUtils.addChild((Element)hermes, (String)"BusiNo", (String)((NotePayableInfo)notePayableInfos.get(0)).getReserved1());
            JDomUtils.addChild((Element)hermes, (String)"BusiType", (String)((NotePayableInfo)notePayableInfos.get(0)).getReserved2());
        } else {
            JDomUtils.addChild((Element)hermes, (String)"CodReqSeq", (String)((NotePayableInfo)notePayableInfos.get(0)).getBankBatchSeqId());
        }
        JDomUtils.addChild((Element)hermes, (String)"DistTp", (String)"DT02");
        JDomUtils.addChild((Element)hermes, (String)"Direction", (String)"ST00");
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public List<NotePayableInfo> parse(BankNotePayableRequest bankNotePayableRequest, String rspStr) {
        List infos = bankNotePayableRequest.getNotePayableInfoList();
        NotePayableInfo info = (NotePayableInfo)infos.get(0);
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        String rspCode = rsp.getResponseCode();
        String reqCode = "DT02";
        if (StringUtils.isNotEmpty((String)info.getReserved1()) && StringUtils.isNotEmpty((String)info.getReserved2())) {
            if (!"0000".equals(rspCode)) {
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                return infos;
            }
        } else {
            if ("ETCTCSC0042".equals(rspCode)) {
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                return infos;
            }
            if (!"0000".equals(rspCode)) {
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                return infos;
            }
        }
        Element Hermes = root.getChild("Hermes");
        String CdNo = Hermes.getChildTextTrim("CdNo");
        String CdRangeStart = Hermes.getChildTextTrim("CdRangeStart");
        String CdRangeEnd = Hermes.getChildTextTrim("CdRangeEnd");
        String DealDtTm = Hermes.getChildTextTrim("DealDtTm");
        String DealResult = Hermes.getChildTextTrim("DealResult");
        String BusiStatus = Hermes.getChildTextTrim("BusiStatus");
        String SgnUpMk = Hermes.getChildTextTrim("SgnUpMk");
        String AppvStatus = Hermes.getChildTextTrim("AppvStatus");
        if (!StringUtils.isEmpty((String)CdNo)) {
            info.setBillNo(CdNo);
        }
        if (!StringUtils.isEmpty((String)CdRangeStart)) {
            info.setStartNo(CdRangeStart);
        }
        if (!StringUtils.isEmpty((String)CdRangeEnd)) {
            info.setEndNo(CdRangeEnd);
        }
        String BusiType = info.getReserved2();
        if ("SPBS05".equals(BusiStatus)) {
            new QueryStatusNoteImpl().getStatus(bankNotePayableRequest, reqCode);
            String noteStatus = info.getNoteStatus();
            String cirStatus = info.getCirStatus();
            if ("TAIR01".equals(BusiType) && "CS01".equals(noteStatus) && "TF0101".equals(cirStatus)) {
                info.setReserved2("TAAT01");
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BusiStatus, (String)ResManager.loadKDString((String)"\u51fa\u7968\u5df2\u767b\u8bb0", (String)"QueryRegisterPayableNoteImpl_1", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
            } else if ("TAAT01".equals(BusiType) && "CS02".equals(noteStatus) && "TF0101".equals(cirStatus)) {
                info.setReserved2("TARB01");
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BusiStatus, (String)ResManager.loadKDString((String)"\u63d0\u793a\u627f\u5151\u5df2\u7b7e\u6536", (String)"QueryRegisterPayableNoteImpl_2", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
            } else if ("TARB01".equals(BusiType) && "CS03".equals(noteStatus) && "TF0301".equals(cirStatus)) {
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUCCESS, (String)BusiStatus, (String)ResManager.loadKDString((String)"\u63d0\u793a\u6536\u7968\u5df2\u7b7e\u6536", (String)"QueryRegisterPayableNoteImpl_3", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
            } else if ("remit_revocation".equals(info.getSubBizType()) || "remit_cancle".equals(info.getSubBizType())) {
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUCCESS, (String)BusiStatus, (String)ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f", (String)"QueryRegisterPayableNoteImpl_6", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
            } else {
                EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)BusiStatus, (String)DealResult);
            }
        } else if ("SPBS00".equals(BusiStatus) || "SPBS03".equals(BusiStatus) || "SPBS07".equals(BusiStatus) || "SPBS10".equals(BusiStatus) || "SPBS14".equals(BusiStatus) || "SPBS30".equals(BusiStatus) || "SPBS31".equals(BusiStatus)) {
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BusiStatus, (String)DealResult);
        } else if ("SPBS04".equals(BusiStatus) || "SPBS06".equals(BusiStatus) || "SPBS11".equals(BusiStatus) || "SPBS13".equals(BusiStatus) || "SPBS15".equals(BusiStatus) || "SPBS16".equals(BusiStatus) || "SPBS17".equals(BusiStatus) || "SPBS18".equals(BusiStatus) || "SPBS19".equals(BusiStatus) || "SPBS32".equals(BusiStatus)) {
            new QueryStatusNoteImpl().getStatus(bankNotePayableRequest, reqCode);
            EBGNotePayableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)BusiStatus, (String)DealResult);
        }
        return infos;
    }

    public int getBatchSize() {
        return 0;
    }
}

