/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.newnote.receivable.discount;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.note.banks.abc.dc.ext.ResponseFileUtils;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.note.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.note.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.note.banks.abc.dc.service.CommNotePacker;
import kd.ebg.note.banks.abc.dc.service.newnote.receivable.QueryReceivableStatusNoteImpl;
import kd.ebg.note.business.noteReceivable.atomic.AbstractQueryNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.business.noteReceivable.util.EBGNoteReceivableUtils;
import kd.ebg.note.common.entity.biz.status.PaymentState;
import kd.ebg.note.common.framework.utils.ParserUtils;
import kd.ebg.note.common.model.NoteReceivableInfo;
import org.jdom2.Element;

public class QueryDiscountReceivableNoteImpl
extends AbstractQueryNoteReceivableImpl {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryDiscountReceivableNoteImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CQRD39";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u901a\u7528\u67e5\u8be2\u5e94\u6536\u7968\u636e", (String)"QueryReceivableNoteImpl_0", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return false;
    }

    public String pack(BankNoteReceivableRequest bankNoteReceivableRequest, String s) {
        List notePayableinfos = bankNoteReceivableRequest.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)notePayableinfos.get(0);
        BankAcnt acnt = bankNoteReceivableRequest.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CQRD40");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)acnt.getAreaCode());
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)info.getCurrency());
        Element hermes = CommNotePacker.packHermes(root, "CH1003", "SPIN1037", "");
        if (StringUtils.isNotEmpty((String)((NoteReceivableInfo)notePayableinfos.get(0)).getReserved1()) && StringUtils.isNotEmpty((String)((NoteReceivableInfo)notePayableinfos.get(0)).getReserved2())) {
            JDomUtils.addChild((Element)hermes, (String)"BtNo", (String)((NoteReceivableInfo)notePayableinfos.get(0)).getReserved1());
            JDomUtils.addChild((Element)hermes, (String)"BusiType", (String)((NoteReceivableInfo)notePayableinfos.get(0)).getReserved2());
        } else {
            JDomUtils.addChild((Element)hermes, (String)"CodReqSeq", (String)info.getBankBatchSeqId());
        }
        JDomUtils.addChild((Element)hermes, (String)"DistTp", (String)"DT02");
        JDomUtils.addChild((Element)hermes, (String)"Direction", (String)"ST00");
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest bankNoteReceivableRequest, String rspStr) {
        List infos = bankNoteReceivableRequest.getNoteReceivableInfos();
        NoteReceivableInfo info = (NoteReceivableInfo)infos.get(0);
        String reqCode = "DT02";
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        String rspCode = rsp.getResponseCode();
        this.logger.info("respCode:" + rspCode);
        if (StringUtils.isNotEmpty((String)info.getReserved1()) && StringUtils.isNotEmpty((String)info.getReserved2())) {
            if (!"0000".equals(rspCode)) {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                return infos;
            }
        } else {
            if ("ETCTCSC0042".equals(rspCode)) {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                return infos;
            }
            if (!"0000".equals(rspCode)) {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
                return infos;
            }
        }
        Element cme = root.getChild("Cme");
        String fieldNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"FieldNum");
        String recordNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"RecordNum");
        int recordNum = Integer.parseInt(recordNumStr);
        if (0 == recordNum) {
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u672a\u540c\u6b65\u5230\u64cd\u4f5c\u72b6\u6001", (String)"QueryReceivableNoteImpl_3", (String)"ebg-note-banks-abc-dc", (Object[])new Object[0]));
        }
        String fileFlag = ParserUtils.checkUnNullableElement((Element)root, (String)"FileFlag");
        String[] splits = new String[]{};
        Element cmp = root.getChild("Cmp");
        String fileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
        splits = ResponseFileUtils.getDetailRspRecordsNew(fileName, Sequence.gen8Sequence());
        int fieldNum = Integer.parseInt(fieldNumStr);
        for (int i = recordNum - 1; i >= 0; --i) {
            String BusiNo = splits[fieldNum * i];
            String serialNo = splits[fieldNum * i + 1];
            String billNo = splits[fieldNum * i + 2];
            String startNo = splits[fieldNum * i + 3];
            String endNo = splits[fieldNum * i + 4];
            String handleTime = splits[fieldNum * i + 5];
            String handleStatus = splits[fieldNum * i + 6];
            String BusiStatus = splits[fieldNum * i + 7];
            if (!billNo.equals(info.getBillNo())) continue;
            if (!StringUtils.isEmpty((String)startNo)) {
                info.setStartNo(startNo);
            }
            if (!StringUtils.isEmpty((String)endNo)) {
                info.setEndNo(endNo);
            }
            String BusiType = info.getReserved2();
            if ("SPBS05".equals(BusiStatus) || "SPBS14".equals(BusiStatus) || "SPBS15".equals(BusiStatus)) {
                new QueryReceivableStatusNoteImpl().getStatus(bankNoteReceivableRequest, reqCode);
                if ("TAED01".equals(BusiType) || "TAPG01".equals(BusiType) || "TAPR01".equals(BusiType) || "TADC01".equals(BusiType) || "TAPP01".equals(BusiType)) {
                    if ("SPBS14".equals(BusiStatus)) {
                        EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUCCESS, (String)BusiStatus, (String)"");
                        continue;
                    }
                    if ("SPBS15".equals(BusiStatus)) {
                        EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)BusiStatus, (String)"");
                        continue;
                    }
                    EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BusiStatus, (String)"");
                    continue;
                }
                if ("TRAT01".equals(BusiType) || "TRRB01".equals(BusiType) || "TRED01".equals(BusiType) || "TRGT01".equals(BusiType) || "TRPG01".equals(BusiType) || "TRPR01".equals(BusiType) || "TRPP01".equals(BusiType)) {
                    if ("SPBS14".equals(BusiStatus) || "SPBS15".equals(BusiStatus)) {
                        EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUCCESS, (String)BusiStatus, (String)"");
                        continue;
                    }
                    EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BusiStatus, (String)"");
                    continue;
                }
                if ("SPBS05".equals(BusiStatus)) {
                    EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUCCESS, (String)BusiStatus, (String)"");
                    continue;
                }
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BusiStatus, (String)"");
                continue;
            }
            if ("SPBS00".equals(BusiStatus) || "SPBS03".equals(BusiStatus) || "SPBS07".equals(BusiStatus) || "SPBS10".equals(BusiStatus) || "SPBS30".equals(BusiStatus) || "SPBS31".equals(BusiStatus)) {
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)BusiStatus, (String)handleStatus);
                continue;
            }
            if ("SPBS04".equals(BusiStatus) || "SPBS06".equals(BusiStatus) || "SPBS11".equals(BusiStatus) || "SPBS13".equals(BusiStatus) || "SPBS16".equals(BusiStatus) || "SPBS17".equals(BusiStatus) || "SPBS18".equals(BusiStatus) || "SPBS19".equals(BusiStatus) || "SPBS32".equals(BusiStatus)) {
                new QueryReceivableStatusNoteImpl().getStatus(bankNoteReceivableRequest, reqCode);
                EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)BusiStatus, (String)handleStatus);
                continue;
            }
            EBGNoteReceivableUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)BusiStatus, (String)handleStatus);
        }
        return infos;
    }

    public int getBatchSize() {
        return 0;
    }
}

