/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.abc.dc.service.newnote.util;

import kd.ebg.egf.common.context.EBContext;
import kd.ebg.note.banks.abc.dc.utils.MatchUtils;
import kd.ebg.note.common.model.NotePayableInfo;
import kd.ebg.note.common.model.NoteReceivableInfo;

public class NewNoteUtil {
    public static String getPayeeAccNo(NotePayableInfo info) {
        if (MatchUtils.isSameBank(EBContext.getContext().getBankVersionID(), info.getPayeeBankName()) && info.getPayeeAccNo().length() == 15) {
            return MatchUtils.getAreaCode(info) + info.getPayeeAccNo();
        }
        return info.getPayeeAccNo();
    }

    public static String getPayeeAccNo(NoteReceivableInfo info) {
        if (MatchUtils.isSameBank(info) && info.getPayeeAccNo().length() == 15) {
            return MatchUtils.getAreaCode(info) + info.getPayeeAccNo();
        }
        return info.getPayeeAccNo();
    }

    public static String getAcceptorAccNo(NotePayableInfo info) {
        if (MatchUtils.isSameBank(EBContext.getContext().getBankVersionID(), info.getAcceptorBankName()) && info.getAcceptorAccNo().length() == 15) {
            return MatchUtils.getAcceptorAreaCode(info) + info.getAcceptorAccNo();
        }
        return info.getAcceptorAccNo();
    }

    public static String getBankNoteSubrange(String startNo) {
        while (startNo.startsWith("0") && startNo.length() > 1) {
            startNo = startNo.substring(1, startNo.length());
        }
        return startNo;
    }
}

