/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.note.banks.pab.dc.service.note.receivable.payment;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.note.banks.pab.dc.service.note.receivable.payment.QueryPaymentNoteReceivableImpl;
import kd.ebg.note.banks.pab.dc.service.note.util.PackerUtil;
import kd.ebg.note.banks.pab.dc.service.note.util.ParserUtil;
import kd.ebg.note.business.noteReceivable.atomic.AbstractNoteReceivableImpl;
import kd.ebg.note.business.noteReceivable.atomic.IQueryNoteReceivable;
import kd.ebg.note.business.noteReceivable.bank.BankNoteReceivableRequest;
import kd.ebg.note.common.model.NoteReceivableInfo;

public class PaymentNoteReceivableImpl
extends AbstractNoteReceivableImpl {
    public long getBankInterval() {
        return 0L;
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryNoteReceivable> defaultQueryClass() {
        return QueryPaymentNoteReceivableImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P70104";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e\u63d0\u793a\u4ed8\u6b3e(P70104)", (String)"PaymentNoteReceivableImpl_0", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]);
    }

    public boolean match(NoteReceivableInfo noteReceivableInfo) {
        return true;
    }

    public String pack(BankNoteReceivableRequest request, String pageTag) {
        NoteReceivableInfo[] infos = request.getNotePayableInfosAsArray();
        NoteReceivableInfo info = infos[0];
        JSONObject root = new JSONObject();
        JSONObject requestDto = new JSONObject();
        requestDto.put("dataSource", (Object)"1");
        requestDto.put("drwrAutoType", (Object)"");
        requestDto.put("operCode", (Object)"OC0");
        requestDto.put("batchNumber", (Object)Sequence.gen16NumSequence());
        root.put("requestDto", (Object)requestDto);
        JSONArray reqInfoList = new JSONArray();
        requestDto.put("reqInfoList", (Object)reqInfoList);
        JSONObject object = new JSONObject();
        reqInfoList.add((Object)object);
        object.put("applAcctNo", (Object)info.getDrawerAccNo());
        object.put("applBankNo", (Object)info.getDrawerBankCnaps());
        String billId_hldrId = info.getBankRefKey();
        String[] bankRefKey = billId_hldrId.split("_");
        if (bankRefKey.length < 2) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"bankRefKey\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff0c\u65e0\u6cd5\u5904\u7406", (String)"PaymentNoteReceivableImpl_1", (String)"ebg-note-banks-pab-dc", (Object[])new Object[0]));
        }
        object.put("billId", (Object)bankRefKey[0]);
        object.put("hldrId", (Object)bankRefKey[1]);
        if (info.getDueDate().isAfter(LocalDate.now())) {
            object.put("transNo", (Object)"NES.011.20.00P");
        } else {
            object.put("transNo", (Object)"NES.011.20.01P");
        }
        object.put("reserveFlag", (Object)"0");
        object.put("rmrkByPropsr", (Object)info.getExplanation());
        JSONObject prsnttn = new JSONObject();
        object.put("prsnttn", (Object)prsnttn);
        prsnttn.put("prsnttnDt", (Object)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        return PackerUtil.getPackerResult(root.toJSONString(), "P70104");
    }

    public List<NoteReceivableInfo> parse(BankNoteReceivableRequest request, String responseStr) {
        List infos = request.getNoteReceivableInfos();
        ParserUtil.parsePay(infos, responseStr);
        return infos;
    }
}

