/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt;

import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.receipt.business.receipt.atom.IBalanceReconciliationQuery;
import kd.ebg.receipt.business.receipt.bank.BalanceReconciliationQueryRequest;
import kd.ebg.receipt.business.receipt.bank.BalanceReconciliationQueryResponseEB;
import kd.ebg.receipt.business.receipt.utils.AccessUtils;
import kd.ebg.receipt.business.receipt.utils.BalanceReconciliationConvert;
import kd.ebg.receipt.common.entity.biz.reconciliation.query.QueryBalanceReconciliationRequest;
import kd.ebg.receipt.common.entity.biz.reconciliation.query.QueryBalanceReconciliationResponse;
import kd.ebg.receipt.common.framework.frame.BankBundleManager;
import org.slf4j.MDC;

public class BalanceReconciliationQueryMethod
implements EBServiceMethod<QueryBalanceReconciliationRequest, QueryBalanceReconciliationResponse> {
    public QueryBalanceReconciliationResponse executeClientRequest(QueryBalanceReconciliationRequest request, EBContext context) {
        AccessUtils.checkQueryAllowed(context);
        BalanceReconciliationQueryRequest receiptRequest = BalanceReconciliationConvert.convert(request);
        BalanceReconciliationQueryResponseEB response = null;
        EBContext.initParameter();
        FEPAccess access = null;
        try {
            IBalanceReconciliationQuery receiptImpl = (IBalanceReconciliationQuery)BankBundleManager.getInstance().getImpl(context.getBankVersionID(), IBalanceReconciliationQuery.class, (Object)receiptRequest);
            if (receiptImpl.needLock()) {
                MDC.put((String)"bussiness_type", (String)"bussiness_bank");
                access = FEPAccessUtil.access((String)context.getBankVersionID(), (String)context.getBankVersionID());
                AccessUtils.checkQueryAllowed(context);
            }
            response = receiptImpl.queryBalanceReconciliation(receiptRequest);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        finally {
            FEPAccessUtil.release(access);
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
        }
        return BalanceReconciliationConvert.convert(response);
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "receipt";
    }
}

