/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.atom.impl;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;

public class GetBankReceiptFileList
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(GetBankReceiptFileList.class);

    @Override
    public String pack(BankReceiptRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        Map<String, Object> paramMap = request.getParamsMap();
        String match = (String)paramMap.get("name");
        String frontProxyPath = (String)paramMap.get("frontProxyPath");
        String suffix = (String)paramMap.get("suffix");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)"list");
        jsonObject.put("path", (Object)frontProxyPath);
        jsonObject.put("name", (Object)match);
        if (!EBGStringUtils.isEmpty((String)suffix)) {
            jsonObject.put("fileType", (Object)suffix);
        }
        String requestStr = jsonObject.toJSONString();
        logger.info("\u53d1\u9001\u7684\u6587\u4ef6\u5217\u8868-{}-{}-\u8bf7\u6c42\uff1a{}", new Object[]{accNo, transDate, requestStr});
        RequestContextUtils.setRunningParam((String)"charsetName", (String)EBContext.getContext().getCharsetName());
        EBContext.getContext().setCharsetName("UTF-8");
        return requestStr;
    }

    @Override
    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        EBContext.getContext().setCharsetName(RequestContextUtils.getRunningParam((String)"charsetName"));
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        logger.info("\u6536\u5230\u7684\u6587\u4ef6\u5217\u8868\u54cd\u5e94-{}-{}-\uff1a{}", new Object[]{accNo, transDate, responseStr});
        if (!EBGStringUtils.isEmpty((String)responseStr)) {
            try {
                JSONObject result = JSONObject.parseObject((String)responseStr);
                return BankReceiptResponseEB.success(JSONObject.parseArray((String)result.get((Object)"files").toString()).toJavaList(String.class));
            }
            catch (Exception e) {
                try {
                    responseStr = new String(responseStr.getBytes("GBK"), "UTF-8");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ReceiptException(responseStr);
            }
        }
        return BankReceiptResponseEB.fail();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CMD_DC_FRONT_DOWNLOAD";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u62db\u884c\u524d\u7f6e\u673a\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"GetBankReceiptFileList_0", (String)"ebg-receipt-business", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.setFrontProxyConnectFactory(factory);
    }
}

