/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.impl.handler.monitor;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.receipt.business.receipt.framework.ScheduleHanlder;
import kd.ebg.receipt.business.receipt.utils.MessageToUserUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.ReceiptSystemProperties;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.services.monitor.ReceiptConnectMonitorService;
import kd.ebg.receipt.common.model.repository.monitor.AlertMessageRepository;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class ReceiptDefectMonitorHandler
extends ScheduleHanlder {
    EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptDefectMonitorHandler.class);
    private ReceiptConnectMonitorService receiptConnectMonitorService;
    private AlertMessageRepository alertMessageRepository;

    public ReceiptDefectMonitorHandler(String name) {
        super(name);
    }

    @Override
    public boolean preJob() {
        this.receiptConnectMonitorService = (ReceiptConnectMonitorService)SpringContextUtil.getBean(ReceiptConnectMonitorService.class);
        this.alertMessageRepository = (AlertMessageRepository)SpringContextUtil.getBean(AlertMessageRepository.class);
        String customId = RequestContext.get().getTenantId();
        EBContext.setContext((EBContext)EBContext.builder().customID(customId).logBizSeqID(Sequence.genSequence()).logRequestSeqID(Sequence.genSequence()).bizName("receipt").build());
        return true;
    }

    @Override
    public void subProcess() {
        String customId = RequestContext.get().getTenantId();
        ReceiptSystemProperties receiptSystemProperties = (ReceiptSystemProperties)EBConfigBuilder.getInstance().buildConfig(ReceiptSystemProperties.class);
        this.logger.info("\u56de\u5355\u7f3a\u5931\u76d1\u63a7-\u4efb\u52a1\u5904\u7406\u5f00\u59cb-{}", (Object)customId);
        if (!this.isMeetSeedTime(receiptSystemProperties) && !FileCommonUtils.isTestEnv()) {
            return;
        }
        if (this.isExistReceiptDefect() || FileCommonUtils.isTestEnv()) {
            String year = LocalDateUtil.formatDate((LocalDate)LocalDate.now(), (String)"YYYY");
            String monthEndDay = LocalDateUtil.formatDate((LocalDate)LocalDate.now().minusMonths(1L), (String)"MM");
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u6708\u56de\u5355\u4e0b\u8f7d\u5b58\u5728\u7f3a\u5931\uff0c\u8bf7\u53ca\u65f6\u767b\u5f55\u82cd\u7a79\u7cfb\u7edf-\u7535\u5b50\u56de\u5355-\u56de\u5355\u7f3a\u5931\u62a5\u8868\u4e2d\u67e5\u770b\u8be6\u60c5\u5e76\u5904\u7406\u3002", (String)"ReceiptDefectMonitorHandler_1", (String)"ebg-receipt-business", (Object[])new Object[0]), year, monthEndDay);
            MessageToUserUtil messageToUserUtil = new MessageToUserUtil();
            messageToUserUtil.sendAlertMsgToUser(receiptSystemProperties, msg, "4");
        }
        this.logger.info("\u56de\u5355\u7f3a\u5931\u76d1\u63a7-\u4efb\u52a1\u5904\u7406\u5b8c\u6210-{}", (Object)customId);
    }

    private boolean isExistReceiptDefect() {
        String year = LocalDateUtil.formatDate((LocalDate)LocalDate.now(), (String)"YYYY");
        String monthEndDay = LocalDateUtil.formatDate((LocalDate)LocalDate.now().minusMonths(1L), (String)"MM");
        Date startDate = DateUtil.string2Date((String)(year + monthEndDay + "01"), (String)"yyyyMMdd");
        String endDayStr = ReceiptDefectMonitorHandler.getDaysByYearMonth(year, monthEndDay) + "";
        Date endDate = DateUtil.string2Date((String)(year + monthEndDay + endDayStr), (String)"yyyyMMdd");
        StringBuilder sql = new StringBuilder("select count(1) as defectCount,t.FBANK_VERSION,t.FACC_NO as accNo,t.FBANK_LOGIN  from t_receipt_download_task as t,t_aqap_bank_acnt as b where t.FSTATUS='11' and t.fdefect_type!=' ' and t.FACC_NO=b.FID AND t.ftrans_date >= ? AND t.ftrans_date <= ? ");
        ArrayList<Date> pramsList = new ArrayList<Date>(16);
        pramsList.add(0, startDate);
        pramsList.add(1, endDate);
        sql.append("group by t.FBANK_VERSION,t.FBANK_LOGIN,t.FACC_NO  order by defectCount desc;");
        Object[] params = pramsList.toArray();
        int dataCount = 0;
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"receipt_download_task");
        try (DataSet dataSet = DB.queryDataSet((String)(this.getClass().getName() + ".query"), (DBRoute)new DBRoute(dataEntityType.getDBRouteKey()), (String)sql.toString(), (Object[])params).limit(0, 5);){
            int countIndex = 0;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                if (row == null) continue;
                ++countIndex;
            }
            dataCount = countIndex;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dataCount != 0;
    }

    public boolean isMeetSeedTime(ReceiptSystemProperties receiptSystemProperties) {
        String monthEndDay;
        String year;
        int lastDay;
        String nowDay;
        int nowDayInt;
        int defect_monitor_day = receiptSystemProperties.getDefect_monitor_day();
        if (defect_monitor_day != (nowDayInt = Integer.parseInt(nowDay = LocalDateUtil.formatDate((LocalDate)LocalDate.now(), (String)"dd"))) && !FileCommonUtils.isTestEnv()) {
            return false;
        }
        if (defect_monitor_day == 0 && nowDayInt != (lastDay = ReceiptDefectMonitorHandler.getDaysByYearMonth(year = LocalDateUtil.formatDate((LocalDate)LocalDate.now(), (String)"YYYY"), monthEndDay = LocalDateUtil.formatDate((LocalDate)LocalDate.now(), (String)"MM"))) && !FileCommonUtils.isTestEnv()) {
            return false;
        }
        Integer monitorTimeStr = receiptSystemProperties.getDefect_monitor_time();
        String time = DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmm");
        int hour = Integer.parseInt(time.substring(8, 10));
        int min = Integer.parseInt(time.substring(10, 12));
        int nowSec = hour * 3600 + min * 60;
        monitorTimeStr = monitorTimeStr - 2100;
        int end = monitorTimeStr + 300;
        return monitorTimeStr <= nowSec && nowSec <= end;
    }

    public static int getDaysByYearMonth(String year, String month) {
        Calendar a = Calendar.getInstance();
        a.set(1, Integer.parseInt(year));
        a.set(2, Integer.parseInt(month) - 1);
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }

    @Override
    public boolean afterJob() {
        EBContext.destroy();
        return true;
    }
}

