/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.query;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.model.data.Sort;
import kd.ebg.receipt.business.receipt.atom.IReceipt;
import kd.ebg.receipt.business.receipt.bank.ReceiptInfo;
import kd.ebg.receipt.business.receipt.bank.ReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.ReceiptResponseEB;
import kd.ebg.receipt.business.receipt.query.FileReconciliationPage;
import kd.ebg.receipt.business.receipt.query.ReceiptResult;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.services.reconciliation.ReconciliationDownloadTaskService;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationDetail;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationInfo;
import kd.ebg.receipt.common.model.repository.reconciliation.ReconciliationDownloadListDetailRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class FileReconciliationImpl
implements IReceipt {
    private ReconciliationDownloadListDetailRepository reconciliationDownloadListDetailRepository;
    private ReconciliationDownloadTaskService reconciliationDownloadTaskService;

    @Override
    public boolean needLock() {
        return false;
    }

    public String getDeveloper() {
        return "Jimmy";
    }

    public String getBizCode() {
        return "EBGFileReceipt";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u901a\u8fc7\u94f6\u4f01\u5e73\u53f0\u56de\u5355\u7a0b\u5e8f\u83b7\u53d6\u6587\u4ef6\u56de\u5355\u7d22\u5f15\u3002", (String)"FileReconciliationImpl_0", (String)"ebg-receipt-business", (Object[])new Object[0]);
    }

    public ReceiptResponseEB doBiz(ReceiptRequest request) {
        if ("reconciliationPage".equals(request.getHeader().getSubBizType())) {
            return new FileReconciliationPage().doBiz(request);
        }
        ReceiptResponseEB responseEB = new ReceiptResponseEB();
        this.reconciliationDownloadListDetailRepository = (ReconciliationDownloadListDetailRepository)SpringContextUtil.getBean(ReconciliationDownloadListDetailRepository.class);
        this.reconciliationDownloadTaskService = (ReconciliationDownloadTaskService)SpringContextUtil.getBean(ReconciliationDownloadTaskService.class);
        String accNo = request.getAccNo();
        String bankVersionID = request.getHeader().getBankVersionID();
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        String customID = EBContext.getContext().getCustomID();
        String fixedAccNo = accNo;
        List downloadListTasks = this.reconciliationDownloadTaskService.findByAccNoAndBankVersionIDAndTransDateBetween(fixedAccNo, bankVersionID, null, startDate, endDate);
        List detailList = new ArrayList(16);
        HashMap transDateMap = Maps.newHashMapWithExpectedSize((int)8);
        ArrayList<Long> refIDs = new ArrayList<Long>(16);
        for (ReconciliationInfo info : downloadListTasks) {
            ReceiptResult result = new ReceiptResult();
            result.setCompleteFlas(1);
            result.setTransDate(info.getTransDate());
            result.setRefID(info.getId());
            refIDs.add(info.getId());
            transDateMap.put(info.getId(), info.getTransDate());
        }
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "id")});
        detailList = this.reconciliationDownloadListDetailRepository.findByRefidInAndAccNo(refIDs, fixedAccNo);
        ArrayList<ReceiptInfo> bankReceiptInfos = new ArrayList<ReceiptInfo>(16);
        if (detailList.size() > 0) {
            for (ReconciliationDetail detail : detailList) {
                if (detail.getUploadFlag().intValue() != UploadStatusEnum.UPLOAD_SUCCESS.getId()) continue;
                ReceiptInfo info = new ReceiptInfo();
                info.setFilePath(detail.getBankFilePath());
                info.setTransDate(((LocalDate)transDateMap.get(detail.getRefid())).format(DateTimeFormatter.BASIC_ISO_DATE));
                info.setAccNo(request.getAccNo());
                info.setAccName(EBContext.getContext().getBankAcnt().getAccName());
                info.setBankName(EBContext.getContext().getBankAcnt().getBankName());
                info.setExplanation(ResManager.loadKDString((String)"\u6587\u4ef6\u7c7b\u7684\u5bf9\u8d26\u5355\uff0c\u8bf7\u67e5\u9605\u5bf9\u8d26\u5355\u6587\u4ef6\u5185\u5bb9\u3002", (String)"FileReconciliationImpl_1", (String)"ebg-receipt-business", (Object[])new Object[0]));
                String uploadFileName = detail.getUploadFileName();
                if (!EBGStringUtils.isEmpty((String)uploadFileName)) {
                    info.setUploadFileName(uploadFileName);
                }
                info.setUploadFlag(detail.getUploadFlag());
                bankReceiptInfos.add(info);
            }
        }
        responseEB.setReceiptInfos(bankReceiptInfos);
        responseEB.setTcpUrl("");
        responseEB.setFileServerUrl("");
        responseEB.setUserName("");
        responseEB.setFileFlag(1);
        responseEB.setCompleteFlag(1);
        responseEB.setUserName("");
        return responseEB;
    }

    public boolean match(ReceiptRequest receiptRequest) {
        boolean result = "reconciliation".equalsIgnoreCase(receiptRequest.getHeader().getBizType()) || "reconciliation".equalsIgnoreCase(receiptRequest.getHeader().getSubBizType()) || "reconciliationPage".equalsIgnoreCase(receiptRequest.getHeader().getSubBizType());
        return result;
    }
}

