/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.utils;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.login.utils.sms.impl.KDSMSSender;
import kd.bos.message.api.MessageChannels;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.ReceiptSystemProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptExceptionUtil;
import kd.ebg.receipt.common.model.repository.monitor.AlertMessageRepository;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class MessageToUserUtil {
    EBGLogger logger = EBGLogger.getInstance().getLogger(MessageToUserUtil.class);

    public void sendAlertMsgToUser(ReceiptSystemProperties receiptSystemProperties, String errorMsg, String messageSource) {
        AlertMessageRepository alertMessageRepository = (AlertMessageRepository)SpringContextUtil.getBean(AlertMessageRepository.class);
        String alertType = ResManager.loadKDString((String)"\u624b\u673a\u77ed\u4fe1", (String)"MessageToUserUtil_0", (String)"ebg-receipt-business", (Object[])new Object[0]);
        String recUser = receiptSystemProperties.getReceiptMobile();
        boolean result = false;
        String title = ResManager.loadKDString((String)"\u56de\u5355\u4e0b\u8f7d\u8fde\u63a5\u76d1\u63a7\u9884\u8b66\u3002", (String)"MessageToUserUtil_1", (String)"ebg-receipt-business", (Object[])new Object[0]);
        if (Objects.equals(messageSource, "4")) {
            title = ResManager.loadKDString((String)"\u56de\u5355\u7f3a\u5931\u62a5\u8868\u9884\u8b66\u3002", (String)"MessageToUserUtil_2", (String)"ebg-receipt-business", (Object[])new Object[0]);
        }
        String[] arrays = null;
        if (Objects.equals(receiptSystemProperties.getReceiptAlertWay(), "mobile")) {
            arrays = receiptSystemProperties.getReceiptMobile().split("\\;");
        } else {
            alertType = ResManager.loadKDString((String)"\u90ae\u4ef6", (String)"MessageToUserUtil_3", (String)"ebg-receipt-business", (Object[])new Object[0]);
            arrays = receiptSystemProperties.getReceiptEmail().split("\\;");
        }
        for (String receiver : arrays) {
            try {
                if (Objects.equals(receiptSystemProperties.getReceiptAlertWay(), "mobile")) {
                    result = this.sendAlertMobileMsgToUser(errorMsg, receiver);
                }
                if (Objects.equals(receiptSystemProperties.getReceiptAlertWay(), "email")) {
                    result = this.sendAlertEmailMsgToUser(receiver, errorMsg, title);
                }
                alertMessageRepository.save(messageSource, alertType, recUser, new Date(), String.format(ResManager.loadKDString((String)"\u91d1\u8776\u94f6\u4f01\u4e91%s\u3002", (String)"MessageToUserUtil_4", (String)"ebg-receipt-business", (Object[])new Object[0]), errorMsg), String.valueOf(result));
            }
            catch (Exception e) {
                alertMessageRepository.save(messageSource, alertType, recUser, new Date(), String.format(ResManager.loadKDString((String)"\u91d1\u8776\u94f6\u4f01\u4e91 %1$s %2$s\u3002", (String)"MessageToUserUtil_11", (String)"ebg-receipt-business", (Object[])new Object[0]), errorMsg, ReceiptExceptionUtil.formatException((Throwable)e, (int)100)), String.valueOf(result));
            }
        }
    }

    public boolean sendAlertMobileMsgToUser(String errorMsg, String mobile) {
        if (StringUtils.isEmpty((String)mobile)) {
            this.logger.info("\u9884\u8b66\u6d88\u606f\u53d1\u9001\u5b8c\u6210,\u53d1\u9001\u7ed3\u679c\uff1a\u624b\u673a\u53f7\u4e3a\u7a7a");
            throw new ReceiptException(ResManager.loadKDString((String)"\u9884\u8b66\u624b\u673a\u53f7\u4e3a\u7a7a\u3002", (String)"MessageToUserUtil_7", (String)"ebg-receipt-business", (Object[])new Object[0]));
        }
        KDSMSSender sender = new KDSMSSender();
        boolean result = sender.sendMessage(mobile, errorMsg, ResManager.loadKDString((String)"\u91d1\u8776\u94f6\u4f01\u4e91", (String)"MessageToUserUtil_8", (String)"ebg-receipt-business", (Object[])new Object[0]));
        this.logger.info("\u9884\u8b66\u6d88\u606f\u53d1\u9001\u5b8c\u6210,\u53d1\u9001\u7ed3\u679c\uff1a{}", (Object)result);
        return result;
    }

    public boolean sendAlertEmailMsgToUser(String email, String errorMsg, String title) {
        if (StringUtils.isEmpty((String)email)) {
            this.logger.info(ResManager.loadKDString((String)"\u9884\u8b66\u6d88\u606f\u53d1\u9001\u5b8c\u6210\uff0c\u53d1\u9001\u7ed3\u679c\uff1afalse \u6536\u4ef6\u4eba\u90ae\u7bb1\u5730\u5740\u4e3a\u7a7a\u3002", (String)"MessageToUserUtil_12", (String)"ebg-receipt-business", (Object[])new Object[0]));
            throw new ReceiptException(ResManager.loadKDString((String)"\u9884\u8b66\u624b\u673a\u53f7\u4e3a\u7a7a\u3002", (String)"MessageToUserUtil_7", (String)"ebg-receipt-business", (Object[])new Object[0]));
        }
        MessageInfo message = new MessageInfo();
        LocaleString titleL = new LocaleString();
        titleL.setLocaleValue_zh_CN(title);
        LocaleString content = new LocaleString();
        content.setLocaleValue_zh_CN(errorMsg);
        LocaleString tag = new LocaleString();
        tag.setLocaleValue(ResManager.loadKDString((String)"\u9884\u8b66", (String)"MessageToUserUtil_10", (String)"ebg-receipt-business", (Object[])new Object[0]));
        message.setMessageTitle((ILocaleString)titleL);
        message.setMessageContent((ILocaleString)content);
        message.setMessageTag((ILocaleString)tag);
        message.setSenderId(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        message.setType("message");
        message.setEntityNumber("bos_wf_greentree");
        message.setOperation("submit");
        message.setTplScene("success");
        StringBuilder notifyType = new StringBuilder();
        notifyType.append(MessageChannels.EMAIL).append(",");
        message.setNotifyType(notifyType.toString());
        ArrayList<String> emails = new ArrayList<String>(16);
        emails.add(email);
        HashMap p = Maps.newHashMapWithExpectedSize((int)16);
        p.put("email", emails);
        message.setParams((Map)p);
        MessageCenterServiceHelper.sendMessage((MessageInfo)message);
        return true;
    }
}

