/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.business.receipt.utils;

import com.google.common.base.Preconditions;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.receipt.business.receipt.bank.ReceiptInfo;
import kd.ebg.receipt.business.receipt.bank.ReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.ReceiptResponseEB;
import kd.ebg.receipt.common.entity.biz.receipt.QueryReceiptRequest;
import kd.ebg.receipt.common.entity.biz.receipt.QueryReceiptRequestBody;
import kd.ebg.receipt.common.entity.biz.receipt.QueryReceiptResponse;
import kd.ebg.receipt.common.entity.biz.receipt.QueryReceiptResponseBody;
import kd.ebg.receipt.common.entity.biz.receipt.ReceiptDetail;
import kd.ebg.receipt.common.framework.utils.CurrencyUtils;

public class ReceiptConvert {
    public static ReceiptRequest convert(QueryReceiptRequest queryReceiptRequest) {
        QueryReceiptRequestBody body = queryReceiptRequest.getBody();
        String accNo = queryReceiptRequest.getHeader().getAccNo();
        String startDate = body.getStartDate();
        String endDate = body.getEndDate();
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)startDate), (Object)ResManager.loadKDString((String)"\u67e5\u8be2\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReceiptConvert_0", (String)"ebg-receipt-business", (Object[])new Object[0]));
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)endDate), (Object)ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReceiptConvert_1", (String)"ebg-receipt-business", (Object[])new Object[0]));
        ReceiptRequest receiptRequest = new ReceiptRequest();
        BankHeader header = new BankHeader();
        receiptRequest.setHeader(header);
        BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
        header.setAcnt(mainAcnt);
        header.setBankLoginID(mainAcnt.getBankLoginId());
        header.setBankVersionID(mainAcnt.getBankVersionId());
        header.setCustomerID(queryReceiptRequest.getHeader().getCustomId());
        header.setBizSeqID(queryReceiptRequest.getHeader().getLogBizSeqID());
        header.setBizType(queryReceiptRequest.getHeader().getBizType());
        header.setSubBizType(queryReceiptRequest.getHeader().getSubBizType());
        header.setClientName(queryReceiptRequest.getHeader().getClientName());
        header.setClientVersion(queryReceiptRequest.getHeader().getClientVersion());
        String currency = mainAcnt.getCurrency();
        String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
        header.setBankCurrency(bankCurrency);
        header.setExtData(queryReceiptRequest.getHeader().getExtData());
        receiptRequest.setStartDate(LocalDate.parse(startDate, DateTimeFormatter.BASIC_ISO_DATE));
        receiptRequest.setEndDate(LocalDate.parse(endDate, DateTimeFormatter.BASIC_ISO_DATE));
        receiptRequest.setAccNo(mainAcnt.getAccNo());
        return receiptRequest;
    }

    public static QueryReceiptResponse convert(ReceiptResponseEB receiptResponse) {
        QueryReceiptResponse response = new QueryReceiptResponse();
        QueryReceiptResponseBody body = new QueryReceiptResponseBody();
        response.setBody(body);
        body.setCompleteFlag(receiptResponse.getCompleteFlag());
        body.setFileFlag(receiptResponse.getFileFlag());
        body.setHost(receiptResponse.getHost());
        body.setUserName(receiptResponse.getUserName());
        body.setPort(receiptResponse.getPort());
        body.setProxy(receiptResponse.getProxy());
        body.setFileServerUrl(receiptResponse.getFileServerUrl());
        body.setTcpUrl(receiptResponse.getTcpUrl());
        if (receiptResponse.getEbException() != null) {
            response.setException(receiptResponse.getEbException());
        }
        List<ReceiptInfo> receiptInfos = receiptResponse.getReceiptInfos();
        ArrayList<ReceiptDetail> details = new ArrayList<ReceiptDetail>(16);
        if (Objects.nonNull(receiptInfos) && receiptInfos.size() > 0) {
            for (ReceiptInfo info : receiptInfos) {
                details.add(ReceiptConvert.convert(info));
            }
        }
        body.setDetails(details);
        return response;
    }

    public static ReceiptDetail convert(ReceiptInfo info) {
        ReceiptDetail detail = new ReceiptDetail();
        FieldUtils.fieldsCopy((Object)info, (Object)detail);
        return detail;
    }
}

