/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.icbc.opa.service.receipt;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.icbc.opa.service.receipt.ICBCOpaCommConfig;
import kd.ebg.receipt.common.framework.receipt.parse.impl.AbstractFileParser;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;

public class ICBCOpaFileParser
extends AbstractFileParser {
    public String getAccNo() {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        ICBCOpaCommConfig config = (ICBCOpaCommConfig)EBConfigBuilder.getInstance().buildConfig(ICBCOpaCommConfig.class, bankLoginId);
        boolean isPushedFromMaster = config.getPushFileType().contains("MASTER");
        if (isPushedFromMaster) {
            return this.getParsedString(0);
        }
        if ("OFD".equals(config.getPushFileType())) {
            return this.getParsedString(0);
        }
        return this.getParsedString(1);
    }

    public LocalDate getDate() {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        ICBCOpaCommConfig config = (ICBCOpaCommConfig)EBConfigBuilder.getInstance().buildConfig(ICBCOpaCommConfig.class, bankLoginId);
        boolean isPushedFromMaster = config.getPushFileType().contains("MASTER");
        if (isPushedFromMaster) {
            return LocalDateUtil.parserDate((String)this.getParsedString(1));
        }
        if ("OFD".equals(config.getPushFileType())) {
            return LocalDateUtil.parserDate((String)this.getParsedString(3));
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return LocalDate.parse(this.getParsedString(4), df);
    }

    public String getReceiptNo() {
        String bankLoginId = EBContext.getContext().getBankLoginID();
        ICBCOpaCommConfig config = (ICBCOpaCommConfig)EBConfigBuilder.getInstance().buildConfig(ICBCOpaCommConfig.class, bankLoginId);
        boolean isPushedFromMaster = config.getPushFileType().contains("MASTER");
        if (isPushedFromMaster) {
            return this.getParsedString(2);
        }
        if ("OFD".equals(config.getPushFileType())) {
            return this.getParsedString(2);
        }
        return this.getParsedString(3);
    }

    public String getFileSplit() {
        return "_";
    }

    public String getBankVersion() {
        return "ICBC_OPA";
    }
}

