/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.icbc.opa.service.receipt.utils;

import com.icbc.api.response.MybankEnterpriseTradeQhisdResponseV1;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.common.model.DetailInfo;

public class ICBC_OPA_Parser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ICBC_OPA_Parser.class);

    public static List<DetailInfo> parse(BankDetailRequest rqst, MybankEnterpriseTradeQhisdResponseV1 response) {
        ArrayList<DetailInfo> list = new ArrayList<DetailInfo>(16);
        if (response.isSuccess()) {
            List responseRds = response.getRd();
            if (responseRds == null || responseRds.size() == 0) {
                return list;
            }
            for (MybankEnterpriseTradeQhisdResponseV1.MybankEnterpriseTradeQhisdResponseRdV1 rd : responseRds) {
                DetailInfo info = new DetailInfo();
                info.setAccNo(response.getAccountNo());
                info.setAccName(rqst.getAcnt().getAccName());
                info.setOppAccNo(rd.getRecipAccountNo());
                info.setOppAccName(rd.getRecipName());
                info.setOppBankName(rd.getRecipBkName());
                info.setExplanation(rd.getSummary() + "-" + rd.getRemark() + "-" + rd.getPostScript());
                info.setReceiptNo(rd.getOnlySequence());
                list.add(info);
            }
        } else {
            EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25 \u3002\u7f51\u5173\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%1$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\uff1a%2$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%3$s\u3002", (String)"DetailParser_0", (String)"ebg-receipt-banks-icbc-opa", (Object[])new Object[0]), response.getReturnMsg(), response.getReturnCode(), response.getReturnMsg()));
        }
        return list;
    }
}

