/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.icbc.opa.service.receipt.utils;

import com.jcraft.jsch.ChannelSftp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.stream.Collectors;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;

public class TodayReceiptUtils {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(TodayReceiptUtils.class);
    private static TodayReceiptUtils todayReceiptUtils;

    public static synchronized TodayReceiptUtils getInstance() {
        if (todayReceiptUtils == null) {
            todayReceiptUtils = new TodayReceiptUtils();
        }
        return todayReceiptUtils;
    }

    public boolean isContainsByName(List<String> receiptList, String name) {
        String zipNameOfSFTP = receiptList.stream().filter(o -> o.contains(name)).findFirst().orElse("");
        return EBGStringUtils.isNotEmpty((String)zipNameOfSFTP);
    }

    public String getNameContainsByName(List<String> receiptList, String name) {
        String zipNameOfSFTP = receiptList.stream().filter(o -> o.contains(name)).findFirst().orElse("");
        return zipNameOfSFTP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getReceiptList(BankFtpProperties ftpProperties, String accNo, LocalDate transDate) {
        String sftp_path = ftpProperties.getFtpPath();
        String ftpPath = sftp_path = EBGStringUtils.isNotEmpty((String)sftp_path) ? sftp_path : "/";
        String transDateStr = transDate.format(DateTimeFormatter.BASIC_ISO_DATE);
        List<String> receiptList = new ArrayList<String>(1);
        ChannelSftp sftp = null;
        try {
            String matchStr;
            List<String> filenames;
            if (ftpProperties.getReceiptAchieveWay().equals("sftp") && (sftp = SFTPUtils.getInstance().getSftp()) != null) {
                try {
                    Vector vector = sftp.ls(ftpPath);
                    if (!vector.isEmpty()) {
                        for (int i = 0; i < vector.size(); ++i) {
                            ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)vector.get(i);
                            String fileName = file.getFilename();
                            if (!this.isTodayZip(fileName, accNo, transDateStr)) continue;
                            receiptList.add(fileName);
                        }
                    }
                }
                catch (Throwable e) {
                    logger.error("\u83b7\u53d6sftp\u76ee\u5f55\u5f02\u5e38\uff1a", e);
                }
            }
            if (ftpProperties.getReceiptAchieveWay().equals("bank_login") && (receiptList = (filenames = this.getFileByName(transDateStr, accNo, transDate, matchStr = String.format("%s_%s", transDateStr, accNo))).stream().filter(o -> this.isTodayZip((String)o, accNo, transDateStr)).collect(Collectors.toList())) == null) {
                receiptList = new ArrayList(1);
            }
        }
        catch (Throwable throwable) {
            SFTPUtils.getInstance().close(sftp);
            throw throwable;
        }
        SFTPUtils.getInstance().close(sftp);
        return receiptList;
    }

    public List<String> getFileByName(String matchString, String accNo, LocalDate transDate, String suffix) {
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.getFileByName(matchString, suffix);
    }

    public boolean isTodayZip(String fileName, String accNo, String transDateStr) {
        return EBGStringUtils.isNotEmpty((String)fileName) && fileName.endsWith(".zip") && fileName.contains(accNo) && fileName.contains(transDateStr);
    }

    public Date getSftpModifyTime(ChannelSftp.LsEntry sftpInfo) {
        SimpleDateFormat sdf1 = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
        Date parse = null;
        try {
            String mtimeString = sftpInfo.getAttrs().getMtimeString();
            parse = sdf1.parse(mtimeString);
            return parse;
        }
        catch (Throwable e) {
            logger.info("\u83b7\u53d6sftp\u76ee\u5f55\u4e0b\u7684" + sftpInfo.getFilename() + "\u6587\u4ef6\u4fee\u6539\u65e5\u671f\u5931\u8d25\u3002");
            return new Date();
        }
    }
}

