/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bochk.dc.service;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.receipt.banks.bochk.dc.service.detail.DetailImpl;
import kd.ebg.receipt.banks.bochk.dc.service.receipt.OnlineRequest;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.utils.CurrencyUtils;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        String accNo = request.getAccNo();
        String bankVersionId = request.getBankVersionId();
        LocalDate transDate = request.getTransDate();
        BankAcnt acnt = new BankAcnt();
        BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
        String currency = mainAcnt.getCurrency();
        String bankCurrency = CurrencyUtils.convert2Bank((String)currency);
        acnt.setAccNo(accNo);
        acnt.setCurrency(bankCurrency);
        ArrayList<DownloadListDetail> downloadListDetails = new ArrayList<DownloadListDetail>(16);
        String transDateStr = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)transDateStr);
        logger.info("\u83b7\u53d6\u7535\u5b50\u56de\u5355\u8bf7\u6c42\u4fe1\u606f\uff1a\n accNo = " + accNo + " and transDate = " + transDateStr + "\n");
        List<List<String[]>> transRefs = this.sendAndReceiveTransRefs(acnt, transDate);
        for (int i = 0; i < transRefs.size(); ++i) {
            List<String[]> transRef = transRefs.get(i);
            if (i != 0) {
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    logger.info("\u5904\u7406{}\u65f6\u7ebf\u7a0b\u88ab\u4e2d\u65ad", transRef);
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            HashMap<String, List<String[]>> paramMap = new HashMap<String, List<String[]>>(2);
            paramMap.put("TransRef", transRef);
            BankReceiptRequest req = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).paramsMap(paramMap).build();
            BankReceiptResponseEB response = new OnlineRequest().doBiz(req);
            String requestID = (String)response.getData();
            downloadListDetail.setFileName(requestID + ".zip");
            downloadListDetail.setFileLink(requestID);
            downloadListDetails.add(downloadListDetail);
        }
        logger.info(">>>>>>>>>FETCH-{}-{}-\u8bb0\u5f55\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, downloadListDetails.size()});
        return BankReceiptHandleResponseEB.success(downloadListDetails);
    }

    private List<List<String[]>> sendAndReceiveTransRefs(BankAcnt account, LocalDate transDate) {
        BankDetailRequest request = new BankDetailRequest();
        BankHeader header = new BankHeader();
        header.setAcnt(account);
        request.setHeader(header);
        request.setStartDate(transDate);
        request.setEndDate(transDate);
        request.setBankCurrency(account.getCurrency());
        EBBankDetailResponse response = new DetailImpl().doBiz(request);
        List details = response.getDetails();
        ArrayList<List<String[]>> transRefs = new ArrayList<List<String[]>>(2);
        int maxSize = 30;
        for (int currentIndex = 0; currentIndex < details.size(); currentIndex += maxSize) {
            int endIndex = Math.min(currentIndex + maxSize, details.size());
            List sub = details.subList(currentIndex, endIndex);
            ArrayList<String[]> transRef = new ArrayList<String[]>();
            for (DetailInfo detailInfo : sub) {
                transRef.add(new String[]{detailInfo.getBizRefNo(), detailInfo.getId()});
            }
            transRefs.add(transRef);
        }
        return transRefs;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-bochk-dc", (Object[])new Object[0]);
    }

    public boolean isBreak() {
        return true;
    }
}

