/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cabc.dc.service.receipt.utils;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.cabc.dc.service.receipt.CabcDcCommConfig;
import kd.ebg.receipt.banks.cabc.dc.service.receipt.utils.GetSign;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import org.jdom2.Element;

public class RequestPacker {
    public static String pack(DownloadListTask task) {
        try {
            String bankLogin = task.getBankLoginId();
            CabcDcCommConfig config = (CabcDcCommConfig)EBConfigBuilder.getInstance().buildConfig(CabcDcCommConfig.class, bankLogin);
            String host = config.getReceipFitchList_signIp();
            int port = config.getReceipFitchList_signPort();
            String localTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            String bankNum = "806";
            String userId = config.getReceipFitchList_userId();
            String randomNum = RequestPacker.randomNumBySize(4);
            String serialNo = localTime + bankNum + userId + randomNum;
            Element opReq = RequestPacker.opReqPacker(serialNo, task);
            String opReqStr = null;
            opReqStr = JDomUtils.root2StringNoIndentLineNoSeparator((Element)opReq, (String)"GBK");
            if (StringUtils.isNotEmpty((String)opReqStr)) {
                opReqStr = opReqStr.replace("<?xml version=\"1.0\" encoding=\"GBK\"?>", "");
            }
            String signed_data = GetSign.getSignData(opReqStr, host, port);
            Element root = JDomExtUtils.createRoot((String)"BankData");
            Element Sign = JDomUtils.addChild((Element)root, (String)"Sign");
            JDomUtils.addChild((Element)Sign, (String)"SignedData", (String)signed_data);
            JDomUtils.addChild((Element)Sign, (String)"PubKey", (String)"");
            JDomUtils.addChild((Element)root, (Element)RequestPacker.opReqPacker(serialNo, task));
            String request = null;
            request = JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)"GBK");
            if (StringUtils.isNotEmpty((String)request)) {
                return RequestPacker.requestHead(request, serialNo) + request;
            }
        }
        catch (Exception e) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u6253\u5305\u5f02\u5e38\uff1a", (String)"RequestPacker_0", (String)"ebg-receipt-banks-cabc-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return "";
    }

    public static String randomNumBySize(int length) {
        SecureRandom random = new SecureRandom();
        StringBuilder returnValue = new StringBuilder();
        int randomInt = 0;
        int range = 9;
        for (int i = 0; i < length; ++i) {
            randomInt = random.nextInt(range + 1);
            returnValue.append(randomInt);
        }
        return returnValue.toString();
    }

    public static String requestHead(String request, String serialNo) {
        String msgLen;
        String opname;
        String op = opname = "ReceiptURLQry";
        try {
            for (int i = 0; i < 25 - op.length(); ++i) {
                opname = "0" + opname;
            }
        }
        catch (Exception e) {
            throw new ReceiptException((Throwable)e);
        }
        String requestLen = msgLen = String.valueOf(request.getBytes(StandardCharsets.UTF_8).length);
        try {
            for (int i = 0; i < 8 - msgLen.length(); ++i) {
                requestLen = "0" + requestLen;
            }
        }
        catch (Exception e) {
            throw new ReceiptException((Throwable)e);
        }
        return serialNo + opname + requestLen;
    }

    public static Element opReqPacker(String serialNo, DownloadListTask task) {
        String bankLogin = task.getBankLoginId();
        CabcDcCommConfig config = (CabcDcCommConfig)EBConfigBuilder.getInstance().buildConfig(CabcDcCommConfig.class, bankLogin);
        String userId = config.getReceipFitchList_userId();
        String opname = "ReceiptURLQry";
        String cstNo = config.getReceipFitchList_cstNo();
        String userNo = config.getReceipFitchList_userNo();
        String reqTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        String accountNo = task.getAccNo();
        String qryDate = task.getTransDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        Element opReq = new Element("opReq");
        JDomUtils.addChild((Element)opReq, (String)"opname", (String)opname);
        JDomUtils.addChild((Element)opReq, (String)"cstNo", (String)cstNo);
        JDomUtils.addChild((Element)opReq, (String)"userNo", (String)userNo);
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)serialNo);
        JDomUtils.addChild((Element)opReq, (String)"userId", (String)userId);
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)reqTime);
        Element ReqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"accountNo", (String)accountNo);
        JDomUtils.addChild((Element)ReqParam, (String)"qryDate", (String)qryDate);
        return opReq;
    }
}

