/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.gdb.dc.service.receipt;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.gdb.dc.service.receipt.api.BankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String bankVersionId = request.getBankVersionId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        long taskId = request.getTaskId();
        String bankLogin = request.getBankLoginId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        if (transDate.isEqual(LocalDate.now())) {
            List<DownloadListDetail> transform = this.transform(downloadListDetails, accNo, transDate, bakFilePath);
            result.addAll(transform);
            return BankReceiptHandleResponseEB.success(result);
        }
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        ChannelSftp sftp = null;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp") && SFTPUtils.getInstance().isAbort(sftp)) {
            sftp = SFTPUtils.getInstance().getSftp(bankLogin);
        }
        boolean isLastFile = false;
        for (int i = 0; i < downloadListDetails.size(); ++i) {
            if (i == downloadListDetails.size() - 1) {
                isLastFile = true;
            }
            DownloadListDetail downloadListDetail = (DownloadListDetail)downloadListDetails.get(i);
            downloadListDetail.setBankFilePath(bakFilePath + File.separator + downloadListDetail.getFileName());
            if (downloadListDetail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                result.add(downloadListDetail);
                continue;
            }
            List<DownloadListDetail> details = this.download(downloadListDetail, bakFilePath, accNo, transDate, bankFtpProperties, sftp, isLastFile);
            result.addAll(details);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DownloadListDetail> download(DownloadListDetail detail, String bakFilePath, String accNo, LocalDate transDate, BankFtpProperties bankFtpProperties, ChannelSftp sftp, boolean isLastFile) {
        String fileName = detail.getFileLink();
        String newFileName = detail.getFileName();
        String date = transDate.toString().replaceAll("-", "");
        String ftpPath = "/" + accNo + "/" + date;
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        try {
            boolean flag = false;
            if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                String sftpPath = EBGStringUtils.isEmpty((String)bankFtpProperties.getFtpPath()) ? ftpPath : bankFtpProperties.getFtpPath() + ftpPath;
                flag = SFTPUtils.getInstance().downloadSingleFile(sftpPath, fileName, bakFilePath, sftp);
            } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
                BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                String frontProxyPath = bankFtpProperties.getFrontProxyPath() + ftpPath;
                flag = bankReceiptApiUtil.downloadReceiptFileWithPath(frontProxyPath, fileName, bakFilePath);
            }
            if (flag) {
                File saveFile = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + fileName));
                FileCommonUtils.moveFile((File)saveFile, (String)bakFilePath, (String)newFileName);
                logger.info("\u5e7f\u53d1\u7535\u5b50\u56de\u5355\u6587\u4ef6 " + detail.getFileName() + " \u4e0b\u8f7d\u5b8c\u6210\u3002");
                result.add(detail);
            }
        }
        catch (Exception e) {
            isLastFile = true;
            throw new ReceiptException((Throwable)e);
        }
        finally {
            if (isLastFile && bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
                SFTPUtils.getInstance().close(sftp);
            }
        }
        return result;
    }

    public List<DownloadListDetail> transform(List<DownloadListDetail> downloadListDetails, String accNo, LocalDate transDate, String bakFilePath) {
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(8);
        BankReceiptImpl receipt = new BankReceiptImpl();
        for (DownloadListDetail detail : downloadListDetails) {
            HashMap<String, String> paramMap = new HashMap<String, String>(1);
            String fileName = detail.getFileName();
            String uniqueCode = detail.getFileLink();
            paramMap.put("uniqueCode", uniqueCode);
            BankReceiptRequest req = BankReceiptRequest.builder().transDate(transDate).accNo(accNo).paramsMap(paramMap).build();
            if (FileCommonUtils.isTestEnv()) {
                return result;
            }
            BankReceiptResponseEB res = receipt.doBiz(req);
            String fileContent = (String)res.getData();
            boolean b = FileCommonUtils.base64ToFile((String)fileContent, (String)(bakFilePath + File.separator + fileName));
            logger.info("\u5c06\u6587\u4ef6\u6d41\u8f6c\u6362\u6210\u6587\u4ef6\u7684\u7ed3\u679c\u4e3a{}", (Object)b);
            if (!b) continue;
            detail.setFileLink(fileName);
            result.add(detail);
        }
        return result;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CMB_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u62db\u884c\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-gdb-dc", (Object[])new Object[0]);
    }
}

