/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.hbb.dc.service.receipt.util;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class DownloadUtils {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(DownloadUtils.class);

    public static void unzip(String bankLogin, String acNo, String transDate, ChannelSftp sftp) {
        String zipFileName = String.format("%s_%s.zip", transDate, acNo);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"HBB_DC", (String)acNo, (String)transDate);
        boolean downloadFlag = false;
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLogin);
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            String ftpPath = EBGStringUtils.isEmpty((String)bankFtpProperties.getFtpPath()) ? "/" : bankFtpProperties.getFtpPath();
            downloadFlag = SFTPUtils.getInstance().downloadSingleFile(ftpPath, zipFileName, bakFilePath, sftp);
        } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
            LocalDate localDate = LocalDateUtil.parserDate((String)transDate);
            BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(acNo, localDate);
            String frontProxyPath = bankFtpProperties.getFrontProxyPath();
            downloadFlag = bankReceiptApiUtil.downloadReceiptFileWithPath(frontProxyPath, zipFileName, bakFilePath);
        }
        if (downloadFlag) {
            log.info("\u4e0b\u8f7d\u6587\u4ef6" + zipFileName + "\u6210\u529f");
            List fileList = FileCommonUtils.readZipFiles((String)(bakFilePath + File.separator + zipFileName));
            if (fileList == null) {
                throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6%s\u4e0d\u5305\u542bpdf\u683c\u5f0f\u7684\u56de\u5355\u6587\u4ef6\u3002", (String)"DownloadUtils_5", (String)"ebg-receipt-banks-hbb-dc", (Object[])new Object[0]), zipFileName));
            }
            if (GZFileUtils.unZipFiles((String)(bakFilePath + File.separator + zipFileName), (String)bakFilePath)) {
                FileCommonUtils.deleteFile((String)(bakFilePath + File.separator + zipFileName));
            }
        } else {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6%s\u5931\u8d25\u3002", (String)"DownloadUtils_6", (String)"ebg-receipt-banks-hbb-dc", (Object[])new Object[0]), zipFileName));
        }
    }
}

