/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bocom.dc.service.receipt.info;

import java.util.Objects;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;

public class BocomReceipt {
    public static final String SPLIT = "_";
    private String receiptDate;
    private String receiptNo;
    private String accountSerialNo;
    private String flowNo;
    private String receiptName;
    private String fileName;
    private String transAmount;
    private String cdFlag;

    public String getReceiptDate() {
        return this.receiptDate;
    }

    public String getReceiptNo() {
        return this.receiptNo;
    }

    public String getAccountSerialNo() {
        return this.accountSerialNo;
    }

    public String getFlowNo() {
        return this.flowNo;
    }

    public String getTransAmount() {
        return this.transAmount;
    }

    public static String getSPLIT() {
        return SPLIT;
    }

    public void setReceiptDate(String receiptDate) {
        this.receiptDate = receiptDate;
    }

    public void setReceiptNo(String receiptNo) {
        this.receiptNo = receiptNo;
    }

    public void setAccountSerialNo(String accountSerialNo) {
        this.accountSerialNo = accountSerialNo;
    }

    public void setFlowNo(String flowNo) {
        this.flowNo = flowNo;
    }

    public String getReceiptName() {
        return this.receiptName;
    }

    public void setReceiptName(String receiptName) {
        this.receiptName = receiptName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setTransAmount(String transAmount) {
        this.transAmount = transAmount;
    }

    public String getCdFlag() {
        return this.cdFlag;
    }

    public void setCdFlag(String cdFlag) {
        this.cdFlag = Objects.equals(PropertiesConstantsUtils.getValue((String)"DEBIT_USER"), cdFlag) ? "D" : (Objects.equals(PropertiesConstantsUtils.getValue((String)"CREDIT_USER"), cdFlag) ? "C" : cdFlag);
    }

    public static BocomReceipt parse(String text, String accNo, boolean isNew) {
        BocomReceipt bocomReceipt = null;
        if (!EBGStringUtils.isEmpty((String)text)) {
            String[] fields = EBGStringUtils.split((String)text, (String)"|!");
            bocomReceipt = new BocomReceipt();
            bocomReceipt.setReceiptDate(BocomReceipt.getValueByIndex(fields, 0));
            bocomReceipt.setReceiptNo(BocomReceipt.getValueByIndex(fields, 1));
            bocomReceipt.setAccountSerialNo(BocomReceipt.getValueByIndex(fields, 2));
            if (!isNew) {
                bocomReceipt.setFlowNo("1");
                bocomReceipt.setTransAmount(BocomReceipt.getValueByIndex(fields, 7));
                bocomReceipt.setCdFlag(BocomReceipt.getValueByIndex(fields, 8));
                bocomReceipt.setReceiptName(accNo + SPLIT + BocomReceipt.getValueByIndex(fields, 0) + SPLIT + BocomReceipt.getValueByIndex(fields, 2) + SPLIT + "1" + SPLIT + BocomReceipt.getValueByIndex(fields, 7) + SPLIT + bocomReceipt.getCdFlag() + ".pdf");
            } else {
                String flowNo = EBGStringUtils.isEmpty((String)BocomReceipt.getValueByIndex(fields, 3)) ? "1" : BocomReceipt.getValueByIndex(fields, 3);
                bocomReceipt.setFlowNo(flowNo);
                bocomReceipt.setTransAmount(BocomReceipt.getValueByIndex(fields, 8));
                bocomReceipt.setCdFlag(BocomReceipt.getValueByIndex(fields, 9));
                bocomReceipt.setReceiptName(accNo + SPLIT + BocomReceipt.getValueByIndex(fields, 0) + SPLIT + BocomReceipt.getValueByIndex(fields, 2) + SPLIT + flowNo + SPLIT + BocomReceipt.getValueByIndex(fields, 8) + SPLIT + bocomReceipt.getCdFlag() + ".pdf");
            }
            String fileName = BocomReceipt.getValueByIndex(fields, 0) + SPLIT + BocomReceipt.getValueByIndex(fields, 1) + SPLIT + BocomReceipt.getValueByIndex(fields, 2) + ".pdf";
            bocomReceipt.setFileName(fileName);
        }
        return bocomReceipt;
    }

    public static String getValueByIndex(String[] str, int index) {
        if (str.length > index + 1) {
            return str[index];
        }
        return "";
    }
}

