/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.fjhxb.dc.service;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.business.receipt.utils.BankReceiptApiUtil;
import kd.ebg.receipt.common.constant.UploadStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.match.MatchRule;
import kd.ebg.receipt.common.framework.receipt.bank.BankFtpProperties;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.EBConfigBuilder;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.SFTPUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        String accNo = request.getAccNo();
        String bankVersionId = request.getBankVersionId();
        String bankLoginId = request.getBankLoginId();
        LocalDate transDate = request.getTransDate();
        String transDateStr = transDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)transDateStr);
        BankFtpProperties bankFtpProperties = (BankFtpProperties)EBConfigBuilder.getInstance().buildConfig(BankFtpProperties.class, bankLoginId);
        logger.info(">>>>>>>>>\u798f\u5efa\u6d77\u5ce1\u94f6\u884c-{}-{}-\u56de\u5355\u8bb0\u5f55\u6570\u91cf\uff1a{}", new Object[]{accNo, transDate, downloadListDetails.size()});
        for (DownloadListDetail downloadListDetail : downloadListDetails) {
            String fileName = downloadListDetail.getFileName();
            String fileLink = downloadListDetail.getFileLink();
            String[] split = fileLink.split("!@#");
            String jsonStr = split[0];
            String waitingDownloadFilename = split[1];
            downloadListDetail.setFileLink(waitingDownloadFilename);
            String receiptFilePath = bakFilePath + File.separator + fileName;
            File receiptFile = FileCommonUtils.getFileByPath((String)receiptFilePath);
            if (receiptFile.exists() && downloadListDetail.getUploadFlag().intValue() == UploadStatusEnum.UPLOAD_SUCCESS.getId()) {
                logger.info(">>>>>>>>>-{}-{}-\u5f53\u524d\u56de\u5355\u6587\u4ef6\u5df2\u5b58\u5728\uff1a{}", new Object[]{accNo, transDate, receiptFile.getName()});
                result.add(downloadListDetail);
                continue;
            }
            boolean flag = this.download(downloadListDetail, true, bankLoginId, bankFtpProperties, bakFilePath);
            if (flag) {
                String receiptMatchNo = MatchRule.getInstance().getReceiptMatchNo(accNo, transDateStr, jsonStr);
                downloadListDetail.setReceiptJson(jsonStr);
                downloadListDetail.setDetailNo(receiptMatchNo);
                downloadListDetail.setFileLink(fileName);
                result.add(downloadListDetail);
                continue;
            }
            logger.info("\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25");
            downloadListDetail.setFileLink(fileLink);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public boolean download(DownloadListDetail detail, boolean isLastFile, String bankLoginId, BankFtpProperties bankFtpProperties, String bakFilePath) {
        ChannelSftp sftp = null;
        LocalDate transDate = detail.getTransDate();
        String localDate = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String accNo = detail.getAccNo();
        String fileName = detail.getFileLink();
        String sftp_path = bankFtpProperties.getFtpPath();
        sftp_path = EBGStringUtils.isEmpty((String)sftp_path) ? "/" + localDate : sftp_path + "/" + localDate;
        boolean flag = false;
        if (bankFtpProperties.getReceiptAchieveWay().equals("sftp")) {
            if (SFTPUtils.getInstance().isAbort(sftp)) {
                sftp = SFTPUtils.getInstance().getSftp(bankLoginId);
            }
            try {
                flag = SFTPUtils.getInstance().downloadSingleFile(sftp_path, detail.getFileLink(), bakFilePath, sftp);
            }
            catch (ReceiptException e) {
                try {
                    localDate = transDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    sftp_path = bankFtpProperties.getFtpPath();
                    sftp_path = EBGStringUtils.isEmpty((String)sftp_path) ? "/" + localDate : sftp_path + "/" + localDate;
                    flag = SFTPUtils.getInstance().downloadSingleFile(sftp_path, detail.getFileLink(), bakFilePath, sftp);
                }
                catch (ReceiptException ee) {
                    logger.info("\u4e0b\u8f7d\u5931\u8d25{}", (Object)ee);
                    return false;
                }
            }
            File file = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + fileName));
            if (file.exists()) {
                logger.info("\u6539\u540d");
                FileCommonUtils.moveFile((File)file, (String)bakFilePath, (String)detail.getFileName());
                detail.setBankFilePath(bakFilePath + File.separator + detail.getFileName());
            }
            if (isLastFile) {
                SFTPUtils.getInstance().close(sftp);
            }
        } else if (bankFtpProperties.getReceiptAchieveWay().equals("bank_login")) {
            logger.info("\u798f\u5efa\u6d77\u5ce1\u94f6\u884c\u901a\u8fc7\u4ee3\u7406\u83b7\u53d6\u56de\u5355\u6587\u4ef6=====");
            logger.info("\u798f\u5efa\u6d77\u5ce1\u94f6\u884c\u901a\u8fc7\u4ee3\u7406\u83b7\u53d6\u56de\u5355\u6587\u4ef6===== transDate {}", (Object)localDate);
            String ftpPath = bankFtpProperties.getFrontProxyPath() + File.separator + transDate;
            List<String> tempFiles = this.getFileByName(detail.getFileLink(), accNo, transDate, ftpPath);
            logger.info("\u798f\u5efa\u6d77\u5ce1\u94f6\u884c\u901a\u8fc7\u4ee3\u7406\u83b7\u53d6\u56de\u5355\u6587\u4ef6===== tempFiles {}", (Object)tempFiles.toString());
            if (tempFiles.isEmpty()) {
                ftpPath = bankFtpProperties.getFrontProxyPath() + File.separator + LocalDate.now();
                tempFiles = this.getFileByName(detail.getFileLink(), accNo, LocalDate.now(), ftpPath);
            }
            if (tempFiles != null && !tempFiles.isEmpty()) {
                logger.info("\u798f\u5efa\u6d77\u5ce1\u94f6\u884c-\u524d\u7f6e\u673a\u83b7\u53d6\u8fd4\u56de\u7684\u6587\u4ef6\u4e2a\u6570\uff1a{}", (Object)tempFiles.size());
                for (String tempFileName : tempFiles) {
                    if (!tempFileName.contains(detail.getFileLink())) continue;
                    BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
                    bankReceiptApiUtil.downloadReceiptFileWithPath(ftpPath, fileName, bakFilePath);
                    File file = FileCommonUtils.getFileByPath((String)(bakFilePath + File.separator + fileName));
                    logger.info("\u798f\u5efa\u6d77\u5ce1\u94f6\u884c\u901a\u8fc7\u4ee3\u7406\u83b7\u53d6\u56de\u5355\u6587\u4ef6=====\u4f7f\u7528\u5f53\u524d\u65f6\u95f4\u83b7\u53d6-isExists:{} fileName {}", new Object[]{file.exists(), detail.getFileName()});
                    if (!file.exists()) continue;
                    logger.info("\u798f\u5efa\u6d77\u5ce1\u94f6\u884c\u901a\u8fc7\u4ee3\u7406\u83b7\u53d6\u56de\u5355\u6587\u4ef6=====\u91cd\u547d\u540d: path:{} ", (Object)(bakFilePath + detail.getFileName()));
                    flag = FileCommonUtils.moveFile((File)file, (String)bakFilePath, (String)detail.getFileName());
                    logger.info("\u798f\u5efa\u6d77\u5ce1\u94f6\u884c\u901a\u8fc7\u4ee3\u7406\u83b7\u53d6\u56de\u5355\u6587\u4ef6====\u91cd\u547d\u540d\u7ed3\u679c:{} ", (Object)flag);
                    detail.setBankFilePath(bakFilePath + File.separator + detail.getFileName());
                }
            }
        }
        logger.info("sftp\u4e0b\u8f7d-{}-{}\uff1a{}-\u4e0b\u8f7d\u662f\u5426\u6210\u529f\uff1a{}", new Object[]{accNo, localDate, detail.getFileLink(), flag});
        return flag;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-fjhxb-dc", (Object[])new Object[0]);
    }

    private List<String> getFileByName(String matchString, String accNo, LocalDate transDate, String frontProxyPath) {
        BankReceiptApiUtil bankReceiptApiUtil = new BankReceiptApiUtil(accNo, transDate);
        return bankReceiptApiUtil.getFileByName(matchString, "", frontProxyPath);
    }
}

