/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.cmbc.dc.service.receipt;

import com.google.common.collect.Maps;
import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.cmbc.dc.service.receipt.api.BankReceiptFileDownImpl;
import kd.ebg.receipt.banks.cmbc.dc.service.receipt.info.CmbcFileInfo;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.constant.MatchStatusEnum;
import kd.ebg.receipt.common.constant.UploadTaskStatusEnum;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.EBCReceiptInfoJsonService;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import org.jdom2.Element;

public class BankReceiptDownloadImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public EBCReceiptInfoJsonService receiptInfoJsonService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.receiptInfoJsonService = (EBCReceiptInfoJsonService)SpringContextUtil.getBean(EBCReceiptInfoJsonService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.DOWNLOADING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        String bankVersionId = request.getBankVersionId();
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)bankVersionId, (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        long taskId = request.getTaskId();
        List downloadListDetails = this.downloadListDetailService.selectByRefId(Long.valueOf(taskId));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        for (int i = 0; i < downloadListDetails.size(); ++i) {
            DownloadListDetail downloadListDetail = (DownloadListDetail)downloadListDetails.get(i);
            if (downloadListDetail.getUploadFlag().intValue() == UploadTaskStatusEnum.UPLOAD_SUCCESS.getId() || downloadListDetail.getMatchFlag().intValue() == MatchStatusEnum.SUCCESS.getId()) {
                result.add(downloadListDetail);
                continue;
            }
            List<DownloadListDetail> details = this.download(downloadListDetail, bakFilePath, accNo, transDate);
            result.addAll(details);
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DownloadListDetail> download(DownloadListDetail detail, String bakFilePath, String accNo, LocalDate transDate) {
        String fileName = detail.getFileLink();
        String newFileName = detail.getFileName();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        String filePath = bakFilePath + File.separator + newFileName;
        if (fileName != null && fileName.length() > 0) {
            File receiptFile = FileCommonUtils.getFileByPath((String)filePath);
            if (receiptFile.exists()) {
                result.add(detail);
            } else {
                boolean download = this.downloadFromBank(fileName, newFileName, bakFilePath, accNo, transDate);
                if (download) {
                    result.add(detail);
                }
            }
        }
        return result;
    }

    private boolean downloadFromBank(String fileName, String newFileName, String bakFilePath, String accNo, LocalDate transDate) {
        String mixInfo = fileName;
        String[] innerNoInfos = EBGStringUtils.split((String)mixInfo, (String)"+");
        String innerNo = innerNoInfos[0];
        String xmlFileName = innerNoInfos[1];
        HashMap paramsMap = Maps.newHashMapWithExpectedSize((int)2);
        paramsMap.put("innerNo", innerNo);
        paramsMap.put("xmlFileName", xmlFileName);
        BankReceiptRequest receiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).paramsMap((Map)paramsMap).build();
        BankReceiptFileDownImpl iBankReceipt = new BankReceiptFileDownImpl();
        String responseStr = (String)((BankReceiptResponseEB)iBankReceipt.doBiz((BankRequest)receiptRequest)).getData();
        CmbcFileInfo cmbcFileInfo = this.parse(responseStr, xmlFileName);
        if (!EBGStringUtils.isEmpty((String)cmbcFileInfo.getFileName())) {
            String filePath = bakFilePath + File.separator + newFileName;
            if (!FileCommonUtils.base64ToFile((String)cmbcFileInfo.getFileContent(), (String)filePath)) {
                throw new ReceiptException(ResManager.loadKDString((String)"Base64\u89e3\u7801\u53d1\u751f\u9519\u8bef\uff0c\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25\u3002", (String)"BankReceiptDownloadImpl_0", (String)"ebg-receipt-banks-cmbc-dc", (Object[])new Object[0]));
            }
        } else {
            throw new ReceiptException(ResManager.loadKDString((String)"\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a", (String)"BankReceiptDownloadImpl_1", (String)"ebg-receipt-banks-cmbc-dc", (Object[])new Object[0]));
        }
        return true;
    }

    private CmbcFileInfo parse(String response, String compareFileName) {
        CmbcFileInfo result = new CmbcFileInfo();
        Element root = JDomExtUtils.str2DocGBK((String)response).getRootElement();
        Element status = root.getChild("responseHeader").getChild("status");
        String code = JDomUtils.getUnNullChildElement((Element)status, (String)"code").getTextTrim();
        String msg = JDomUtils.getUnNullChildElement((Element)status, (String)"message").getTextTrim();
        if ("0".equalsIgnoreCase(code)) {
            Element xDataBody = JDomExtUtils.getChildElement((Element)root, (String)"xDataBody");
            String fileName = JDomExtUtils.getChildElement((Element)xDataBody, (String)"DownloadFileName").getTextTrim();
            String fileContent = JDomExtUtils.getChildText((Element)xDataBody, (String)"DownloadFileContent");
            if (!EBGStringUtils.isEmpty((String)fileName)) {
                result.setFileName(fileName);
                result.setFileContent(fileContent);
            }
        } else {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u8c03\u7528b2eElectNoteDownLoad\u63a5\u53e3\u83b7\u53d6\u5230\u94f6\u884c\u9519\u8bef\u62a5\u6587\uff0c\u94f6\u884c\u8fd4\u56de\u7801[%1$s]:%2$s\u3002", (String)"BankReceiptDownloadImpl_4", (String)"ebg-receipt-banks-cmbc-dc", (Object[])new Object[0]), code, msg));
        }
        return result;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CMB_BankReceiptDownload";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u62db\u884c\u56de\u5355\u6587\u4ef6\u4e0b\u8f7d", (String)"BankReceiptDownloadImpl_3", (String)"ebg-receipt-banks-cmbc-dc", (Object[])new Object[0]);
    }
}

