/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.icbc.cmp.service.detail;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class CurrencyManager {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CurrencyManager.class);
    private static CurrencyManager currencyConvertor = null;
    private Map bank2Iso = Maps.newHashMapWithExpectedSize((int)8);

    private CurrencyManager() {
        this.init("currency_banktoiso_for_detail.properties");
    }

    public static synchronized CurrencyManager instance() {
        if (null == currencyConvertor) {
            currencyConvertor = new CurrencyManager();
        }
        return currencyConvertor;
    }

    private void init(String currencyFileName) {
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            try (InputStream ins = CurrencyManager.class.getClassLoader().getResourceAsStream(currencyFileName);){
                properties.load(ins);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (Exception e) {
            logger.error("Cannot load currency properties file:" + currencyFileName, (Throwable)e);
            return;
        }
        for (String string : properties.keySet()) {
            String bankValue = properties.getProperty(string);
            this.bank2Iso.put(string, bankValue);
        }
    }

    public String convert2BankStandard(String bankCurrency) {
        String isoCurrency;
        if ("CNY".equalsIgnoreCase(bankCurrency)) {
            bankCurrency = "RMB";
        }
        if ((isoCurrency = (String)this.bank2Iso.get(bankCurrency)) == null) {
            logger.info("\u672a\u627e\u5230\u94f6\u884c\u5e01\u79cd<" + bankCurrency + ">\u5bf9\u5e94\u7684\u6570\u5b57\u683c\u5f0f\u5e01\u79cd,\u8fd4\u56de\u539f\u94f6\u884c\u5e01\u79cd");
            return bankCurrency;
        }
        return isoCurrency;
    }
}

