/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.sde.dc.service.detail;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.banks.sde.dc.BankBusinessConfig;
import kd.ebg.receipt.banks.sde.dc.service.utils.SDEPackerUtils;
import kd.ebg.receipt.banks.sde.dc.service.utils.SDEParserUtils;
import kd.ebg.receipt.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.receipt.business.detail.atomic.IDetail;
import kd.ebg.receipt.business.detail.atomic.IHisDetail;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.match.MatchRule;
import kd.ebg.receipt.common.model.DetailInfo;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2EActTrsQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6", (String)"DetailImpl_0", (String)"ebg-receipt-banks-sde-dc", (Object[])new Object[0]);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        Element root = SDEPackerUtils.createRootWithHead(Sequence.genSequence(), this.getBizCode());
        Element Body = JDomUtils.addChild((Element)root, (String)"Body");
        Element List2 = JDomUtils.addChild((Element)Body, (String)"List");
        Element Map2 = JDomUtils.addChild((Element)List2, (String)"Map");
        JDomUtils.addChild((Element)Map2, (String)"AcNo", (String)bankDetailRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)Map2, (String)"Currency", (String)bankDetailRequest.getAcnt().getCurrency());
        JDomUtils.addChild((Element)Map2, (String)"BeginDate", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)Map2, (String)"EndDate", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        return JDomUtils.root2String((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public EBBankDetailResponse parse(BankDetailRequest rqst, String rspStr) {
        Element root = SDEParserUtils.parseRspToRoot(rspStr);
        BankResponse rsp = SDEParserUtils.parseResponse(root);
        if (!"000000".equals(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u5931\u8d25,\u94f6\u884c\u8fd4\u56de\u7801:%1$s,\u9519\u8bef\u4fe1\u606f:%2$s", (String)"DetailImpl_1", (String)"ebg-receipt-banks-sde-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element Body = JDomUtils.getChildElementNotNull((Element)root, (String)"Body");
        Element List2 = JDomUtils.getChildElement((Element)Body, (String)"List");
        Element Map2 = JDomUtils.getChildElement((Element)List2, (String)"Map");
        String ReturnCode = JDomUtils.getChildTextNotNull((Element)Map2, (String)"ReturnCode", (String)ResManager.loadKDString((String)"\u8fd4\u56de\u72b6\u6001\u7801", (String)"DetailImpl_2", (String)"ebg-receipt-banks-sde-dc", (Object[])new Object[0]));
        if (this.isNoDetailCode(ReturnCode)) {
            return new EBBankDetailResponse();
        }
        this.checkDetailRsp(rqst, Map2);
        List mapList = Map2.getChildren("Map");
        if (null == mapList || mapList.size() == 0) {
            log.error("\u8fd4\u56de\u4ea4\u6613\u660e\u7ec6\u62a5\u6587\u4e2d\u4e0d\u5b58\u5728\u8282\u70b9<Message/Body/List/Map/Map>");
            return new EBBankDetailResponse();
        }
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        for (int i = 0; i < mapList.size(); ++i) {
            Element map = (Element)mapList.get(i);
            detailList.add(this.parseSingleDetal(map, rqst.getAcnt().getAccNo(), rqst.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"))));
        }
        return new EBBankDetailResponse(detailList);
    }

    private boolean isNoDetailCode(String returnCode) {
        if (StringUtils.isEmpty((String)returnCode)) {
            return false;
        }
        List<String> codes = BankBusinessConfig.getNoDetailCodes();
        for (String code : codes) {
            if (!code.equalsIgnoreCase(returnCode)) continue;
            return true;
        }
        return false;
    }

    private void checkDetailRsp(BankDetailRequest rqst, Element Map2) {
        String ReturnCode = JDomUtils.getChildTextNotNull((Element)Map2, (String)"ReturnCode", (String)ResManager.loadKDString((String)"\u8fd4\u56de\u72b6\u6001\u7801", (String)"DetailImpl_2", (String)"ebg-receipt-banks-sde-dc", (Object[])new Object[0]));
        String ReturnMsg = JDomUtils.getChildTextNullAsBlank((Element)Map2, (String)"ReturnMsg");
        String AcNo = JDomUtils.getChildTextNotNull((Element)Map2, (String)"AcNo", (String)ResManager.loadKDString((String)"\u5e10\u53f7", (String)"DetailImpl_3", (String)"ebg-receipt-banks-sde-dc", (Object[])new Object[0]));
        if (!"000000".equals(ReturnCode)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u5931\u8d25,\u94f6\u884c\u8fd4\u56de\u7801:%1$s,\u9519\u8bef\u4fe1\u606f:%2$s", (String)"DetailImpl_1", (String)"ebg-receipt-banks-sde-dc", (Object[])new Object[0]), ReturnCode, ReturnMsg);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        if (!AcNo.equals(rqst.getAcnt().getAccNo())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u8fd4\u56de\u8d26\u53f7[%1$s]\u548c\u8bf7\u6c42\u8d26\u53f7[%2$s]\u4e0d\u4e00\u81f4\u3002", (String)"DetailImpl_4", (String)"ebg-receipt-banks-sde-dc", (Object[])new Object[0]), AcNo, rqst.getAcnt().getAccNo());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
    }

    private DetailInfo parseSingleDetal(Element map, String accNo, String transDate) {
        DetailInfo detail = new DetailInfo();
        String Amount = JDomUtils.getChildTextNotNull((Element)map, (String)"Amount", (String)"Amount");
        String Jno1 = JDomUtils.getChildTextNotNull((Element)map, (String)"TransJnlNo", (String)"TransJnlNo");
        String Jno2 = JDomUtils.getChildTextNotNull((Element)map, (String)"TransJnlNo2", (String)"TransJnlNo2");
        String cid = JDomUtils.getChildTextNotNull((Element)map, (String)"ChannelId", (String)"ChannelId");
        String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(map);
        detail.setReversed1(Jno1);
        detail.setReversed2(Jno2);
        detail.setReversed3(Amount);
        detail.setJson(jsonStr);
        detail.setReversed4(cid);
        return detail;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/xml");
        StringBuilder sb = new StringBuilder();
        sb.append("/eweb/").append(this.getBizCode()).append(".do?");
        sb.append("userPassword=");
        sb.append(RequestContextUtils.getBankParameterValue((String)"userPassword"));
        sb.append("&SIGDATA=1");
        factory.setUri(sb.toString());
    }
}

