/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.xib.dc.service.receipt.api;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.receipt.banks.xib.dc.service.receipt.utils.XiB_Packer;
import kd.ebg.receipt.banks.xib.dc.service.receipt.utils.XiB_Parser;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;

public class BankReceiptDownloadRequestImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptDownloadRequestImpl.class);

    public String pack(BankReceiptRequest request) {
        Map paramMap = request.getParamsMap();
        String ecmBatchNo = (String)paramMap.get("ecmBatchNo");
        String uniqueCode = (String)paramMap.get("uniqueCode");
        JsonObject body = new JsonObject();
        body.addProperty("ecmBatchNo", ecmBatchNo);
        body.addProperty("uniqueCode", uniqueCode);
        String reqstMsg = XiB_Packer.createHeadRoot("IESI109050", body);
        logger.info("\u53a6\u95e8\u56fd\u9645\u94f6\u884c\u76f4\u8fde\u7248-IESI109050\u63a5\u53e3-\u8bf7\u6c42\u62a5\u6587-\u52a0\u5bc6\u524d\uff1a\n" + reqstMsg);
        String signResult = XiB_Packer.sign(reqstMsg);
        logger.info("\u53a6\u95e8\u56fd\u9645\u94f6\u884c\u76f4\u8fde\u7248-IESI109050\u63a5\u53e3-\u8bf7\u6c42\u62a5\u6587-\u52a0\u5bc6\u540e\uff1a\n" + signResult);
        return signResult;
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        logger.info("\u53a6\u95e8\u56fd\u9645\u94f6\u884c\u76f4\u8fde\u7248-IESI109050\u63a5\u53e3-\u54cd\u5e94\u62a5\u6587\uff1a\n" + responseStr);
        BankResponse rsp = XiB_Parser.paseHeadRoot(responseStr);
        if ("000000".equals(rsp.getResponseCode()) || "00000".equals(rsp.getResponseCode())) {
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = jsonParser.parse(responseStr).getAsJsonObject();
            JsonObject body = jsonObject.get("body").getAsJsonObject();
            String fileUrl = body.get("fileUrl").getAsString();
            return BankReceiptResponseEB.success((Object)fileUrl);
        }
        throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u8c03\u7528IESI109050\u63a5\u53e3\u8fd4\u56de\u4e86\u975e\u6b63\u5e38\u7684\u8fd4\u56de\u7801\uff1a%1$s\uff1b\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%2$srsp.getResponseMessage()\u3002", (String)"BankReceiptDownloadRequestImpl_3", (String)"ebg-receipt-banks-xib-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "XIB_DC_RECEIPT_DOWNLOAD_REQUEST";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u53a6\u95e8\u56fd\u9645\u94f6\u884c\u76f4\u8fde\u7248IESI109050\u63a5\u53e3\u8bf7\u6c42", (String)"BankReceiptDownloadRequestImpl_2", (String)"ebg-receipt-banks-xib-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/ifspesi/dbe/api");
        factory.setHttpHeader("Content-Type", "text/json");
        factory.setHttpHeader("Accept-Charset", "GBK");
    }
}

