/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.statistics;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.front.api.boot.utils.StringUtils;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.ebg.receipt.formplugin.plugin.common.EbgCommonFilterContainerPlugin;
import kd.ebg.receipt.formplugin.plugin.util.ShowPageUtil;
import kd.ebg.receipt.formplugin.util.ReceiptStatisticsUtil;
import kd.ebg.receipt.formplugin.util.StringUtil;

public class ReceiptStatisticsByAcntAndDatePlugin
extends EbgCommonFilterContainerPlugin
implements HyperLinkClickListener {
    private static String ENTITY_KEY = "receipt_stats_by_ac_day";
    private static String ENTITY_KEY_RECEIPT_DOWNLOAD_TASK = "receipt_download_task";
    private int dataCount = 0;
    private EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptStatisticsByAcntAndDatePlugin.class);

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        final String customID = RequestContext.get().getTenantId();
        String startDateTime = "";
        String endDateTime = "";
        Long bankVersionId = null;
        Long acntID = null;
        Long bankLoginId = null;
        String bankVersionIdStr = this.getPageCache().get("selectedBankId");
        String selectedBankLoginIdStr = this.getPageCache().get("selectedBankLoginId");
        String selectedAcntIdStr = this.getPageCache().get("selectedAcntId");
        startDateTime = this.getPageCache().get("startDateTime");
        endDateTime = this.getPageCache().get("endDateTime");
        if (!StringUtils.isEmpty((String)bankVersionIdStr)) {
            bankVersionId = Long.parseLong(bankVersionIdStr);
        }
        if (!StringUtils.isEmpty((String)selectedBankLoginIdStr)) {
            bankLoginId = Long.parseLong(selectedBankLoginIdStr);
        }
        if (!StringUtils.isEmpty((String)selectedAcntIdStr)) {
            acntID = Long.parseLong(selectedAcntIdStr);
        }
        if (EBGStringUtils.isEmpty((String)startDateTime) || EBGStringUtils.isEmpty((String)endDateTime)) {
            return;
        }
        if (bankVersionId == null && acntID == null) {
            return;
        }
        final Date startDate = DateUtil.string2Date((String)startDateTime, (String)"yyyy-MM-dd HH:mm:ss");
        Date endDate = DateUtil.string2Date((String)endDateTime, (String)"yyyy-MM-dd HH:mm:ss");
        Date nowDate = new Date();
        if (DateUtil.isBefore((Date)nowDate, (Date)startDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u90fd\u5927\u4e8e\u4eca\u5929\u3002", (String)"ReceiptStatisticsByAcntAndDatePlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            return;
        }
        if (DateUtil.isBefore((Date)nowDate, (Date)endDate)) {
            endDate = nowDate;
        }
        final Long finalBankVersionId = bankVersionId;
        final Long finalBankLoginId = bankLoginId;
        final Long finalAcntID = acntID;
        final Date finalEndDate = endDate;
        final IPageCache iPageCache = this.getPageCache();
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                int currentPage = start / limit;
                int pageSize = limit;
                DynamicObjectCollection dObjectCollection = ReceiptStatisticsByAcntAndDatePlugin.this.getCollection(finalBankVersionId, finalBankLoginId, finalAcntID, startDate, finalEndDate, customID, currentPage, pageSize);
                this.getQueryResult().setCollection(dObjectCollection);
                this.getQueryResult().setDataCount(ReceiptStatisticsByAcntAndDatePlugin.this.dataCount);
                iPageCache.put("dataCount", ReceiptStatisticsByAcntAndDatePlugin.this.dataCount + "");
                return dObjectCollection;
            }

            public int getRealCount() {
                String dataCountStr = iPageCache.get("dataCount");
                if (!StringUtil.isNullOrEmpty(dataCountStr)) {
                    ReceiptStatisticsByAcntAndDatePlugin.this.dataCount = Integer.parseInt(dataCountStr);
                }
                return ReceiptStatisticsByAcntAndDatePlugin.this.dataCount;
            }
        });
    }

    private DynamicObjectCollection getCollection(Long bankVersionID, Long finalBankLoginId, Long acntID, Date startDate, Date endDate, String customID, int pageIndex, int pageSize) {
        DynamicObjectCollection dCollection = QueryServiceHelper.query((String)ENTITY_KEY, (String)"id, bank_version_name, accno, trans_date, receipt_num, detail_num, match_num, upload_num, complete_pc, match_pc, upload_pc,bank_login_name,zip_names,file_num,billno", null);
        QFilter[] qFilters = new QFilter[3];
        qFilters[0] = new QFilter("custom_id", "=", (Object)customID);
        qFilters[1] = QFilter.of((String)"trans_date>=? and trans_date<=?", (Object[])new Object[]{startDate, endDate});
        if (acntID == null) {
            if (bankVersionID != null) {
                qFilters[2] = new QFilter("bank_version.id", "=", (Object)bankVersionID);
            }
            if (finalBankLoginId != null) {
                qFilters[2] = new QFilter("bank_login.id", "=", (Object)finalBankLoginId);
            }
        } else {
            qFilters[2] = new QFilter("acc_no.id", "=", (Object)acntID);
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_KEY_RECEIPT_DOWNLOAD_TASK, (String)"id,trans_date, receipt_num, detail_num, match_num, upload_num, bank_version, acc_no,bank_login,zip_names,zip_names_tag,file_num", (QFilter[])qFilters, (String)"trans_date desc, acc_no", (int)pageIndex, (int)pageSize);
        DynamicObjectCollection count = QueryServiceHelper.query((String)ENTITY_KEY_RECEIPT_DOWNLOAD_TASK, (String)"count(1) as count_num", (QFilter[])qFilters);
        if (count.size() > 0) {
            this.dataCount = ((DynamicObject)count.get(0)).getInt("count_num");
        }
        if (dynamicObjects.length > 0) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                String zipNames = dynamicObjects[i].getString("zip_names_tag");
                int file_num = dynamicObjects[i].getInt("file_num");
                DynamicObject data = dCollection.addNew();
                data.set("zip_names", (Object)zipNames);
                data.set("file_num", (Object)file_num);
                data.set("billno", (Object)(dynamicObjects[i].getString("acc_no.id") + "_" + DateUtil.formatDate((Date)dynamicObjects[i].getDate("trans_date"), (String)"yyyy-MM-dd")));
                data.set("id", (Object)dynamicObjects[i].getString("id"));
                data.set("bank_version_name", (Object)(dynamicObjects[i].getString("bank_version.name") + "(" + dynamicObjects[i].getString("bank_version.number") + ")"));
                data.set("accno", (Object)dynamicObjects[i].getString("acc_no.number"));
                data.set("trans_date", (Object)dynamicObjects[i].getDate("trans_date"));
                data.set("bank_login_name", (Object)dynamicObjects[i].getString("bank_login.number"));
                int receiptCount = dynamicObjects[i].getInt("receipt_num");
                int detailCount = dynamicObjects[i].getInt("detail_num");
                int matchCount = dynamicObjects[i].getInt("match_num");
                int uploadCount = dynamicObjects[i].getInt("upload_num");
                ReceiptStatisticsUtil.buildStatisticsResult(receiptCount, detailCount, matchCount, uploadCount, data);
            }
        }
        return dCollection;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("search".equals(formOperate.getOperateKey())) {
            String selectedBankId = this.getPageCache().get("selectedBankId");
            String selectedBankLoginId = this.getPageCache().get("selectedBankLoginId");
            String selectedAcntId = this.getPageCache().get("selectedAcntId");
            String startDateTime = this.getPageCache().get("startDateTime");
            if (StringUtils.isEmpty((String)selectedBankId) && StringUtils.isEmpty((String)selectedBankLoginId) && StringUtils.isEmpty((String)selectedAcntId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6\u81f3\u5c11\u9009\u62e9\u94f6\u884c\u7248\u672c/\u524d\u7f6e\u673a\u7f16\u53f7/\u94f6\u884c\u8d26\u53f7\u4e2d\u7684\u4e00\u9879\u3002", (String)"ReceiptStatisticsByAcntAndDatePlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isEmpty((String)startDateTime)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u56de\u5355\u65e5\u671f\u3002", (String)"ReceiptStatisticsByAcntAndDatePlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().invokeOperation("refresh");
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        boolean isInit = StringUtil.isNullOrEmpty(this.getView().getPageCache().get("initCacheKey"));
        if (isInit) {
            String startDateTime = LocalDateUtil.formatDate((LocalDate)LocalDate.now().minusDays(1L), (String)"yyyy-MM-dd") + " 00:00:00";
            String endDateTime = LocalDateUtil.formatDate((LocalDate)LocalDate.now().minusDays(1L), (String)"yyyy-MM-dd") + " 23:59:59";
            this.getPageCache().put("startDateTime", startDateTime);
            this.getPageCache().put("endDateTime", endDateTime);
            this.getView().getPageCache().put("initCacheKey", "YES");
        }
        super.filterContainerInit(args);
        this.getView().getPageCache().put("initCacheKey", "NO");
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String billNo;
        ListSelectedRow listSelectedRow;
        BillListHyperLinkClickEvent billListHyperLinkClickEvent;
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)8);
        if (Objects.equals("receipt_num", args.getFieldName())) {
            args.setCancel(true);
            billListHyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            listSelectedRow = billListHyperLinkClickEvent.getCurrentRow();
            billNo = listSelectedRow.getBillNo();
            if (StringUtil.isNotNil(billNo)) {
                String transDateStr = billNo.split("_")[1];
                String accNoId = billNo.split("_")[0];
                customParams.put("accNoId", Long.parseLong(accNoId));
                customParams.put("transDateStr", transDateStr);
            }
            customParams.put("fromId", "receipt_stats_by_ac_day");
            ShowPageUtil.showListPage("receipt_result", customParams, this.getView());
        }
        if (Objects.equals("detail_num", args.getFieldName())) {
            args.setCancel(true);
            billListHyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            listSelectedRow = billListHyperLinkClickEvent.getCurrentRow();
            billNo = listSelectedRow.getBillNo();
            if (StringUtil.isNotNil(billNo)) {
                Long fid = (Long)listSelectedRow.getPrimaryKeyValue();
                String transDateStr = billNo.split("_")[1];
                String accNoId = billNo.split("_")[0];
                this.updateTaskTransNum(Long.parseLong(accNoId), transDateStr, fid);
                customParams.put("accNoId", Long.parseLong(accNoId));
                customParams.put("transDateStr", transDateStr);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"aqap_bank_acnt", (String)"id, currency.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(accNoId))});
                customParams.put("currencyId", dynamicObject.getLong("currency.id"));
                customParams.put("fromId", "receipt_stats_by_ac_day");
            }
            customParams.put("fromId", "receipt_stats_by_ac_day");
            ShowPageUtil.showListPage("aqap_bank_acnt_detail", customParams, this.getView());
        }
    }

    public void updateTaskTransNum(Long accNoId, String transDateStr, Long fid) {
        if (accNoId != null) {
            try {
                BankAcntRepository bankAcntRepository = BankAcntRepository.getInstance();
                DynamicObject dynamicObject = bankAcntRepository.findById(accNoId);
                if (dynamicObject != null) {
                    DownloadTaskService downloadTaskService;
                    DownloadListTask tasks;
                    int dataCount;
                    Date startDate = DateUtil.string2Date((String)transDateStr, (String)"yyyy-MM-dd");
                    Date endDate = DateUtil.string2Date((String)transDateStr, (String)"yyyy-MM-dd");
                    String accNo = dynamicObject.getString("number");
                    QFilter[] qFilters = new QFilter[]{new QFilter("acc_no", "=", (Object)accNo), QFilter.of((String)"trans_date>=? and trans_date<=?", (Object[])new Object[]{startDate, endDate})};
                    DynamicObjectCollection count = QueryServiceHelper.query((String)"aqap_bd_detailinfo", (String)"count(1) as count_num", (QFilter[])qFilters);
                    if (count.size() > 0 && (dataCount = ((DynamicObject)count.get(0)).getInt("count_num")) > 0 && (tasks = (downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class)).findById(fid.longValue())) != null && dataCount != tasks.getTxDetailNum()) {
                        tasks.setTxDetailNum(Integer.valueOf(dataCount));
                        downloadTaskService.update(tasks);
                    }
                }
            }
            catch (Throwable e) {
                this.logger.monitorError("ReceiptStatisticsByAcntAndDatePlugin#updateTaskTransNum#error", e);
            }
        }
    }
}

