/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.statistics;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.common.core.utils.EBGStringUtils;
import kd.ebg.receipt.formplugin.plugin.common.CompareEnum;
import kd.ebg.receipt.formplugin.plugin.common.EbgBankVersionFilterContainerPlugin;
import kd.ebg.receipt.formplugin.util.ReceiptStatisticsUtil;
import org.eclipse.jetty.util.StringUtil;

public class ReceiptStatisticsByBankVersionAndDatePlugin
extends EbgBankVersionFilterContainerPlugin {
    private static final String ENTITY_KEY = "receipt_stats_by_bk_day";
    private static final String ENTITY_KEY_RECEIPT_INFO = "receipt_info";
    private static final String ENTITY_KEY_RECEIPT_DETAIL = "receipt_detail";
    private static final String ENTITY_KEY_RECEIPT_DOWNLOAD_TASK = "receipt_download_task";
    private int dataCount = 0;

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Object object;
        super.filterContainerSearchClick(args);
        String bankVersionId = "";
        String startDateTime = "";
        String endDateTime = "";
        bankVersionId = String.valueOf(args.getFilterValue("bank_version.id"));
        if ("null".equalsIgnoreCase(bankVersionId)) {
            bankVersionId = "";
        }
        if ((object = args.getFilterValue("trans_date")) instanceof List) {
            List list = (List)object;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                if (list.size() == 2) {
                    startDateTime = this.timeTranslate(sdf.parse((String)list.get(0) + " 00:00:00"));
                    endDateTime = this.timeTranslate(sdf.parse((String)list.get(1) + " 00:00:00"));
                } else if (list.size() == 1) {
                    startDateTime = this.timeTranslate(sdf.parse(CompareEnum.getCompareEnumByID((String)list.get(0)).getStartDate()));
                    endDateTime = this.timeTranslate(sdf.parse(CompareEnum.getCompareEnumByID((String)list.get(0)).getEndDate()));
                }
            }
            catch (ParseException e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\u3002", (String)"ReceiptStatisticsByBankVersionAndDatePlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]), (Throwable)e);
            }
        }
        this.getPageCache().put("selectedBankId", bankVersionId);
        this.getPageCache().put("startDateTime", startDateTime);
        this.getPageCache().put("endDateTime", endDateTime);
    }

    public String timeTranslate(Object dateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date time = (Date)dateStr;
        String timeFormat = sdf.format(time);
        return timeFormat;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        final String customID = RequestContext.get().getTenantId();
        String bankVersionId = "";
        String startDateTime = "";
        String endDateTime = "";
        bankVersionId = this.getPageCache().get("selectedBankId");
        startDateTime = this.getPageCache().get("startDateTime");
        endDateTime = this.getPageCache().get("endDateTime");
        if (EBGStringUtils.isEmpty((String)startDateTime) || EBGStringUtils.isEmpty((String)endDateTime)) {
            return;
        }
        final String finalBankVersionId = bankVersionId;
        final String finalStartDateTime = startDateTime;
        final String finalEndDateTime = endDateTime;
        final IPageCache iPageCache = this.getPageCache();
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                int currentPage = start / limit;
                int pageSize = limit;
                DynamicObjectCollection dObjectCollection = ReceiptStatisticsByBankVersionAndDatePlugin.this.getCollection(finalBankVersionId, finalStartDateTime, finalEndDateTime, customID, currentPage, pageSize);
                this.getQueryResult().setCollection(dObjectCollection);
                this.getQueryResult().setDataCount(ReceiptStatisticsByBankVersionAndDatePlugin.this.dataCount);
                iPageCache.put("dataCount", ReceiptStatisticsByBankVersionAndDatePlugin.this.dataCount + "");
                return dObjectCollection;
            }

            public int getRealCount() {
                String dataCountStr = iPageCache.get("dataCount");
                if (!kd.ebg.receipt.formplugin.util.StringUtil.isNullOrEmpty(dataCountStr)) {
                    ReceiptStatisticsByBankVersionAndDatePlugin.this.dataCount = Integer.parseInt(dataCountStr);
                }
                return ReceiptStatisticsByBankVersionAndDatePlugin.this.dataCount;
            }
        });
    }

    private DynamicObjectCollection getCollection(String bankVersionID, String startDateTime, String endDateTime, String customID, int pageIndex, int pageSize) {
        DynamicObjectCollection dCollection = QueryServiceHelper.query((String)ENTITY_KEY, (String)"id, bank_version_name, trans_date, receipt_num, detail_num, match_num, upload_num, complete_pc, match_pc, upload_pc", null);
        QFilter[] qFilters = new QFilter[3];
        qFilters[0] = new QFilter("custom_id", "=", (Object)customID);
        LocalDate startDate = LocalDate.parse(startDateTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDate endDate = LocalDate.parse(endDateTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        qFilters[1] = QFilter.of((String)"trans_date>=? and trans_date<=?", (Object[])new Object[]{startDate, endDate});
        if (StringUtil.isNotBlank((String)bankVersionID)) {
            qFilters[2] = new QFilter("bank_version", "=", (Object)bankVersionID);
            long bankVersionId = Long.parseLong(bankVersionID);
            qFilters[2] = new QFilter("bank_version", "=", (Object)bankVersionId);
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_KEY_RECEIPT_INFO, (String)"bank_version, trans_date, file_num, custom_id, batch_no", (QFilter[])qFilters, (String)"trans_date desc, bank_version.number", (int)pageIndex, (int)pageSize);
        DynamicObjectCollection count = QueryServiceHelper.query((String)ENTITY_KEY_RECEIPT_INFO, (String)"count(1) as count_num", (QFilter[])qFilters);
        if (count.size() > 0) {
            this.dataCount = ((DynamicObject)count.get(0)).getInt("count_num");
        }
        if (dynamicObjects.length > 0) {
            for (DynamicObject receiptInfo : dynamicObjects) {
                DynamicObject data = dCollection.addNew();
                data.set("id", (Object)(receiptInfo.getString("bank_version.number") + "_" + receiptInfo.getString("trans_date")));
                data.set("bank_version_name", (Object)(receiptInfo.getString("bank_version.name") + "(" + receiptInfo.getString("bank_version.number") + ")"));
                data.set("trans_date", (Object)receiptInfo.getString("trans_date"));
                DynamicObjectCollection statistics = QueryServiceHelper.query((String)ENTITY_KEY_RECEIPT_DOWNLOAD_TASK, (String)"sum(receipt_num) as receipt_num, sum(detail_num) as detail_num, sum(match_num) as match_num, sum(upload_num) as upload_num", (QFilter[])new QFilter("batch_no", "=", (Object)receiptInfo.getString("batch_no")).toArray());
                ReceiptStatisticsUtil.buildStatisticsResult(statistics, data);
            }
        }
        return dCollection;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("search".equals(formOperate.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        boolean isInit = kd.ebg.receipt.formplugin.util.StringUtil.isNullOrEmpty(this.getView().getPageCache().get("initCacheKey"));
        if (isInit) {
            String startDateTime = LocalDateUtil.formatDate((LocalDate)LocalDate.now().minusDays(1L), (String)"yyyy-MM-dd") + " 00:00:00";
            String endDateTime = LocalDateUtil.formatDate((LocalDate)LocalDate.now().minusDays(1L), (String)"yyyy-MM-dd") + " 23:59:59";
            this.getPageCache().put("startDateTime", startDateTime);
            this.getPageCache().put("endDateTime", endDateTime);
            this.getView().getPageCache().put("initCacheKey", "YES");
        }
        super.filterContainerInit(args);
        this.getView().getPageCache().put("initCacheKey", "NO");
    }
}

