/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.statistics;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.id.ID;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.front.api.boot.utils.StringUtils;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.ebg.receipt.formplugin.plugin.common.EbgCommonFilterContainerPlugin;
import kd.ebg.receipt.formplugin.plugin.util.ShowPageUtil;
import kd.ebg.receipt.formplugin.service.info.InfoService;
import kd.ebg.receipt.formplugin.util.CosmicDateUtil;
import kd.ebg.receipt.formplugin.util.LocalDateUtils;
import kd.ebg.receipt.formplugin.util.ReceiptStatisticsUtil;
import kd.ebg.receipt.formplugin.util.StringUtil;

public class ReceiptStatisticsByBankVersionAndMonthPlugin
extends EbgCommonFilterContainerPlugin
implements HyperLinkClickListener {
    private InfoService infoService = (InfoService)SpringContextUtil.getBean(InfoService.class);
    private EBGLogger logger = EBGLogger.getInstance().getLogger(ReceiptStatisticsByBankVersionAndMonthPlugin.class);
    private int dataCount = 0;
    private static final String ENTITY_KEY = "receipt_stats_by_bk_mon";
    private static final String ENTITY_KEY_RECEIPT_DOWNLOAD_TASK = "receipt_download_task";
    private BankVersionRepository bankVersionRepository = BankVersionRepository.getInstance();
    private static Map<String, Map<String, JSONObject>> list = Maps.newHashMapWithExpectedSize((int)16);

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        final String customID = RequestContext.get().getTenantId();
        String startDateTime = "";
        String endDateTime = "";
        Long bankVersionId = null;
        String bankVersionIdStr = this.getPageCache().get("selectedBankId");
        startDateTime = this.getPageCache().get("startDateTime");
        endDateTime = this.getPageCache().get("endDateTime");
        if (!StringUtils.isEmpty((String)bankVersionIdStr)) {
            bankVersionId = Long.parseLong(bankVersionIdStr);
        }
        if (StringUtils.isBlank((String)startDateTime) || StringUtils.isBlank((String)endDateTime)) {
            return;
        }
        LocalDate startDate = LocalDate.parse(startDateTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDate endDate = LocalDate.parse(endDateTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        if (LocalDate.now().isBefore(startDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u90fd\u5927\u4e8e\u4eca\u5929\u3002", (String)"ReceiptStatisticsByBankVersionAndMonthPlugin_2", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
            return;
        }
        if (LocalDate.now().isBefore(endDate)) {
            endDate = LocalDate.now();
            endDateTime = LocalDateUtil.formatDate((LocalDate)endDate, (String)"yyyy-MM-dd");
        }
        final Long finalBankVersionId = bankVersionId;
        final String finalStartDateTime = startDateTime;
        final String finalEndDateTime = endDateTime;
        final IPageCache iPageCache = this.getPageCache();
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                int currentPage = start / limit;
                int pageSize = limit;
                DynamicObjectCollection dObjectCollection = ReceiptStatisticsByBankVersionAndMonthPlugin.this.getCollection(finalBankVersionId, finalStartDateTime, finalEndDateTime, customID, currentPage, pageSize);
                this.getQueryResult().setCollection(dObjectCollection);
                this.getQueryResult().setDataCount(ReceiptStatisticsByBankVersionAndMonthPlugin.this.dataCount);
                iPageCache.put("dataCount", ReceiptStatisticsByBankVersionAndMonthPlugin.this.dataCount + "");
                return dObjectCollection;
            }

            public int getRealCount() {
                String dataCountStr = iPageCache.get("dataCount");
                if (!StringUtil.isNullOrEmpty(dataCountStr)) {
                    ReceiptStatisticsByBankVersionAndMonthPlugin.this.dataCount = Integer.parseInt(dataCountStr);
                }
                return ReceiptStatisticsByBankVersionAndMonthPlugin.this.dataCount;
            }
        });
    }

    private DynamicObjectCollection getCollection(Long bankVersionID, String startDateTime, String endDateTime, String customID, int pageIndex, int pageSize) {
        DynamicObjectCollection dCollection = QueryServiceHelper.query((String)ENTITY_KEY, (String)"id, bank_version_name, trans_month, receipt_num, detail_num, match_num, upload_num, complete_pc, match_pc, upload_pc", null);
        HashMap bankVersionMap = Maps.newHashMapWithExpectedSize((int)8);
        if (bankVersionID != null) {
            DynamicObject bankVersion = this.bankVersionRepository.loadDynamicObjectByID(bankVersionID);
            bankVersionMap.put(bankVersion.getString("number"), bankVersion);
        } else {
            DynamicObject[] banVersions = this.bankVersionRepository.loadEnableDynamicObjects();
            if (banVersions == null || banVersions.length == 0) {
                return dCollection;
            }
            ArrayList<Long> ids = new ArrayList<Long>(16);
            for (DynamicObject bankVersion : banVersions) {
                ids.add(bankVersion.getLong("id"));
                bankVersionMap.put(bankVersion.getString("number"), bankVersion);
            }
        }
        Date startDate = DateUtil.string2Date((String)startDateTime, (String)"yyyy-MM-dd");
        Date endDate = DateUtil.string2Date((String)endDateTime, (String)"yyyy-MM-dd");
        String startDateStr = DateUtil.formatDate((Date)startDate, (String)"yyyy-MM-dd");
        String endDateStr = DateUtil.formatDate((Date)endDate, (String)"yyyy-MM-dd");
        List<String> betweenMonths = LocalDateUtils.getMonthBetweenTrans(startDateStr, endDateStr);
        ArrayList<JSONObject> recordList = new ArrayList<JSONObject>(1);
        String userId = RequestContext.get().getCurrUserId() + "";
        HashMap map = Maps.newHashMapWithExpectedSize((int)10);
        for (int i = betweenMonths.size() - 1; i >= 0; --i) {
            String month = betweenMonths.get(i);
            String startDateByMonthStr = LocalDateUtils.getStartDateByMonth(month);
            String endDateByMonthStr = LocalDateUtils.getEndDateByMonth(month);
            Date startDateByMonth = DateUtil.string2Date((String)startDateByMonthStr, (String)"yyyyMMdd");
            Date endDateByMonth = DateUtil.string2Date((String)endDateByMonthStr, (String)"yyyyMMdd");
            startDateByMonthStr = DateUtil.formatDate((Date)startDateByMonth, (String)"yyyy-MM-dd");
            endDateByMonthStr = DateUtil.formatDate((Date)endDateByMonth, (String)"yyyy-MM-dd");
            StringBuilder sql = new StringBuilder("SELECT B.fnumber AS bankversion,   SUM(A.fdetail_num) AS detail_num, SUM(A.freceipt_num) AS receipt_num,          SUM(A.fmatch_num) AS match_num, SUM(A.fupload_num) AS upload_num               FROM t_receipt_download_task as A                    ,t_aqap_bank as B WHERE  B.FId=A.fbank_version AND A.ftrans_date >= {ts'%s 00:00:00'} AND A.ftrans_date <= {ts'%s 00:00:00'} AND A.fcustom_id='%s' ");
            if (bankVersionID != null) {
                sql.append(" AND A.FBANK_VERSION = ").append(bankVersionID).append(" ");
            } else {
                sql.append(" AND B.FENABLE = '1'       ");
            }
            sql.append("group by B.fnumber   ");
            String sqlStr = String.format(sql.toString(), startDateByMonthStr, endDateByMonthStr, RequestContext.get().getTenantId());
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)ENTITY_KEY_RECEIPT_DOWNLOAD_TASK);
            String monthStr = String.format("%s-%s", month.substring(0, 4), month.substring(4));
            try (DataSet ds = DB.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".query"), (DBRoute)new DBRoute(dataEntityType.getDBRouteKey()), (String)sqlStr);){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    String bankVersion = row.getString("bankversion");
                    String bankVersionName = ((DynamicObject)bankVersionMap.get(bankVersion)).getString("name") + "(" + bankVersion + ")";
                    String bankVersionId = ((DynamicObject)bankVersionMap.get(bankVersion)).getString("id");
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("receipt_num", (Object)row.getInteger("receipt_num"));
                    jsonObject.put("detail_num", (Object)row.getInteger("detail_num"));
                    jsonObject.put("match_num", (Object)row.getInteger("match_num"));
                    jsonObject.put("upload_num", (Object)row.getInteger("upload_num"));
                    jsonObject.put("bankVersionName", (Object)bankVersionName);
                    jsonObject.put("bankVersion", (Object)bankVersion);
                    jsonObject.put("bankVersionId", (Object)bankVersionId);
                    jsonObject.put("monthStr", (Object)monthStr);
                    recordList.add(jsonObject);
                }
                continue;
            }
            catch (Exception ex) {
                this.logger.monitorInfo(ex.getMessage());
            }
        }
        List pageRecordList = StringUtil.limitByIndexAndSize(recordList, pageIndex, pageSize);
        for (JSONObject jsonObject : pageRecordList) {
            String bankVersionName = jsonObject.getString("bankVersionName");
            String monthStr = jsonObject.getString("monthStr");
            this.installCollection(dCollection, jsonObject, bankVersionName, monthStr, map);
        }
        list.put(userId, map);
        this.dataCount = recordList.size();
        return dCollection;
    }

    public void installCollection(DynamicObjectCollection dCollection, JSONObject jsonObject, String bankVersionName, String monthStr, Map<String, JSONObject> map) {
        DynamicObject data = dCollection.addNew();
        String bankVersion = jsonObject.getString("bankVersion");
        String bankVersionId = jsonObject.getString("bankVersionId");
        String id = ID.genLongId() + "";
        data.set("id", (Object)id);
        data.set("bank_version_name", (Object)bankVersionName);
        data.set("trans_month", (Object)monthStr);
        int receiptCount = jsonObject.getInteger("receipt_num");
        int detailCount = jsonObject.getInteger("detail_num");
        int matchCount = jsonObject.getInteger("match_num");
        int uploadCount = jsonObject.getInteger("upload_num");
        JSONObject detailJson = new JSONObject();
        detailJson.put("bank_version_name", (Object)bankVersion);
        detailJson.put("trans_month", (Object)monthStr);
        detailJson.put("bank_version_id", (Object)bankVersionId);
        map.put(id, detailJson);
        ReceiptStatisticsUtil.buildStatisticsResult(receiptCount, detailCount, matchCount, uploadCount, data);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRowCollection;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("search".equals(formOperate.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        }
        if ("defect".equals(formOperate.getOperateKey()) && (listSelectedRowCollection = args.getListSelectedData()) != null && listSelectedRowCollection.size() > 0) {
            listSelectedRowCollection.forEach(selectedRow -> {
                Long fid = (Long)selectedRow.getPrimaryKeyValue();
                HashMap customParams = Maps.newHashMapWithExpectedSize((int)8);
                String userId = RequestContext.get().getCurrUserId() + "";
                if (list == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u754c\u9762\u7f13\u5b58\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u540e\u91cd\u8bd5\u3002", (String)"ReceiptStatisticsByBankVersionAndMonthPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Map<String, JSONObject> rowMap = list.get(userId);
                if (rowMap == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u754c\u9762\u7f13\u5b58\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u540e\u91cd\u8bd5\u3002", (String)"ReceiptStatisticsByBankVersionAndMonthPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (rowMap != null && rowMap.containsKey(fid.toString())) {
                    JSONObject jsonObject = rowMap.get(fid.toString());
                    String bankVersion = jsonObject.getString("bank_version_name");
                    String bankVersionId = jsonObject.getString("bank_version_id");
                    String transDateStr = jsonObject.getString("trans_month");
                    String[] transArrays = transDateStr.split("-");
                    String year = transArrays[0];
                    String month = transArrays[1];
                    customParams.put("month", month);
                    customParams.put("year", year);
                    customParams.put("bankVersionName", bankVersion);
                    customParams.put("bankVersionId", bankVersionId);
                }
                customParams.put("fromId", ENTITY_KEY);
                args.setCancel(true);
                ShowPageUtil.showListPage("receipt_defect_sta_by_mon", customParams, this.getView());
            });
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        boolean isInit = StringUtil.isNullOrEmpty(this.getView().getPageCache().get("initCacheKey"));
        if (isInit) {
            String startDateTime = CosmicDateUtil.getMonthFirstDay(LocalDate.now().minusMonths(1L));
            String endDateTime = CosmicDateUtil.getMonthEndDay(LocalDate.now().minusMonths(1L));
            this.getPageCache().put("startDateTime", startDateTime);
            this.getPageCache().put("endDateTime", endDateTime);
            this.getView().getPageCache().put("initCacheKey", "YES");
        }
        super.filterContainerInit(args);
        this.getView().getPageCache().put("initCacheKey", "NO");
    }

    public void registerListener(EventObject e) {
        BillList entryGrid = (BillList)this.getView().getControl("billlistap");
        if (entryGrid != null) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)8);
        if (Objects.equals("bank_version_name", args.getFieldName())) {
            args.setCancel(true);
            BillListHyperLinkClickEvent billListHyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            ListSelectedRow listSelectedRow = billListHyperLinkClickEvent.getCurrentRow();
            Long id = (Long)listSelectedRow.getPrimaryKeyValue();
            String userId = RequestContext.get().getCurrUserId() + "";
            Map<String, JSONObject> rowMap = list.get(userId);
            if (rowMap != null && rowMap.containsKey(id.toString())) {
                JSONObject jsonObject = rowMap.get(id.toString());
                String bankVersion = jsonObject.getString("bank_version_name");
                String bankVersionId = jsonObject.getString("bank_version_id");
                String transDateStr = jsonObject.getString("trans_month");
                String[] transArrays = transDateStr.split("-");
                String year = transArrays[0];
                String month = transArrays[1];
                customParams.put("month", month);
                customParams.put("year", year);
                customParams.put("bankVersionName", bankVersion);
                customParams.put("bankVersionId", bankVersionId);
                customParams.put("fromId", ENTITY_KEY);
                ShowPageUtil.showListPage("receipt_defect_sta_by_mon", customParams, this.getView());
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }
}

