/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.plugin.task;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.framework.utils.ReceiptCommonAipUtil;
import kd.ebg.receipt.common.utils.SpringContextUtil;
import kd.ebg.receipt.formplugin.util.LocalDateUtils;

public class ReceiptTaskNeedCreateFormPlugin
extends AbstractListPlugin {
    private DownloadTaskService downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    private BankAcntRepository bankAcntRepository = BankAcntRepository.getInstance();

    public void afterCreateNewData(EventObject e) {
        this.showData();
    }

    private void showData() {
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        if (!CollectionUtils.isEmpty((Map)paramMap)) {
            DynamicObjectCollection acntDynamicObjectList;
            String transDate = (String)paramMap.get("trans_date");
            String bankVersionID = (String)paramMap.get("bank_version_id");
            Date date = DateUtil.string2Date((String)transDate, (String)"yyyy-MM-dd");
            this.getPageCache().put("trans_date", transDate);
            this.getPageCache().put("bank_version_id", bankVersionID);
            QFilter[] qFilters = new QFilter[2];
            qFilters[0] = QFilter.of((String)"group.number=? and enable=? and has_receipt=?", (Object[])new Object[]{bankVersionID, "1", Character.valueOf('1')});
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"receipt_download_task", (String)"distinct(acc_no) as acc_no", (QFilter[])new QFilter[]{QFilter.of((String)"bank_version.number=? and trans_date=?", (Object[])new Object[]{bankVersionID, date})});
            if (dynamicObjects != null && dynamicObjects.size() > 0) {
                ArrayList<Long> acntIds = new ArrayList<Long>(dynamicObjects.size());
                for (DynamicObject dynamicObject : dynamicObjects) {
                    acntIds.add(dynamicObject.getLong("acc_no"));
                }
                qFilters[1] = new QFilter("id", "not in", acntIds);
            }
            if ((acntDynamicObjectList = QueryServiceHelper.query((String)"aqap_bank_acnt", (String)"id, number, name, bank_login.number as bank_login_id, bank_login, group", (QFilter[])qFilters)) != null && acntDynamicObjectList.size() > 0) {
                for (int i = 0; i < acntDynamicObjectList.size(); ++i) {
                    int row = this.getModel().createNewEntryRow("entryentity");
                    DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", row);
                    dynamicObject.set("bank_login", (Object)((DynamicObject)acntDynamicObjectList.get(i)).getString("bank_login_id"));
                    dynamicObject.set("acc_no", (Object)((DynamicObject)acntDynamicObjectList.get(i)).getString("number"));
                    dynamicObject.set("trans_date", (Object)date);
                    this.getPageCache().put("rowIndex_" + row, ((DynamicObject)acntDynamicObjectList.get(i)).getString("id"));
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"create_task_by_hand", (CharSequence)formOperate.getOperateKey())) {
            LocalDate date = LocalDateUtils.date2LocalDate(DateUtil.string2Date((String)this.getPageCache().get("trans_date"), (String)"yyyy-MM-dd"));
            String bankVersionID = this.getPageCache().get("bank_version_id");
            String customID = RequestContext.get().getTenantId();
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] rowIds = entryGrid.getSelectRows();
            if (rowIds != null && rowIds.length > 0) {
                ArrayList newTaskList = new ArrayList(16);
                List downloadListTasks = this.downloadTaskService.findByAccNoAndBankVersionIDAndTransDateBetween(null, bankVersionID, date, date);
                for (int i = 0; i < rowIds.length; ++i) {
                    Long acntId = Long.parseLong(this.getPageCache().get("rowIndex_" + i));
                    DynamicObject accObject = this.bankAcntRepository.findById(acntId);
                    String accNo = accObject.getString("number");
                    this.downloadTaskService.buildReceiptTaskDynamicObjects(downloadListTasks, accNo, newTaskList, bankVersionID, date, date, accObject, customID);
                }
                if (!CollectionUtils.isEmpty(newTaskList)) {
                    SaveServiceHelper.save((IDataEntityType)((DynamicObject)newTaskList.get(0)).getDataEntityType(), (Object[])newTaskList.toArray());
                    ReceiptCommonAipUtil.handleReceiptInfo((String)customID, (String)bankVersionID, null, (LocalDate)date, (boolean)true);
                    this.getView().invokeOperation("refresh");
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u7ecf\u521b\u5efa\u5b8c\u6bd5\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"ReceiptTaskNeedCreateFormPlugin_0", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                    this.getView().invokeOperation("refresh");
                    args.setCancel(true);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ReceiptTaskNeedCreateFormPlugin_1", (String)"ebg-receipt-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }
}

