/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.pojo.receipt;

public class InterceptorResultInfo {
    private String code;
    private String message;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static InterceptorResultInfo success() {
        InterceptorResultInfo build = InterceptorResultInfo.builder().code(ResultEnum.SUCCESS.name()).message(ResultEnum.SUCCESS.getDesc()).build();
        return build;
    }

    public static InterceptorResultInfo fail(String message) {
        InterceptorResultInfo resultInfo = InterceptorResultInfo.builder().code(ResultEnum.FAIL.name()).message(message).build();
        return resultInfo;
    }

    public boolean isSuccess() {
        return this.code.equals(ResultEnum.SUCCESS.name());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        String code;
        String message;

        Builder code(String code) {
            this.code = code;
            return this;
        }

        Builder message(String message) {
            this.message = message;
            return this;
        }

        public InterceptorResultInfo build() {
            InterceptorResultInfo responseEB = new InterceptorResultInfo();
            responseEB.setCode(this.code);
            responseEB.setMessage(this.message);
            return responseEB;
        }
    }

    public static enum ResultEnum {
        SUCCESS("SUCCESS"),
        FAIL("FAIL");

        private String desc;

        private ResultEnum(String desc) {
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
}

