/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.formplugin.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Base64;
import java.util.Enumeration;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import kd.ebg.egf.common.model.tenant.TenantAuth;
import kd.ebg.receipt.common.model.CertInfo;
import kd.ebg.receipt.formplugin.exception.EBBizException;
import kd.ebg.receipt.formplugin.util.StringUtil;

public class CertUtil {
    public static TenantAuth parse(InputStream inputStream) {
        TenantAuth auth = new TenantAuth();
        try {
            X509Certificate cert = X509Certificate.getInstance(inputStream);
            PublicKey publicKey = cert.getPublicKey();
            auth.setPublicKey(Base64.getEncoder().encodeToString(publicKey.getEncoded()));
            CertUtil.setTenantAuthInfo(auth, cert);
        }
        catch (CertificateException e) {
            throw new EBBizException(e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return auth;
    }

    public static void setTenantAuthInfo(TenantAuth auth, X509Certificate cert) {
        String[] messages;
        Principal subjectDN = cert.getSubjectDN();
        for (String message : messages = subjectDN.getName().split(",")) {
            String[] map = message.split("=");
            String key = map[0].trim();
            String value = map[1].trim();
            if ("CN".equals(key)) {
                auth.setCommonName(value);
                auth.setCertificateName(value);
            }
            if (!"O".equals(key)) continue;
            auth.setOrganization(value);
        }
        LocalDateTime expireTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(cert.getNotAfter().getTime()), ZoneId.systemDefault());
        auth.setExpireTime(expireTime);
    }

    public static CertInfo getPrivateKeyInfo(InputStream inputStream, String privKeyPswdString) {
        CertInfo result = new CertInfo();
        String keyAlias = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            char[] nPassword = null;
            nPassword = StringUtil.isNullOrEmpty(privKeyPswdString) ? null : privKeyPswdString.toCharArray();
            keyStore.load(inputStream, nPassword);
            Enumeration<String> enumeration = keyStore.aliases();
            if (enumeration.hasMoreElements()) {
                keyAlias = enumeration.nextElement();
            }
            Certificate certificate = keyStore.getCertificate(keyAlias);
            X509Certificate cert = X509Certificate.getInstance(certificate.getEncoded());
            LocalDateTime expireTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(cert.getNotAfter().getTime()), ZoneId.systemDefault());
            result.setCertPassword(privKeyPswdString);
            result.setExpireTime(expireTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static CertInfo getPublicKeyInfo(InputStream inputStream) {
        CertInfo result = new CertInfo();
        try {
            X509Certificate cert = X509Certificate.getInstance(inputStream);
            LocalDateTime expireTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(cert.getNotAfter().getTime()), ZoneId.systemDefault());
            result.setExpireTime(expireTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

