/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bbgb.dc.service.receipt.api;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.receipt.banks.bbgb.dc.BBGBMetaDataImpl;
import kd.ebg.receipt.banks.bbgb.dc.service.receipt.api.helper.Packer;
import kd.ebg.receipt.banks.bbgb.dc.service.receipt.api.helper.SecurityUtil;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceipt;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.common.framework.frame.EBGLogger;

public class BankReceiptCreateImpl
extends AbstractBankReceiptImpl
implements IBankReceipt {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptCreateImpl.class);

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/ebank-customer/accountDetailQuery/downEleBillPDF.do");
        factory.setHttpHeader("Content-Type", "application/json");
    }

    public String pack(BankReceiptRequest bankReceiptRequest) {
        Map paramsMap = bankReceiptRequest.getParamsMap();
        String hostFlowNo = (String)paramsMap.get("hostFlowNo");
        String bankSeqNo = (String)paramsMap.get("bankSeqNo");
        String jsonString = Packer.packDownEleBillPDF(hostFlowNo, bankSeqNo).toJSONString();
        String sign = SecurityUtil.getInstance().getSign(jsonString);
        String encry = SecurityUtil.getInstance().getEncry(jsonString);
        JSONObject detail = new JSONObject();
        detail.put("signData", (Object)sign);
        detail.put("ciphertext", (Object)encry);
        detail.put("bankCertSN", (Object)RequestContextUtils.getBankParameterValue((String)BBGBMetaDataImpl.bankPublicSN));
        return detail.toJSONString();
    }

    public BankReceiptResponseEB parse(BankReceiptRequest request, String responseStr) {
        JSONObject response = JSONObject.parseObject((String)responseStr);
        String sys_code = response.getString("sys_code");
        String sys_msg = response.getString("sys_msg");
        if (!"0".equalsIgnoreCase(sys_code)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u751f\u6210\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801\uff1a%1$s\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"BankReceiptCreateImpl_0", (String)"ebg-receipt-banks-bbgb-dc", (Object[])new Object[0]), sys_code, sys_msg));
        }
        String data = response.getString("data");
        String decry = SecurityUtil.getInstance().getDecry(data);
        JSONObject detailJson = JSONObject.parseObject((String)decry);
        String ec = detailJson.getString("ec");
        String em = detailJson.getString("em");
        if (!"0".equalsIgnoreCase(ec)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u751f\u6210\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801\uff1a%1$s\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"BankReceiptCreateImpl_0", (String)"ebg-receipt-banks-bbgb-dc", (Object[])new Object[0]), ec, em));
        }
        JSONObject dataJson = detailJson.getJSONObject("data");
        String orderState = dataJson.getString("orderState");
        String retErrorMessage = dataJson.getString("retErrorMessage");
        if (!Objects.equals(orderState, "90")) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7535\u5b50\u56de\u5355\u751f\u6210\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801\uff1a%1$s\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"BankReceiptCreateImpl_0", (String)"ebg-receipt-banks-bbgb-dc", (Object[])new Object[0]), orderState, retErrorMessage));
        }
        String fileFlowNo = dataJson.getString("fileFlowNo");
        return BankReceiptResponseEB.success((Object)fileFlowNo);
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "downEleBillPDF";
    }

    public String getBizDesc() {
        return "";
    }
}

