/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.ceb.dc.service.receipt.util.pdf;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.receipt.util.JDomExtUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class RequsetPacker {
    public static String receiptPack(int searchCount, String accNo, LocalDate transDate, String bankLoginId) {
        return RequsetPacker.receiptPack("0", searchCount, "50", "", accNo, transDate, bankLoginId);
    }

    public static String receiptPack(String billNumber, String accNo, LocalDate transDate, String bankLoginId) {
        return RequsetPacker.receiptPack("1", 1, "1", billNumber, accNo, transDate, bankLoginId);
    }

    public static String receiptPack(String operationType, int searchCount, String queryNum, String billNumber, String accNo, LocalDate transDate, String bankLoginId) {
        String cifNo = RequestContextUtils.getRunningParam((String)"cifNo");
        String userId = RequestContextUtils.getRunningParam((String)"userId");
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        String JnlDate = LocalDateUtil.formatDate((LocalDateTime)LocalDateTime.now());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HHmmss");
        String JnlTime = formatter.format(LocalDateTime.now());
        String batchID = RequsetPacker.createBatchID(cifNo);
        String clientPatchID = RequsetPacker.createClientPatchID(batchID, searchCount);
        String BeginNum = String.valueOf((searchCount - 1) * 50 + 1);
        Element root = JDomExtUtils.createRoot((String)"Transaction");
        Element systemHead = JDomUtils.addChild((Element)root, (String)"SystemHead");
        JDomUtils.addChild((Element)systemHead, (String)"Language", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"Encodeing", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"Version", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"ServiceName", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"CifNo", (String)cifNo);
        JDomUtils.addChild((Element)systemHead, (String)"UserID", (String)userId);
        JDomUtils.addChild((Element)systemHead, (String)"SyMacFlag", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"MAC", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"SyPinFlag", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"PinSeed", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"LicenseId", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"Flag", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"Note", (String)"");
        Element transHead = JDomUtils.addChild((Element)root, (String)"TransHead");
        JDomUtils.addChild((Element)transHead, (String)"TransCode", (String)"b2e005023");
        JDomUtils.addChild((Element)transHead, (String)"BatchID", (String)batchID);
        JDomUtils.addChild((Element)transHead, (String)"JnlDate", (String)JnlDate);
        JDomUtils.addChild((Element)transHead, (String)"JnlTime", (String)JnlTime);
        Element transContent = JDomUtils.addChild((Element)root, (String)"TransContent");
        Element reqData = JDomUtils.addChild((Element)transContent, (String)"ReqData");
        JDomUtils.addChild((Element)reqData, (String)"ClientPatchID", (String)clientPatchID);
        JDomUtils.addChild((Element)reqData, (String)"OperationType", (String)operationType);
        JDomUtils.addChild((Element)reqData, (String)"BillNumber", (String)billNumber);
        JDomUtils.addChild((Element)reqData, (String)"ActNo", (String)accNo);
        JDomUtils.addChild((Element)reqData, (String)"BeginDate", (String)transDateStr);
        JDomUtils.addChild((Element)reqData, (String)"EndDate", (String)transDateStr);
        JDomUtils.addChild((Element)reqData, (String)"BeginAmount", (String)"");
        JDomUtils.addChild((Element)reqData, (String)"EndAmount", (String)"");
        JDomUtils.addChild((Element)reqData, (String)"BeginNum", (String)BeginNum);
        JDomUtils.addChild((Element)reqData, (String)"QueryNum", (String)queryNum);
        String request = JDomUtils.doc2StrGBK((Document)new Document(root));
        return request;
    }

    public static String createBatchID(String cifNo) {
        String radomNum_8 = Sequence.genSequence();
        radomNum_8 = radomNum_8.substring(radomNum_8.length() - 8);
        String JnlDate = LocalDateUtil.formatDate((LocalDateTime)LocalDateTime.now());
        return cifNo + JnlDate + radomNum_8;
    }

    public static String createClientPatchID(String batchID, int index) {
        String str = "" + index;
        for (int i = 4 - str.length(); i > 0; --i) {
            str = "0" + str;
        }
        return batchID + str;
    }

    public static String receiptB2e005008Pack(String billNumber, String accNo) {
        String cifNo = RequestContextUtils.getRunningParam((String)"cifNo");
        String userId = RequestContextUtils.getRunningParam((String)"userId");
        String JnlDate = LocalDateUtil.formatDate((LocalDateTime)LocalDateTime.now());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HHmmss");
        String JnlTime = formatter.format(LocalDateTime.now());
        String batchID = RequsetPacker.createBatchID(cifNo);
        String clientPatchID = RequsetPacker.createClientPatchID(batchID, 1);
        Element root = JDomExtUtils.createRoot((String)"Transaction");
        Element systemHead = JDomUtils.addChild((Element)root, (String)"SystemHead");
        JDomUtils.addChild((Element)systemHead, (String)"Language", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"Encodeing", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"Version", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"ServiceName", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"CifNo", (String)cifNo);
        JDomUtils.addChild((Element)systemHead, (String)"UserID", (String)userId);
        JDomUtils.addChild((Element)systemHead, (String)"SyMacFlag", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"MAC", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"SyPinFlag", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"PinSeed", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"LicenseId", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"Flag", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"Note", (String)"");
        Element transHead = JDomUtils.addChild((Element)root, (String)"TransHead");
        JDomUtils.addChild((Element)transHead, (String)"TransCode", (String)"b2e005008");
        JDomUtils.addChild((Element)transHead, (String)"BatchID", (String)batchID);
        JDomUtils.addChild((Element)transHead, (String)"JnlDate", (String)JnlDate);
        JDomUtils.addChild((Element)transHead, (String)"JnlTime", (String)JnlTime);
        Element transContent = JDomUtils.addChild((Element)root, (String)"TransContent");
        Element reqData = JDomUtils.addChild((Element)transContent, (String)"ReqData");
        JDomUtils.addChild((Element)reqData, (String)"ClientPatchID", (String)clientPatchID);
        JDomUtils.addChild((Element)reqData, (String)"BillNumber", (String)billNumber);
        JDomUtils.addChild((Element)reqData, (String)"ActNo", (String)accNo);
        String request = JDomUtils.doc2StrGBK((Document)new Document(root));
        return request;
    }
}

