/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.czccb.dc.service.receipt;

import java.io.File;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.czccb.dc.service.receipt.api.DetailImpl;
import kd.ebg.receipt.banks.czccb.dc.service.receipt.api.ReceiptQueryImpl;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.utils.FileCommonUtils;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        String accNo = request.getAccNo();
        LocalDate transDate = request.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)request.getTransDate());
        String bakFilePath = FileStorageUtil.getFileBakPathByAccNoAndDate((String)"CZCCB_DC", (String)accNo, (String)LocalDateUtil.formatDate((LocalDate)transDate));
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        List<DetailInfo> detailInfos = DetailImpl.queryReceiptList(accNo, transDate);
        for (DetailInfo detailInfo : detailInfos) {
            String loanFlag = detailInfo.getReversed1();
            String transferSum = detailInfo.getExplanation();
            String seqNo = detailInfo.getReversed2();
            String transferFlowNo = detailInfo.getReceiptNo();
            String newLoanFlag = "D";
            if (loanFlag.equals("D")) {
                newLoanFlag = "1";
            }
            if (loanFlag.equals("C")) {
                newLoanFlag = "2";
            }
            ReceiptQueryImpl receiptQuery = new ReceiptQueryImpl();
            BankReceiptRequest bankReceiptRequest = BankReceiptRequest.builder().accNo(accNo).transDate(transDate).build();
            RequestContextUtils.setRunningParam((String)"loanFlag", (String)newLoanFlag);
            RequestContextUtils.setRunningParam((String)"transferSum", (String)transferSum);
            RequestContextUtils.setRunningParam((String)"seqNo", (String)seqNo);
            RequestContextUtils.setRunningParam((String)"transferFlowNo", (String)transferFlowNo);
            BankReceiptResponseEB receiptResponseEB = receiptQuery.doBiz(bankReceiptRequest);
            String base64Str = (String)receiptResponseEB.getData();
            StringBuilder fileNameBuilder = new StringBuilder();
            fileNameBuilder.append(accNo).append("_");
            fileNameBuilder.append(transDateStr).append("_");
            fileNameBuilder.append(transferFlowNo).append("_");
            fileNameBuilder.append(transferSum).append("_");
            fileNameBuilder.append(loanFlag).append("_");
            fileNameBuilder.append(seqNo).append(".pdf");
            FileCommonUtils.base64ToFile((String)base64Str, (String)(bakFilePath + File.separator + fileNameBuilder.toString()));
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            downloadListDetail.setFileLink(fileNameBuilder.toString());
            downloadListDetail.setFileName(fileNameBuilder.toString());
            result.add(downloadListDetail);
        }
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-czccb-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CZCCB_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u6ca7\u5dde\u94f6\u884c\u76f4\u8054\u7248\u56de\u5355\u6587\u4ef6\u5217\u8868\u3002", (String)"BankReceiptFetchListImpl_2", (String)"ebg-receipt-banks-czccb-dc", (Object[])new Object[0]);
    }

    public boolean isBreak() {
        return true;
    }
}

