/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.framework.receipt.parse;

import java.util.List;
import java.util.Optional;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.parse.api.IFileInfo;
import kd.ebg.receipt.common.framework.receipt.parse.impl.AbstractFileParser;

@Component
public class FileParserRegister {
    EBGLogger logger = EBGLogger.getInstance().getLogger(FileParserRegister.class);
    private List<IFileInfo> fileInfos;

    public FileParserRegister(List<IFileInfo> fileInfos) {
        this.fileInfos = fileInfos;
    }

    public IFileInfo getFileInfo(String bankVersion, String fileName) {
        Optional<IFileInfo> info = this.fileInfos.stream().filter(fileInfo -> bankVersion.equals(fileInfo.getBankVersion())).findFirst();
        if (info.isPresent()) {
            AbstractFileParser parser = (AbstractFileParser)info.get();
            try {
                parser = (AbstractFileParser)parser.getClass().newInstance();
                parser.setFileName(fileName);
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6\u56de\u5355\u7801\u89e3\u6790\u7c7b\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage(), e);
            }
            return parser;
        }
        return null;
    }
}

