/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.model.repository;

import java.time.ZoneId;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.constant.CertType;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.common.model.CertInfo;

@Component
public class CertRepository {
    private String ENTITY_NAME = "aqap_bd_cert";
    private String selectProperties = "id, bank_config_id, bank_config_value_tag, bank_config_name, bank_login_id, bank_version_id, type, custom_id, file_name, expire_time, is_alert, alert_day, cert_password";

    public CertInfo findPlateFormCertByBankVersionIDAndBankConfigID(String bankVersionID, String bankConfigId) {
        String selectProperties = "id,bank_config_id, bank_config_value_tag, custom_id, cert_password";
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.ENTITY_NAME, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bank_version_id", "=", (Object)bankVersionID), new QFilter("bank_config_id", "=", (Object)bankConfigId), new QFilter("type", "=", (Object)CertType.PLATEFORM_CER.getType())});
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            CertInfo certInfo = new CertInfo();
            certInfo.setFileContent(dynamicObject.getString("bank_config_value_tag"));
            certInfo.setCertPassword(dynamicObject.getString("cert_password"));
            certInfo.setCustomID(dynamicObject.getString("custom_id"));
            Long id = dynamicObject.getLong("id");
            certInfo.setCertID(String.valueOf(id));
            return certInfo;
        }
        return null;
    }

    public DynamicObject[] loadCertByType(String certType) {
        return BusinessDataServiceHelper.load((String)this.ENTITY_NAME, (String)this.selectProperties, (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)certType)});
    }

    public DynamicObject[] loadCertByTypeAndBankVersion(String certType, String bankVersionID) {
        return BusinessDataServiceHelper.load((String)this.ENTITY_NAME, (String)this.selectProperties, (QFilter[])new QFilter[]{new QFilter("bank_version_id", "=", (Object)bankVersionID), new QFilter("type", "=", (Object)certType)});
    }

    public DynamicObject[] loadCertByAcnt(String accno) {
        return BusinessDataServiceHelper.load((String)this.ENTITY_NAME, (String)this.selectProperties, (QFilter[])new QFilter[]{new QFilter("acnt_no", "=", (Object)accno), new QFilter("type", "=", (Object)CertType.ACNT_CER)});
    }

    public void updateCert(DynamicObject cerData, String key, String name, String bankVersionID, CertInfo certInfo, String type) {
        this.saveCert(cerData, key, name, bankVersionID, null, null, certInfo, type);
    }

    public void saveCert(DynamicObject cerData, String key, String name, String bankVersionID, String bankLoginID, String accNo, CertInfo certInfo, String type) {
        cerData.set("bank_config_id", (Object)key);
        cerData.set("bank_config_value_tag", (Object)certInfo.getFileContent());
        cerData.set("bank_config_name", (Object)name);
        if (StringUtils.isNotEmpty((String)bankVersionID)) {
            cerData.set("bank_version_id", (Object)bankVersionID);
        }
        if (StringUtils.isNotEmpty((String)bankLoginID)) {
            cerData.set("bank_login_id", (Object)bankLoginID);
        }
        if (StringUtils.isNotEmpty((String)accNo)) {
            cerData.set("acnt_no", (Object)accNo);
        }
        cerData.set("custom_id", (Object)certInfo.getCustomID());
        cerData.set("type", (Object)type);
        cerData.set("file_name", (Object)certInfo.getFileName());
        if (certInfo.getExpireTime() != null) {
            cerData.set("expire_time", (Object)Date.from(certInfo.getExpireTime().atZone(ZoneId.systemDefault()).toInstant()));
        }
        cerData.set("is_alert", (Object)certInfo.isAlert());
        cerData.set("alert_day", (Object)certInfo.getAlertDay());
        cerData.set("cert_password", (Object)certInfo.getCertPassword());
        SaveServiceHelper.save((IDataEntityType)cerData.getDataEntityType(), (Object[])new DynamicObject[]{cerData});
    }

    public void addCert(String key, String name, String bankVersionID, CertInfo certInfo, String type) {
        this.addCert(key, name, bankVersionID, null, null, certInfo, type);
    }

    public void addCert(String key, String name, String bankVersionID, String bankLoginID, String accNo, CertInfo certInfo, String type) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)this.ENTITY_NAME);
        this.saveCert(dataEntity, key, name, bankVersionID, bankLoginID, accNo, certInfo, type);
    }
}

