/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.model.repository;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.model.DetailInfo;

@Component
public class DetailInfoRepository {
    EBGLogger logger = EBGLogger.getInstance().getLogger(DetailInfoRepository.class);
    private static final String DETAILINFO_ENTITY = "aqap_bd_detailinfo";
    private static final String SELECT_ALL_PROPERTIES = "id,acc_no,bank_login_id,bank_name,bank_version_id,credit_amount,currency,custom_id,debit_amount,receipt_no";

    public List<DetailInfo> findByBankVersionIDAndTransDateBetween(String bankVersionID, LocalDate startDate, LocalDate endDate) {
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(16);
        QFilter filter = QFilter.of((String)"bank_version_id=? and trans_date>=? and trans_date<=? and enable='1' and is_key_repeat!='1'", (Object[])new Object[]{bankVersionID, startDate, endDate});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter});
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                detailInfos.add(this.transDetailInfo((DynamicObject)collection.get(i)));
            }
        }
        return detailInfos;
    }

    public void updateBatchReceiptNo(List<DetailInfo> detailInfos) {
        if (detailInfos != null) {
            int len = detailInfos.size();
            Object[] pks = new Object[len];
            for (int i = 0; i < len; ++i) {
                pks[i] = Long.parseLong(detailInfos.get(i).getId());
            }
            DynamicObjectType type = BusinessDataServiceHelper.newDynamicObject((String)DETAILINFO_ENTITY).getDynamicObjectType();
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)type);
            Map<String, DetailInfo> listDetailMap = detailInfos.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
            for (int i = 0; i < dynamicObjects.length; ++i) {
                DynamicObject dynamicObject = dynamicObjects[i];
                Long id = dynamicObject.getLong("id");
                if (!listDetailMap.containsKey(id.toString())) continue;
                DetailInfo detail = listDetailMap.get(id.toString());
                dynamicObject.set("receipt_no", (Object)detail.getReceiptNo());
                dynamicObjects[i] = dynamicObject;
            }
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    private DetailInfo transDetailInfo(DynamicObject dynamicObject) {
        DetailInfo detailInfo = new DetailInfo();
        detailInfo.setId(dynamicObject.getString("id"));
        detailInfo.setAccNo(dynamicObject.getString("acc_no"));
        detailInfo.setBankLoginID(dynamicObject.getString("bank_login_id"));
        detailInfo.setBankVersionID(dynamicObject.getString("bank_version_id"));
        detailInfo.setCreditAmount(dynamicObject.getBigDecimal("credit_amount").setScale(2));
        detailInfo.setCurrency(dynamicObject.getString("currency"));
        detailInfo.setCustomID(dynamicObject.getString("custom_id"));
        detailInfo.setDebitAmount(dynamicObject.getBigDecimal("debit_amount").setScale(2));
        detailInfo.setReceiptNo(dynamicObject.getString("receipt_no"));
        return detailInfo;
    }

    public List<DetailInfo> findByAccNoAndBankVersionIDAndTransDateBetween(String accNo, String bankVersionID, LocalDate startDate, LocalDate endDate) {
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(16);
        QFilter filter = QFilter.of((String)"acc_no=? and bank_version_id=? and trans_date>=? and trans_date<=? and enable='1' and is_key_repeat!='1'", (Object[])new Object[]{accNo, bankVersionID, startDate, endDate});
        DynamicObjectCollection collection = QueryServiceHelper.query((String)DETAILINFO_ENTITY, (String)SELECT_ALL_PROPERTIES, (QFilter[])new QFilter[]{filter});
        if (collection != null && !collection.isEmpty()) {
            for (int i = 0; i < collection.size(); ++i) {
                detailInfos.add(this.transDetailInfo((DynamicObject)collection.get(i)));
            }
        }
        return detailInfos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int countDetailByAccNoAndTransDate(String accNo, LocalDate transDate) {
        QFilter filter = QFilter.of((String)"acc_no=? and  trans_date>=? and enable='1' and is_key_repeat!='1' and trans_date<=?", (Object[])new Object[]{accNo, transDate, transDate});
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)DetailInfoRepository.class.getName(), (String)DETAILINFO_ENTITY, (String)"id", (QFilter[])filter.toArray(), (String)"");){
            int total;
            int n = total = ds.count("id", Boolean.FALSE.booleanValue());
            return n;
        }
        catch (Throwable e) {
            this.logger.error("\u7edf\u8ba1\u660e\u7ec6\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage(), e);
            return 0;
        }
    }
}

