/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.url.UrlService;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.file.CleanPathUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.receipt.common.core.utils.GZFileUtils;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.receipt.util.FileStorageUtil;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationDetail;
import kd.ebg.receipt.common.model.reconciliation.ReconciliationInfo;
import kd.ebg.receipt.common.utils.PropertiesConstantsUtils;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class FileCommonUtils {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(FileCommonUtils.class);
    private static final String FILE_NAME_SUFFIX = ".";

    public static String checkPath(String path) {
        String oldPath = path;
        String newPath = CleanPathUtil.cleanString((String)oldPath);
        if (StringUtils.isEmpty((String)newPath)) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u975e\u6cd5\u7684\u8bbf\u95ee\u8def\u5f84:%s\u3002", (String)"FileCommonUtils_5", (String)"ebg-receipt-common", (Object[])new Object[0]), oldPath));
        }
        return newPath;
    }

    public static File getFileByPath(String path) {
        if (StringUtils.isEmpty((String)path)) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u8bbf\u95ee\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FileCommonUtils_1", (String)"ebg-receipt-common", (Object[])new Object[0]));
        }
        boolean isIgnoreFileCheck = Boolean.parseBoolean(System.getProperty("isIgnoreFileCheck", "true"));
        if (isIgnoreFileCheck) {
            File file = new File(path);
            return file;
        }
        if (FileCommonUtils.isContainChinese(path)) {
            File file = new File(path);
            return file;
        }
        File file = new File(FileCommonUtils.checkPath(path));
        return file;
    }

    public static File getFileByPath(String path, String fileName) {
        path = FileCommonUtils.checkPath(path);
        if (!FileCommonUtils.isContainChinese(fileName)) {
            fileName = FileCommonUtils.checkPath(fileName);
        }
        String url = path + File.separator + fileName;
        File file = FileCommonUtils.getFileByPath(url);
        return file;
    }

    public static boolean isContainChinese(String str) {
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static List<DownloadListDetail> getDetailList(DownloadListTask task, String zipFileName) {
        List<String> fileList;
        String bankLogin = EBContext.getContext().getBankLoginID();
        ArrayList<DownloadListDetail> detailList = new ArrayList<DownloadListDetail>(16);
        String transDate = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        String bakPathParentPath = FileStorageUtil.getFileBakPath(bankLogin) + File.separator + transDate;
        String accNo = task.getAccNo();
        String bakPath = FileStorageUtil.getFileBakPathByAccNoAndDate(task.getBankVersionId(), accNo, transDate);
        if (Objects.equals(task.getBankVersionId(), "SPDB_DC")) {
            RequestContextUtils.setRunningParam("zipEncode", "GBK");
        }
        if ((fileList = FileCommonUtils.readZipFiles(bakPathParentPath + File.separator + zipFileName)) == null) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6%s\u4e0d\u5305\u542bpdf\u683c\u5f0f\u7684\u56de\u5355\u6587\u4ef6\u3002", (String)"FileCommonUtils_6", (String)"ebg-receipt-common", (Object[])new Object[0]), zipFileName));
        }
        String tempPath = bakPathParentPath + File.separator + "temp";
        if (GZFileUtils.unZipFiles(bakPathParentPath + File.separator + zipFileName, tempPath)) {
            logger.info("\u89e3\u538b\u5b8c\u6bd5...");
            ArrayList<String> parentFile = new ArrayList<String>(16);
            for (String receiptName : fileList) {
                File sourceFile;
                String parentFileName;
                receiptName = receiptName.replaceAll(":", "").replaceAll("\uff1a", "");
                logger.info("\u538b\u7f29\u5305\u91cc\u9762\u7684\u6587\u4ef6\u540d\uff1a{}-{}-{}", new Object[]{receiptName, accNo, transDate});
                if (receiptName.contains("**") && Objects.equals(task.getBankVersionId(), "SPDB_DC")) {
                    receiptName = receiptName.replace("**", File.separator);
                    logger.info("\u6d66\u53d1\u94f6\u884cwj01\u63a5\u53e3\u538b\u7f29\u5305\u89e3\u538b\u4e4b\u540e\u6587\u4ef6\u540d\uff1a{}-{}-{}", new Object[]{receiptName, accNo, transDate});
                }
                if (receiptName.contains("*") && Objects.equals(task.getBankVersionId(), "SPDB_DC")) {
                    receiptName = receiptName.replace("*", File.separator);
                    logger.info("\u6d66\u53d1\u94f6\u884cwj01\u63a5\u53e3\u538b\u7f29\u5305\u89e3\u538b\u4e4b\u540e\u6587\u4ef6\u540d\uff1a{}-{}-{}", new Object[]{receiptName, accNo, transDate});
                }
                if (!parentFile.contains(parentFileName = (sourceFile = FileCommonUtils.getFileByPath(tempPath + File.separator + receiptName)).getParentFile().getName())) {
                    parentFile.add(parentFileName);
                }
                logger.info("\u538b\u7f29\u5305\u89e3\u538b\u4e4b\u540e\u6587\u4ef6\u540d\uff1a{}-{}-{}", new Object[]{receiptName, accNo, transDate});
                String newReceiptName = receiptName.replace(".pdf", "_" + transDate + ".pdf");
                if (receiptName.contains(parentFileName)) {
                    newReceiptName = Objects.equals(task.getBankVersionId(), "SPDB_DC") ? parentFileName + "_" + transDate + ".pdf" : receiptName.substring(parentFileName.length() + 1).replace(".pdf", "_" + transDate + ".pdf");
                    if (Objects.equals(task.getBankVersionId(), "PSBC_SRDC")) {
                        newReceiptName = parentFileName + "_" + task.getAccNo() + ".pdf";
                    }
                }
                if (receiptName.contains("/") && Objects.equals(task.getBankVersionId(), "SPDB_DC")) {
                    newReceiptName = receiptName.replace("/", "_").replace(".pdf", "_" + transDate + ".pdf");
                    logger.info("\u6d66\u53d1\u94f6\u884c-\u6587\u4ef6\u540d\u5305\u542b\u76ee\u5f55\uff1a{}-\u65b0\u7684\u540d\u79f0\uff1a{}-{}-{}", new Object[]{receiptName, newReceiptName, accNo, transDate});
                    if (!sourceFile.exists() && newReceiptName.contains("[")) {
                        File[] listFile;
                        String matchStr = newReceiptName.substring(0, newReceiptName.indexOf("["));
                        logger.info("\u6d66\u53d1\u94f6\u884c-\u6587\u4ef6\u540d\u5305\u542b\u76ee\u5f55-\u67e5\u627e\u76ee\u5f55\uff1a{}-\u65b0\u7684\u540d\u79f0\uff1a{}-{}-{}", new Object[]{matchStr, newReceiptName, accNo, transDate});
                        File tempFile = FileCommonUtils.getFileByPath(tempPath);
                        for (File file : listFile = tempFile.listFiles()) {
                            File[] file1;
                            logger.info("\u6d66\u53d1\u94f6\u884c-\u6587\u4ef6\u540d\u5305\u542b\u76ee\u5f55-\u76ee\u5f55\uff1a{}-{}-{}", new Object[]{file.getName(), newReceiptName, accNo, transDate});
                            if (!file.isDirectory() || !file.getName().contains(matchStr)) continue;
                            for (File receiptFile : file1 = file.listFiles()) {
                                if (FileCommonUtils.isContainChinese(newReceiptName)) {
                                    newReceiptName = FileCommonUtils.handleUpDownTransFileName(newReceiptName, task);
                                    newReceiptName = FileCommonUtils.cleanChineseChar(newReceiptName);
                                }
                                if (!receiptFile.isDirectory() && (receiptFile.getName().endsWith(".pdf") || receiptFile.getName().endsWith(".PDF"))) {
                                    FileCommonUtils.moveFile(receiptFile, bakPath, newReceiptName);
                                }
                                if (receiptFile.isDirectory() || !receiptFile.getName().endsWith(".ofd") && !receiptFile.getName().endsWith(".OFD")) continue;
                                FileCommonUtils.moveFile(receiptFile, bakPath, newReceiptName);
                            }
                        }
                    }
                }
                if (FileCommonUtils.isContainChinese(newReceiptName)) {
                    newReceiptName = FileCommonUtils.handleUpDownTransFileName(newReceiptName, task);
                    newReceiptName = FileCommonUtils.cleanChineseChar(newReceiptName);
                }
                if (newReceiptName.contains(task.getAccNo()) && sourceFile.exists()) {
                    DownloadListDetail detail = new DownloadListDetail();
                    detail.setFileLink(receiptName);
                    detail.setFileName(newReceiptName);
                    detail.setTransDate(task.getTransDate());
                    detailList.add(detail);
                }
                if (!sourceFile.exists() || !FileCommonUtils.moveFile(sourceFile, bakPath, newReceiptName)) continue;
                logger.info("\u56de\u5355\u6587\u4ef6\u79fb\u52a8\u6210\u529f\uff1a{}-\u65b0\u7684\u540d\u79f0\uff1a{}", new Object[]{sourceFile.getName(), newReceiptName});
                boolean isDelete = sourceFile.delete();
                logger.info("\u56de\u5355\u6587\u4ef6\uff1a{}-\u662f\u5426\u5220\u9664\uff1a{}", new Object[]{sourceFile.getName(), isDelete});
            }
            logger.info("\u8f6c\u79fb\u6587\u4ef6\u5230bak\u76ee\u5f55\u5b8c\u6bd5...");
            for (String parentFileName : parentFile) {
                boolean isDelete = FileCommonUtils.getFileByPath(tempPath + File.separator + parentFileName).delete();
                logger.info("\u6587\u4ef6\u540d\uff1a{}-\u662f\u5426\u5220\u9664\uff1a{}", new Object[]{parentFileName, isDelete});
            }
            boolean isDelete = FileCommonUtils.getFileByPath(tempPath).delete();
            logger.info("\u6587\u4ef6\u540d\uff1a{}-\u662f\u5426\u5220\u9664\uff1a{}", new Object[]{tempPath, isDelete});
            isDelete = FileCommonUtils.getFileByPath(bakPathParentPath + File.separator + zipFileName).delete();
            logger.info("\u6587\u4ef6\u540d\uff1a{}-\u662f\u5426\u5220\u9664\uff1a{}", new Object[]{zipFileName, isDelete});
            logger.info("\u5220\u9664\u6587\u4ef6\u5b8c\u6bd5...");
        }
        return detailList;
    }

    public static String handleUpDownTransFileName(String fileName, DownloadListTask task) {
        if (Objects.equals(task.getBankVersionId(), "SPDB_DC") && (fileName.contains(PropertiesConstantsUtils.getValue("UP")) || fileName.contains(PropertiesConstantsUtils.getValue("ALLOCATION")) || fileName.contains(PropertiesConstantsUtils.getValue("COMPLEMENT")) || fileName.contains(PropertiesConstantsUtils.getValue("ENTRUSTED")))) {
            fileName = fileName.replace(".pdf", "");
            fileName = fileName.replace(".PDF", "");
            return fileName + "_" + "UNKNOW" + ".pdf";
        }
        return fileName;
    }

    public static String cleanChineseChar(String str) {
        String REGEX_CHINESE = ResManager.loadKDString((String)"[\u4e00-\u9fa5]", (String)"FileCommonUtils_4", (String)"ebg-receipt-common", (Object[])new Object[0]);
        Pattern pat = Pattern.compile(REGEX_CHINESE);
        Matcher mat = pat.matcher(str);
        String newStr = mat.replaceAll("");
        logger.info("\u6587\u4ef6\u540d\u5305\u542b\u4e2d\u6587\u5b57\u7b26-\u53bb\u9664\u4e2d\u6587-\u539f\u6587\u4ef6\u540d\uff1a{}\uff0c\u65b0\u6587\u4ef6\u540d\uff1a{}", new Object[]{str, newStr});
        return newStr;
    }

    public static List<ReconciliationDetail> getDetailList(ReconciliationInfo task, String zipFileName) {
        String bankLogin = EBContext.getContext().getBankLoginID();
        ArrayList<ReconciliationDetail> detailList = new ArrayList<ReconciliationDetail>(16);
        String transDate = task.getTransDate().format(DateTimeFormatter.BASIC_ISO_DATE);
        String bakPathParentPath = FileStorageUtil.getReconciliationFileBakPath(bankLogin) + File.separator + transDate;
        String accNo = task.getAccNo();
        String bakPath = FileStorageUtil.getReconciliationFileBakPathByAccNoAndDate(task.getBankVersionId(), accNo, transDate);
        List<String> fileList = FileCommonUtils.readZipFiles(bakPathParentPath + File.separator + zipFileName);
        if (fileList == null) {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6%s\u4e0d\u5305\u542bpdf\u683c\u5f0f\u7684\u56de\u5355\u6587\u4ef6\u3002", (String)"FileCommonUtils_6", (String)"ebg-receipt-common", (Object[])new Object[0]), zipFileName));
        }
        String tempPath = bakPathParentPath + File.separator + "temp";
        if (GZFileUtils.unZipFiles(bakPathParentPath + File.separator + zipFileName, tempPath)) {
            logger.info("\u89e3\u538b\u5b8c\u6bd5...");
            ArrayList<String> parentFile = new ArrayList<String>(16);
            for (String receiptName : fileList) {
                File sourceFile = FileCommonUtils.getFileByPath(tempPath + File.separator + receiptName);
                logger.info("\u538b\u7f29\u5305\u89e3\u538b\u4e4b\u540e\u6587\u4ef6\u540d\uff1a{}-{}-{}", new Object[]{receiptName, accNo, transDate});
                String parentFileName = sourceFile.getParentFile().getName();
                if (!parentFile.contains(parentFileName)) {
                    parentFile.add(parentFileName);
                }
                String newReceiptName = receiptName.replace(".pdf", "_" + transDate + ".pdf");
                logger.info("\u538b\u7f29\u5305\u6587\u4ef6\u540d\uff1a{}-\u4e0a\u7ea7\u76ee\u5f55\u540d\u79f0\uff1a{}", new Object[]{receiptName, parentFileName});
                if (receiptName.contains(parentFileName)) {
                    newReceiptName = receiptName.substring(parentFileName.length() + 1).replace(".pdf", "_" + transDate + ".pdf");
                }
                if (newReceiptName.contains(task.getAccNo())) {
                    ReconciliationDetail detail = new ReconciliationDetail();
                    detail.setFileLink(receiptName);
                    detail.setFileName(newReceiptName);
                    detail.setTransDate(task.getTransDate());
                    detailList.add(detail);
                }
                if (!sourceFile.exists() || !FileCommonUtils.moveFile(sourceFile, bakPath, newReceiptName)) continue;
                logger.info("\u56de\u5355\u6587\u4ef6\u79fb\u52a8\u6210\u529f\uff1a{}-\u65b0\u7684\u540d\u79f0\uff1a{}", new Object[]{sourceFile.getName(), newReceiptName});
                boolean isDelete = sourceFile.delete();
                logger.info("\u6587\u4ef6\u540d\uff1a{}-\u662f\u5426\u5220\u9664\uff1a{}", new Object[]{sourceFile.getName(), isDelete});
            }
            for (String parentFileName : parentFile) {
                boolean isDelete = FileCommonUtils.getFileByPath(tempPath + File.separator + parentFileName).delete();
                logger.info("\u6587\u4ef6\u540d\uff1a{}-\u662f\u5426\u5220\u9664\uff1a{}", new Object[]{parentFileName, isDelete});
            }
            boolean isDelete = FileCommonUtils.getFileByPath(tempPath).delete();
            logger.info("\u6587\u4ef6\u540d\uff1a{}-\u662f\u5426\u5220\u9664\uff1a{}", new Object[]{tempPath, isDelete});
            isDelete = FileCommonUtils.getFileByPath(bakPathParentPath + File.separator + zipFileName).delete();
            logger.info("\u6587\u4ef6\u540d\uff1a{}-\u662f\u5426\u5220\u9664\uff1a{}", new Object[]{zipFileName, isDelete});
            logger.info("\u5220\u9664\u6587\u4ef6\u5b8c\u6bd5...");
        }
        return detailList;
    }

    public static List<String> readZipFiles(String patchPath) {
        ArrayList<String> fileList = new ArrayList<String>(16);
        ZipFile zipFile = null;
        try {
            zipFile = RequestContextUtils.getRunningParam("zipEncode") != null ? new ZipFile(patchPath, RequestContextUtils.getRunningParam("zipEncode")) : new ZipFile(patchPath);
            Enumeration e = zipFile.getEntries();
            while (e.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)e.nextElement();
                if (!entry.isDirectory() && (entry.getName().endsWith(".pdf") || entry.getName().endsWith(".PDF"))) {
                    fileList.add(entry.getName());
                }
                if (entry.isDirectory() || !entry.getName().endsWith(".ofd") && !entry.getName().endsWith(".OFD")) continue;
                fileList.add(entry.getName());
            }
        }
        catch (IOException e) {
            throw new ReceiptException(e);
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception exception) {}
        }
        return fileList;
    }

    public static List<String> readTarFiles(String path) {
        ArrayList<String> fileList = new ArrayList<String>(16);
        try (FileInputStream inputStream = new FileInputStream(path);){
            TarArchiveEntry entry;
            TarArchiveInputStream fin = new TarArchiveInputStream((InputStream)inputStream);
            while ((entry = fin.getNextTarEntry()) != null) {
                if (entry.isDirectory() || !entry.getName().endsWith(".pdf") && !entry.getName().endsWith(".PDF")) continue;
                fileList.add(entry.getName());
            }
        }
        catch (Throwable e) {
            throw new ReceiptException(e);
        }
        return fileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean base64ToFile(String fileContent, String filepath) {
        logger.info("\u6b63\u5728\u4ece\u54cd\u5e94\u62a5\u6587\u4e2d\u63d0\u53d6zip\u6587\u4ef6...");
        File file = null;
        FileOutputStream out = null;
        ByteArrayInputStream in = null;
        try {
            file = FileCommonUtils.getFileByPath(filepath);
            if (!file.exists()) {
                boolean isCreate = file.createNewFile();
                logger.info("\u521b\u5efa\u6587\u4ef6\uff1a{}\uff0c\u662f\u5426\u6210\u529f\uff1a{}", new Object[]{filepath, isCreate});
            }
            byte[] bytes = Base64.getDecoder().decode(fileContent);
            in = new ByteArrayInputStream(bytes);
            byte[] buffer = new byte[1024];
            out = new FileOutputStream(file);
            int byteread = 0;
            while ((byteread = in.read(buffer)) != -1) {
                out.write(buffer, 0, byteread);
            }
            out.flush();
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
            logger.info("\u54cd\u5e94\u62a5\u6587\u4e2d\u63d0\u53d6zip\u6587\u4ef6\u5b8c\u6210");
        }
        return true;
    }

    public static boolean write2File(byte[] bytes, String filePath) {
        boolean flag = false;
        File file = FileCommonUtils.getFileByPath(filePath);
        if (!file.exists()) {
            try {
                flag = file.createNewFile();
            }
            catch (IOException e) {
                logger.error("\u65b0\u5efa\u6587\u4ef6\u53d1\u751f\u5f02\u5e38", e);
            }
        }
        if (flag) {
            flag = false;
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                ((OutputStream)outputStream).write(bytes);
                outputStream.flush();
                flag = true;
            }
            catch (Exception e) {
                logger.error("\u5199\u51fa\u6587\u4ef6\u53d1\u751f\u5f02\u5e38", e);
            }
        } else {
            logger.error("\u521b\u5efa\u6587\u4ef6:" + filePath + "\u5931\u8d25\u3002");
        }
        return flag;
    }

    public static boolean moveFile(File file, String newFilePath, String newFileName) {
        boolean isSuccess = file.renameTo(FileCommonUtils.getFileByPath(newFilePath + File.separator + newFileName));
        File newNameFile = FileCommonUtils.getFileByPath(newFilePath + File.separator + newFileName);
        if (newNameFile.exists()) {
            return true;
        }
        if (!isSuccess) {
            try {
                logger.error("rename\u65b9\u5f0f\u6587\u4ef6\u79fb\u52a8\u5931\u8d25\uff1a{} \u5c1d\u8bd5\u4f7f\u7528org.apache.commons.io.FileUtils.moveFile", new Object[]{file.getName()});
                FileUtils.moveFile((File)file, (File)newNameFile);
                File newFile = FileCommonUtils.getFileByPath(newFilePath + File.separator + newFileName);
                isSuccess = true;
                if (!newFile.exists()) {
                    logger.error("moveFile\u65b9\u5f0f\u6587\u4ef6\u79fb\u52a8\u5931\u8d25\uff1a{} \u5c1d\u8bd5\u4f7f\u7528\u6587\u4ef6\u6d41\u7684\u65b9\u5f0f\u79fb\u52a8\u6587\u4ef6", new Object[]{file.getName()});
                    isSuccess = FileCommonUtils.copyFolder(file, newFilePath, newFileName);
                }
            }
            catch (IOException e) {
                logger.error("\u6587\u4ef6\u79fb\u52a8\u9519\u8bef\uff1a{}", new Object[]{e.getMessage()});
            }
        }
        return isSuccess;
    }

    public static boolean copyFolder(File in, String newFilePath, String newFileName) {
        File out = FileCommonUtils.getFileByPath(newFilePath);
        if (!in.exists()) {
            logger.error(in.getAbsolutePath() + "\u6e90\u6587\u4ef6\u8def\u5f84\u9519\u8bef\uff01\uff01\uff01");
            return false;
        }
        if (!out.exists()) {
            out.mkdirs();
        }
        try (FileInputStream fis = new FileInputStream(in);
             FileOutputStream fos = new FileOutputStream(FileCommonUtils.getFileByPath(newFilePath + File.separator + newFileName));){
            int c;
            byte[] b = new byte[5120];
            while ((c = fis.read(b)) != -1) {
                fos.write(b, 0, c);
            }
            fos.flush();
        }
        catch (IOException e) {
            logger.error("copyFolder-error-IOException:{}", new Object[]{e.getMessage()});
            return false;
        }
        return true;
    }

    public static boolean deleteAllFile(String filePath) {
        boolean flag;
        block9: {
            flag = false;
            File deleteFile = FileCommonUtils.getFileByPath(filePath);
            if (deleteFile.exists()) {
                if (deleteFile.isDirectory()) {
                    File[] files = deleteFile.listFiles();
                    if (files != null && files.length > 0) {
                        for (File file : files) {
                            boolean isDelete = file.delete();
                            logger.info("\u6587\u4ef6\u540d\uff1a{} \u662f\u5426\u5220\u9664\uff1a{}", new Object[]{file.getName(), isDelete});
                        }
                    }
                    flag = deleteFile.delete();
                } else {
                    try {
                        flag = deleteFile.delete();
                        if (flag) {
                            logger.info("\u5220\u9664\u6587\u4ef6:" + filePath + "\u6210\u529f\u3002");
                            break block9;
                        }
                        logger.info("\u5220\u9664\u6587\u4ef6:" + filePath + "\u5931\u8d25\u3002");
                    }
                    catch (Exception e) {
                        logger.info("\u5220\u9664\u6587\u4ef6:" + filePath + "\u5931\u8d25\u3002", e);
                    }
                }
            } else {
                logger.info("\u6587\u4ef6:" + filePath + "\u4e0d\u5b58\u5728");
            }
        }
        return flag;
    }

    public static boolean isTestEnv() {
        String clientUrl = UrlService.getDomainContextUrl();
        if (clientUrl.contains("https://feature.kingdee.com:1024")) {
            return true;
        }
        if (clientUrl.contains("https://feature.kingdee.com:2019")) {
            return true;
        }
        return clientUrl.contains("localhost");
    }

    public static void deleteFile(File file) {
        if (file.delete()) {
            // empty if block
        }
    }

    public static void deleteFile(String path) {
        if (FileCommonUtils.getFileByPath(path).delete()) {
            // empty if block
        }
    }
}

