/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.common.utils.ofd;

import com.google.common.base.VerifyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import kd.ebg.receipt.common.utils.ofd.Base64Util;
import kd.ebg.receipt.common.utils.ofd.OfdErrorType;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM3Util {
    public static String doDigestToBase64Str(byte[] bytes) {
        return Base64Util.base64encoder(SM3Util.doDigest(bytes));
    }

    public static byte[] doDigest(byte[] bytes) {
        MessageDigest messageDigest = SM3Util.createMessageDigest();
        try {
            if (null != bytes) {
                messageDigest.update(bytes);
            }
            return messageDigest.digest();
        }
        catch (Exception e) {
            throw new VerifyException(OfdErrorType.HASH_ERROR.getDescription());
        }
    }

    private static MessageDigest createMessageDigest() {
        MessageDigest messageDigest;
        BouncyCastleProvider provider = new BouncyCastleProvider();
        try {
            messageDigest = null == provider ? MessageDigest.getInstance("SM3") : MessageDigest.getInstance("SM3", (Provider)provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new VerifyException(OfdErrorType.HASH_IDENTIFIES_ERROR.getDescription());
        }
        return messageDigest;
    }
}

