/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.adbc.dc.service.receipt;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.bank.info.BankRequest;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.receipt.banks.adbc.dc.service.detail.DetailImpl;
import kd.ebg.receipt.banks.adbc.dc.service.receipt.api.DownloadReceiptFileImpl;
import kd.ebg.receipt.business.detail.bank.BankDetailRequest;
import kd.ebg.receipt.business.detail.bank.EBBankDetailResponse;
import kd.ebg.receipt.business.receipt.atom.AbstractBankReceiptHandleImpl;
import kd.ebg.receipt.business.receipt.atom.IBankReceiptHandle;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptResponseEB;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleRequest;
import kd.ebg.receipt.business.receipt.bank.task.BankReceiptHandleResponseEB;
import kd.ebg.receipt.business.receipt.entity.TaskStatus;
import kd.ebg.receipt.common.framework.frame.EBGLogger;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;
import kd.ebg.receipt.common.framework.services.receipt.DownloadListDetailService;
import kd.ebg.receipt.common.framework.services.receipt.DownloadTaskService;
import kd.ebg.receipt.common.model.DetailInfo;
import kd.ebg.receipt.common.model.receipt.DownloadListDetail;
import kd.ebg.receipt.common.model.receipt.DownloadListTask;
import kd.ebg.receipt.common.utils.SpringContextUtil;

public class BankReceiptFetchListImpl
extends AbstractBankReceiptHandleImpl
implements IBankReceiptHandle {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BankReceiptFetchListImpl.class);
    public DownloadListDetailService downloadListDetailService;
    public DownloadTaskService downloadTaskService;

    public void init(BankReceiptHandleRequest request) {
        this.downloadListDetailService = (DownloadListDetailService)SpringContextUtil.getBean(DownloadListDetailService.class);
        this.downloadTaskService = (DownloadTaskService)SpringContextUtil.getBean(DownloadTaskService.class);
    }

    public boolean match(BankReceiptHandleRequest request) {
        if (request == null) {
            return false;
        }
        Integer status = request.getTaskStatus();
        if (status == null) {
            return false;
        }
        return status.intValue() == TaskStatus.PROCESSING.getId();
    }

    public BankReceiptHandleResponseEB doBiz(BankReceiptHandleRequest request) {
        this.init(request);
        long taskId = request.getTaskId();
        DownloadListTask downloadListTask = this.downloadTaskService.findById(taskId);
        List<DownloadListDetail> result = this.doJob(downloadListTask);
        if (result.size() == 0) {
            throw new ReceiptException(ResManager.loadKDString((String)"\u672c\u6b21\u4efb\u52a1\u83b7\u53d6\u7684\u56de\u5355\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a\u3002", (String)"BankReceiptFetchListImpl_0", (String)"ebg-receipt-banks-adbc-dc", (Object[])new Object[0]));
        }
        return BankReceiptHandleResponseEB.success(result);
    }

    public List<DownloadListDetail> doJob(DownloadListTask task) {
        String accNo = task.getAccNo();
        LocalDate transDate = task.getTransDate();
        List<DetailInfo> detailInfos = BankReceiptFetchListImpl.getDetailList(accNo, transDate);
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
        BankReceiptRequest request = BankReceiptRequest.builder().transDate(transDate).accNo(accNo).build();
        ArrayList<DownloadListDetail> result = new ArrayList<DownloadListDetail>(16);
        for (DetailInfo detail : detailInfos) {
            String bankSerial = detail.getPayBankDetailSeqID();
            String flag = detail.getReversed1();
            String amount = detail.getReversed2();
            String oppAccNo = detail.getOppAccNo();
            String newFileName = this.installNewFileName(task, amount, bankSerial, flag, oppAccNo);
            paramMap.put("flag", flag);
            paramMap.put("bankSerial", bankSerial);
            request.setParamsMap((Map)paramMap);
            DownloadReceiptFileImpl iBankReceipt = new DownloadReceiptFileImpl();
            BankReceiptResponseEB receiptResponseEB = (BankReceiptResponseEB)iBankReceipt.doBiz((BankRequest)request);
            String fileName = (String)receiptResponseEB.getData();
            DownloadListDetail downloadListDetail = new DownloadListDetail();
            downloadListDetail.setFileLink(fileName);
            downloadListDetail.setFileName(newFileName);
            result.add(downloadListDetail);
        }
        return result;
    }

    public String installNewFileName(DownloadListTask task, String amount, String bankSerial, String flag, String oppAccNo) {
        StringBuilder stringBuilder = new StringBuilder();
        String accNo = task.getAccNo();
        LocalDate transDate = task.getTransDate();
        String transDateStr = LocalDateUtil.formatDate((LocalDate)transDate);
        stringBuilder.append(transDateStr).append("_");
        stringBuilder.append(accNo).append("_");
        stringBuilder.append(bankSerial).append("_");
        stringBuilder.append(amount).append("_");
        stringBuilder.append(flag).append("_");
        stringBuilder.append(oppAccNo).append(".pdf");
        return stringBuilder.toString();
    }

    public static List<DetailInfo> getDetailList(String accNo, LocalDate transDate) {
        DetailImpl detail = new DetailImpl();
        BankDetailRequest request = new BankDetailRequest();
        BankHeader header = new BankHeader();
        BankAcnt acnt = new BankAcnt();
        acnt.setAccNo(accNo);
        header.setAcnt(acnt);
        request.setHeader(header);
        request.setStartDate(transDate);
        request.setEndDate(transDate);
        EBBankDetailResponse ebBankDetailResponse = detail.detail(request);
        List detailInfos = ebBankDetailResponse.getDetails();
        return detailInfos;
    }

    public boolean isBreak() {
        return true;
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "ADBC_DC_BankReceiptFetchList";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u4e2d\u56fd\u519c\u4e1a\u53d1\u5c55\u94f6\u884c\u76f4\u8054\u7248\u56de\u5355\u6587\u4ef6\u5217\u8868", (String)"BankReceiptFetchListImpl_1", (String)"ebg-receipt-banks-adbc-dc", (Object[])new Object[0]);
    }
}

