/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.receipt.banks.bsz.dc.service.receipt.api.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.receipt.banks.bsz.dc.service.receipt.api.bean.Header4Send;
import kd.ebg.receipt.banks.bsz.dc.service.receipt.api.bean.Root;
import kd.ebg.receipt.banks.bsz.dc.service.receipt.api.interfaces.OPCB000016;
import kd.ebg.receipt.banks.bsz.dc.service.receipt.api.interfaces.OPCB000027;
import kd.ebg.receipt.business.receipt.bank.frontProxy.BankReceiptRequest;
import kd.ebg.receipt.common.framework.context.RequestContextUtils;
import kd.ebg.receipt.common.framework.receipt.exception.ReceiptException;

public class Packer {
    public static Map getSendObject(Object rqst, String transCode) throws Exception {
        Root root;
        if ("OPCB000016".equals(transCode) && rqst instanceof BankReceiptRequest) {
            root = OPCB000016.getInstance().getSendRoot((BankReceiptRequest)rqst);
        } else if ("OPCB000027".equals(transCode) && rqst instanceof BankReceiptRequest) {
            root = OPCB000027.getInstance().getSendRoot((BankReceiptRequest)rqst);
        } else {
            throw new ReceiptException(String.format(ResManager.loadKDString((String)"%s-\u4ea4\u6613\u7801\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"Packer_0", (String)"ebg-receipt-banks-bsz-dc", (Object[])new Object[0]), transCode));
        }
        root = Packer.setHeader4Send(root, transCode);
        JSONObject headJsonObject = (JSONObject)JSONObject.toJSON(root.getHeader());
        Map headMap = (Map)JSONObject.toJavaObject((JSON)headJsonObject, Map.class);
        JSONObject bodyJsonObject = (JSONObject)JSONObject.toJSON(root.getBody());
        Map bodyMap = (Map)JSONObject.toJavaObject((JSON)bodyJsonObject, Map.class);
        bodyMap.putAll(headMap);
        return bodyMap;
    }

    public static Root setHeader4Send(Root root, String transCode) throws Exception {
        Header4Send header = new Header4Send();
        header.setCONSUMER_SEQ_NO(Sequence.gen18Sequence());
        header.setHOST_NO(RequestContextUtils.getBankParameterValue((String)"HOST_NO"));
        header.setSERVICE_CODE(transCode);
        header.setTRAN_DATE(LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
        header.setTRAN_TIMESTAMP(Packer.getTimeStr(LocalDateTime.now()));
        root.setHeader(header);
        return root;
    }

    public static String getTimeStr(LocalDateTime dateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        return formatter.format(dateTime);
    }
}

